/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.kpi;

import com.kingdee.bos.bi.model.common.mm.ComboBoxObject;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class KPIModel {
    private static final String DIM_TYPE_MEASURE = "measure";
    private static final String DIM_TYPE_METRIC = "metric";
    private String FID;
    private String FAMID;
    private String FMeasureFact;
    private String FMeasureDown1;
    private String FMeasureDown2;
    private String FMeasureUp1;
    private String FMeasureUp2;
    private String FDiscription;
    private List metricList;

    public String getFID() {
        return this.FID;
    }

    public void setFID(String fid) {
        this.FID = fid;
    }

    public String getFAMID() {
        return this.FAMID;
    }

    public void setFAMID(String famid) {
        this.FAMID = famid;
    }

    public String getFMeasureFact() {
        return this.FMeasureFact;
    }

    public void setFMeasureFact(String measureFact) {
        this.FMeasureFact = measureFact;
    }

    public String getFMeasureDown1() {
        return this.FMeasureDown1;
    }

    public void setFMeasureDown1(String measureDown1) {
        this.FMeasureDown1 = measureDown1;
    }

    public String getFMeasureDown2() {
        return this.FMeasureDown2;
    }

    public void setFMeasureDown2(String measureDown2) {
        this.FMeasureDown2 = measureDown2;
    }

    public String getFMeasureUp1() {
        return this.FMeasureUp1;
    }

    public void setFMeasureUp1(String measureUp1) {
        this.FMeasureUp1 = measureUp1;
    }

    public String getFMeasureUp2() {
        return this.FMeasureUp2;
    }

    public void setFMeasureUp2(String measureUp2) {
        this.FMeasureUp2 = measureUp2;
    }

    public String getFDiscription() {
        return this.FDiscription;
    }

    public void setFDiscription(String discription) {
        this.FDiscription = discription;
    }

    public List getMetricList() {
        return this.metricList;
    }

    public void setMetricList(List metricList) {
        this.metricList = metricList;
    }

    public static KPIModel load(IManagementFacade facade, String fid, String famid) throws BIModelRemoteException {
        KPIModel model = new KPIModel();
        StringBuffer sqlKPI = new StringBuffer();
        sqlKPI.append("select A.FID,A.FAMID,A.FMeasureFact,A.FMeasureUp2,A.FMeasureUp1,A.FMeasureDown2,");
        sqlKPI.append("A.FMeasureDown1,A.FDiscription from T_BI_AM_KPI A where A.FID='").append(fid);
        if (famid != null) {
            sqlKPI.append("' and A.FAMID='").append(famid);
        }
        sqlKPI.append("'");
        try {
            RDRowSet rs = facade.executeQuery(sqlKPI.toString());
            if (rs.next()) {
                model.setFAMID(rs.getString("FAMID"));
                model.setFMeasureFact(rs.getString("FMeasureFact"));
                model.setFMeasureUp2(rs.getString("FMeasureUp2"));
                model.setFMeasureUp1(rs.getString("FMeasureUp1"));
                model.setFMeasureDown2(rs.getString("FMeasureDown2"));
                model.setFMeasureDown1(rs.getString("FMeasureDown1"));
                model.setFDiscription(rs.getString("FDiscription"));
            }
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        ArrayList<Metric> metricList = new ArrayList<Metric>();
        Metric metric = null;
        StringBuffer sqlKPIMetric = new StringBuffer();
        sqlKPIMetric.append("select B.FMetric, B.FEdgeType from T_BI_KPI_Metric B where B.FID ='");
        sqlKPIMetric.append(fid);
        sqlKPIMetric.append("'");
        try {
            RDRowSet rs = facade.executeQuery(sqlKPIMetric.toString());
            while (rs.next()) {
                metric = model.new Metric();
                metric.setFMetric(rs.getString("FMetric"));
                metric.setFEdgeType(rs.getString("FEdgeType"));
                metricList.add(metric);
            }
            model.setMetricList(metricList);
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        return model;
    }

    public static void save(IManagementFacade facade, KPIModel model) throws BIModelRemoteException, SQLException {
        if (model == null) {
            return;
        }
        String fid = model.getFID();
        StringBuffer sqlDel = new StringBuffer();
        sqlDel.append("delete from T_BI_KPI_Metric where FID='").append(fid).append("'");
        facade.executeUpdate(sqlDel.toString());
        StringBuffer sqlUpdate = new StringBuffer();
        sqlUpdate.append("update T_BI_AM_KPI set FAMID= '");
        sqlUpdate.append(model.getFAMID());
        sqlUpdate.append("',FMeasureFact = '");
        sqlUpdate.append(model.getFMeasureFact());
        sqlUpdate.append("',FMeasureDown1 = '");
        sqlUpdate.append(model.getFMeasureDown1());
        sqlUpdate.append("',FMeasureDown2 = '");
        sqlUpdate.append(model.getFMeasureDown2());
        sqlUpdate.append("',FMeasureUp1 = '");
        sqlUpdate.append(model.getFMeasureUp1());
        sqlUpdate.append("',FMeasureUp2 = '");
        sqlUpdate.append(model.getFMeasureUp2());
        sqlUpdate.append("',FDiscription = '");
        sqlUpdate.append(model.getFDiscription());
        sqlUpdate.append("'");
        sqlUpdate.append(" where FID ='");
        sqlUpdate.append(model.getFID());
        sqlUpdate.append("'");
        facade.executeUpdate(sqlUpdate.toString());
        List metricList = model.getMetricList();
        if (metricList == null) {
            return;
        }
        Metric metric = null;
        StringBuffer sqlInsert = null;
        int n = metricList.size();
        for (int i = 0; i < n; ++i) {
            metric = (Metric)metricList.get(i);
            sqlInsert = new StringBuffer();
            sqlInsert.append("insert into T_BI_KPI_Metric (FID,FMetric,FEdgeType)");
            sqlInsert.append(" values ('");
            sqlInsert.append(metric.getFID());
            sqlInsert.append("','");
            sqlInsert.append(metric.getFMetric());
            sqlInsert.append("','");
            sqlInsert.append(metric.getFEdgeType());
            sqlInsert.append("')");
            facade.executeUpdate(sqlInsert.toString());
        }
    }

    public static List loadAppModelList(IManagementFacade facade) throws BIModelRemoteException {
        ArrayList<ComboBoxObject> lst = new ArrayList<ComboBoxObject>();
        String sql = "select FID,FName from  T_BI_AppModel where FPublishFlag=1 and (FType='finance' or Ftype is null or FType='') order by FLastUpdateTime desc";
        try {
            RDRowSet rs = facade.executeQuery(sql);
            while (rs.next()) {
                ComboBoxObject m = new ComboBoxObject();
                m.setCode(rs.getString("FID"));
                m.setName(rs.getString("FName"));
                lst.add(m);
            }
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        return lst;
    }

    public static Map loadAppModelInfo(IManagementFacade facade, String famid) throws BIModelRemoteException {
        HashMap dimIteams = new HashMap();
        Vector<ComboBoxObject> measureVector = new Vector<ComboBoxObject>();
        Vector<ComboBoxObject> metricVector = new Vector<ComboBoxObject>();
        String measureTableName = KPIModel.getTableName(facade, famid, DIM_TYPE_MEASURE);
        String metricTableName = KPIModel.getTableName(facade, famid, DIM_TYPE_METRIC);
        if (measureTableName != null && metricTableName != null) {
            String sqlMeasure = "select FNumber,FName from " + measureTableName + " order by FNumber";
            String sqlMetric = "select FID,FNumber,FName from " + metricTableName + " order by FID";
            try {
                ComboBoxObject m;
                RDRowSet rs = facade.executeQuery(sqlMeasure);
                while (rs.next()) {
                    m = new ComboBoxObject();
                    m.setCode(rs.getString("FNumber"));
                    m.setName(rs.getString("FName"));
                    measureVector.add(m);
                }
                rs = facade.executeQuery(sqlMetric);
                while (rs.next()) {
                    m = new ComboBoxObject();
                    m.setCode(rs.getString("FNumber"));
                    m.setName(rs.getString("FName"));
                    metricVector.add(m);
                }
            }
            catch (SQLException e) {
                throw new BIModelRemoteException(e);
            }
        }
        dimIteams.put(DIM_TYPE_MEASURE, measureVector);
        dimIteams.put(DIM_TYPE_METRIC, metricVector);
        return dimIteams;
    }

    public static String getTableName(IManagementFacade facade, String appmodelId, String type) throws BIModelRemoteException {
        String tablename = null;
        String pubnumber = (String)facade.getAppmodelInfo(appmodelId, "pubnumber");
        if (pubnumber == null) {
            return null;
        }
        if (DIM_TYPE_METRIC.equals(type)) {
            tablename = DimensionMeta.getTablename(pubnumber, DIM_TYPE_METRIC);
        } else if (DIM_TYPE_MEASURE.equals(type)) {
            tablename = DimensionMeta.getTablename(pubnumber, DIM_TYPE_MEASURE);
        }
        return tablename;
    }

    public class Metric {
        private String FID;
        private String FMetric;
        private String FEdgeType;

        public String getFID() {
            return this.FID;
        }

        public void setFID(String fid) {
            this.FID = fid;
        }

        public String getFMetric() {
            return this.FMetric;
        }

        public void setFMetric(String metric) {
            this.FMetric = metric;
        }

        public String getFEdgeType() {
            return this.FEdgeType;
        }

        public void setFEdgeType(String edgeType) {
            this.FEdgeType = edgeType;
        }
    }
}

