/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.monitor;

import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.bi.model.util.XmlUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class MetricMonitorXmlModel {
    private boolean canShowOrgFilter;
    private String defaultOrg;
    private boolean canShowYearFilter;
    private String defaultYear;
    private boolean canShowPeriodFilter;
    private String defaultPeriod;
    private boolean canDispalyOrg;
    private boolean canDispalyYear;
    private boolean canDispalyPeriod;
    private List metricList;
    private String version = null;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean getCanDispalyOrg() {
        return this.canDispalyOrg;
    }

    public void setCanDispalyOrg(boolean canDispalyOrg) {
        this.canDispalyOrg = canDispalyOrg;
    }

    public boolean getCanDispalyYear() {
        return this.canDispalyYear;
    }

    public void setCanDispalyYear(boolean canDispalyYear) {
        this.canDispalyYear = canDispalyYear;
    }

    public boolean getCanDispalyPeriod() {
        return this.canDispalyPeriod;
    }

    public void setCanDispalyPeriod(boolean canDispalyPeriod) {
        this.canDispalyPeriod = canDispalyPeriod;
    }

    public List getMetricList() {
        return this.metricList;
    }

    public void setMetricList(List metricList) {
        this.metricList = metricList;
    }

    public boolean getCanShowOrgFilter() {
        return this.canShowOrgFilter;
    }

    public void setCanShowOrgFilter(boolean canShowOrgFilter) {
        this.canShowOrgFilter = canShowOrgFilter;
    }

    public boolean getCanShowYearFilter() {
        return this.canShowYearFilter;
    }

    public void setCanShowYearFilter(boolean canShowYearFilter) {
        this.canShowYearFilter = canShowYearFilter;
    }

    public boolean getCanShowPeriodFilter() {
        return this.canShowPeriodFilter;
    }

    public void setCanShowPeriodFilter(boolean canShowPeriodFilter) {
        this.canShowPeriodFilter = canShowPeriodFilter;
    }

    public String getDefaultOrg() {
        return this.defaultOrg;
    }

    public void setDefaultOrg(String defaultOrg) {
        this.defaultOrg = defaultOrg;
    }

    public String getDefaultYear() {
        return this.defaultYear;
    }

    public void setDefaultYear(String defaultYear) {
        this.defaultYear = defaultYear;
    }

    public String getDefaultPeriod() {
        return this.defaultPeriod;
    }

    public void setDefaultPeriod(String defaultPeriod) {
        this.defaultPeriod = defaultPeriod;
    }

    public static String toXml(MetricMonitorXmlModel xmlModel) throws IOException {
        Element rootElement = null;
        Element filterElement = null;
        Element orgElement = null;
        Element yearElement = null;
        Element periodElement = null;
        Element itemElement = null;
        Element metricsElement = null;
        Element metricElement = null;
        Element drillDownElement = null;
        List metricList = null;
        rootElement = new Element("KPIMonitor");
        rootElement.setAttribute("version", "2.0");
        filterElement = new Element("Filter");
        orgElement = new Element("Org");
        String displayOrg = String.valueOf(xmlModel.getCanDispalyOrg());
        orgElement.setAttribute("display", displayOrg);
        String showOrg = String.valueOf(xmlModel.getCanShowOrgFilter());
        orgElement.setAttribute("show", showOrg);
        String defaultOrg = xmlModel.getDefaultOrg();
        if ("current".equals(defaultOrg)) {
            orgElement.setAttribute("default", "current");
        } else {
            itemElement = new Element("item");
            itemElement.addContent(defaultOrg);
            orgElement.addContent((Content)itemElement);
        }
        yearElement = new Element("Year");
        String displayYear = String.valueOf(xmlModel.getCanDispalyYear());
        yearElement.setAttribute("display", displayYear);
        String showYear = String.valueOf(xmlModel.getCanShowYearFilter());
        yearElement.setAttribute("show", showYear);
        String defaultYear = xmlModel.getDefaultYear();
        if ("current".equals(defaultYear) || "last".equals(defaultYear) || "first".equals(defaultYear)) {
            yearElement.setAttribute("default", defaultYear);
        } else {
            itemElement = new Element("item");
            itemElement.addContent(defaultYear);
            yearElement.addContent((Content)itemElement);
        }
        periodElement = new Element("Period");
        String displayPeriod = String.valueOf(xmlModel.getCanDispalyPeriod());
        periodElement.setAttribute("display", displayPeriod);
        String showPeriod = String.valueOf(xmlModel.getCanShowPeriodFilter());
        periodElement.setAttribute("show", showPeriod);
        String defaultPeriod = xmlModel.getDefaultPeriod();
        if ("current".equals(defaultPeriod) || "last".equals(defaultPeriod) || "first".equals(defaultPeriod)) {
            periodElement.setAttribute("default", defaultPeriod);
        } else {
            itemElement = new Element("item");
            itemElement.addContent(defaultPeriod);
            periodElement.addContent((Content)itemElement);
        }
        metricsElement = new Element("Metrics");
        metricList = xmlModel.getMetricList();
        Metric metric = null;
        int n = metricList.size();
        for (int i = 0; i < n; ++i) {
            metric = (Metric)metricList.get(i);
            String metricNumber = metric.getMetricNumber();
            String showType = metric.getShowType();
            String drillDownOrg = String.valueOf(metric.getDrillDownOrg());
            String drillDownYear = String.valueOf(metric.getDrillDownYear());
            String drillDownPeriod = String.valueOf(metric.getDrillDownPeriod());
            String drillDownDefault = String.valueOf(metric.getDrillDownDefault());
            metricElement = new Element("Metric");
            metricElement.setAttribute("number", metricNumber);
            metricElement.setAttribute("showType", showType);
            drillDownElement = new Element("drilldown");
            drillDownElement.setAttribute("org", drillDownOrg);
            drillDownElement.setAttribute("year", drillDownYear);
            drillDownElement.setAttribute("period", drillDownPeriod);
            drillDownElement.setAttribute("default", drillDownDefault);
            metricElement.addContent((Content)drillDownElement);
            metricsElement.addContent((Content)metricElement);
        }
        rootElement.addContent((Content)filterElement);
        rootElement.addContent((Content)metricsElement);
        filterElement.addContent((Content)orgElement);
        filterElement.addContent((Content)yearElement);
        filterElement.addContent((Content)periodElement);
        return XmlUtil.toGBKString(rootElement);
    }

    public static MetricMonitorXmlModel toModel(String xml) throws JDOMException, IOException {
        Element rootElement = XmlUtil.toRootElement(xml);
        MetricMonitorXmlModel xmlModel = new MetricMonitorXmlModel();
        ArrayList<Metric> metricList = new ArrayList<Metric>();
        Element filterElement = null;
        Element orgElement = null;
        Element yearElement = null;
        Element periodElement = null;
        Element itemElement = null;
        Element metricsElement = null;
        List metricElementList = null;
        Element metricElement = null;
        Element drillDownElement = null;
        String version = rootElement.getAttributeValue("version");
        boolean is1 = StringUtil.isEmpty(version);
        xmlModel.setVersion(is1 ? "1.0" : "2.0");
        filterElement = rootElement.getChild("Filter");
        orgElement = filterElement.getChild("Org");
        boolean displayOrg = is1 ? true : "true".equals(orgElement.getAttributeValue("display"));
        boolean showOrg = "true".equals(orgElement.getAttributeValue("show"));
        String defaultOrg = orgElement.getAttributeValue("default");
        if (defaultOrg == null) {
            itemElement = orgElement.getChild("item");
            defaultOrg = itemElement.getText();
        }
        yearElement = filterElement.getChild("Year");
        boolean displayYear = is1 ? true : "true".equals(yearElement.getAttributeValue("display"));
        boolean showYear = is1 ? true : "true".equals(yearElement.getAttributeValue("show"));
        String defaultYear = yearElement.getAttributeValue("default");
        if (defaultYear == null) {
            itemElement = yearElement.getChild("item");
            defaultYear = itemElement.getText();
        }
        periodElement = filterElement.getChild("Period");
        boolean displayPeriod = is1 ? true : "true".equals(periodElement.getAttributeValue("display"));
        boolean showPeriod = "true".equals(periodElement.getAttributeValue("show"));
        String defaultPeriod = periodElement.getAttributeValue("default");
        if (defaultPeriod == null) {
            itemElement = periodElement.getChild("item");
            defaultPeriod = itemElement.getText();
        }
        metricsElement = rootElement.getChild("Metrics");
        metricElementList = metricsElement.getChildren();
        int n = metricElementList.size();
        for (int i = 0; i < n; ++i) {
            metricElement = (Element)metricElementList.get(i);
            Metric metric = xmlModel.new Metric();
            String metricNumber = metricElement.getAttributeValue("number");
            String showType = metricElement.getAttributeValue("showType");
            drillDownElement = metricElement.getChild("drilldown");
            boolean drillDownOrg = "true".equals(drillDownElement.getAttributeValue("org"));
            boolean drillDownYear = "true".equals(drillDownElement.getAttributeValue("year"));
            boolean drillDownPeriod = "true".equals(drillDownElement.getAttributeValue("period"));
            String drillDownDefault = drillDownElement.getAttributeValue("default");
            metric.setMetricNumber(metricNumber);
            metric.setShowType(showType);
            metric.setDrillDownOrg(drillDownOrg);
            metric.setDrillDownYear(drillDownYear);
            metric.setDrillDownPeriod(drillDownPeriod);
            metric.setDrillDownDefault(drillDownDefault);
            metricList.add(metric);
        }
        xmlModel.setCanDispalyOrg(displayOrg);
        xmlModel.setCanShowOrgFilter(showOrg);
        xmlModel.setDefaultOrg(defaultOrg);
        xmlModel.setCanDispalyYear(displayYear);
        xmlModel.setCanShowYearFilter(showYear);
        xmlModel.setDefaultYear(defaultYear);
        xmlModel.setCanDispalyPeriod(displayPeriod);
        xmlModel.setCanShowPeriodFilter(showPeriod);
        xmlModel.setDefaultPeriod(defaultPeriod);
        xmlModel.setMetricList(metricList);
        return xmlModel;
    }

    public class Metric {
        private String metricNumber;
        private String showType;
        private boolean drillDownOrg;
        private boolean drillDownYear;
        private boolean drillDownPeriod;
        private String drillDownDefault;

        public String getMetricNumber() {
            return this.metricNumber;
        }

        public void setMetricNumber(String metricNumber) {
            this.metricNumber = metricNumber;
        }

        public String getShowType() {
            return this.showType;
        }

        public void setShowType(String showType) {
            this.showType = showType;
        }

        public boolean getDrillDownOrg() {
            return this.drillDownOrg;
        }

        public void setDrillDownOrg(boolean drillDownOrg) {
            this.drillDownOrg = drillDownOrg;
        }

        public boolean getDrillDownYear() {
            return this.drillDownYear;
        }

        public void setDrillDownYear(boolean drillDownYear) {
            this.drillDownYear = drillDownYear;
        }

        public boolean getDrillDownPeriod() {
            return this.drillDownPeriod;
        }

        public void setDrillDownPeriod(boolean drillDownPeriod) {
            this.drillDownPeriod = drillDownPeriod;
        }

        public String getDrillDownDefault() {
            return this.drillDownDefault;
        }

        public void setDrillDownDefault(String drillDownDefault) {
            this.drillDownDefault = drillDownDefault;
        }
    }
}

