/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.commonui.propsheet.panel;

import com.kingdee.bos.bi.model.commonui.propsheet.beans.editor.AbstractPropertyEditor;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.editor.BooleanPropertyEditor;
import com.kingdee.bos.ctrl.common.LanguageManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class CellEditorAdapter
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    private static final long serialVersionUID = -9009638989612891062L;
    public static final String KEY_MSG = "msg";
    public static final String KEY_MSG_TITLE = "msgTitle";
    protected PropertyEditor editor = null;
    protected int clickCountToStart = 1;
    private int prevRow = 0;
    private int prevCol = 0;

    public CellEditorAdapter(PropertyEditor editor) {
        this.editor = editor;
        Component component = editor.getCustomEditor();
        if (component instanceof JTextField) {
            JTextField field = (JTextField)component;
            field.addFocusListener(new SelectOnFocus());
            field.addActionListener(new CommitEditing());
            field.registerKeyboardAction(new CancelEditing(), KeyStroke.getKeyStroke(27, 0), 0);
        } else if (component instanceof JSpinner) {
            JSpinner spinner = (JSpinner)component;
            spinner.addFocusListener(new SelectOnFocus());
        }
        editor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!(evt.getSource() instanceof BooleanPropertyEditor)) {
                    CellEditorAdapter.this.stopCellEditing();
                }
            }
        });
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        return this.getEditor(value);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
        return this.getEditor(value);
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getValue();
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        if (event instanceof MouseEvent) {
            return ((MouseEvent)event).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    public static String getLocalText(String key) {
        return LanguageManager.getLangMessage((String)key, CellEditorAdapter.class, (String)"NotFound");
    }

    @Override
    public boolean stopCellEditing() {
        if (!this.verifyEditorInput()) {
            return false;
        }
        try {
            this.fireEditingStopped();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return true;
    }

    public boolean verifyEditorInput() {
        if (this.editor instanceof AbstractPropertyEditor) {
            return ((AbstractPropertyEditor)this.editor).fireVerifiers();
        }
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    private Component getEditor(Object value) {
        this.editor.setValue(value);
        value = "^_^";
        final Component cellEditor = this.editor.getCustomEditor();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                cellEditor.requestFocus();
                cellEditor.repaint();
            }
        });
        return cellEditor;
    }

    class SelectOnFocus
    implements FocusListener {
        SelectOnFocus() {
        }

        @Override
        public void focusGained(final FocusEvent e) {
            JTable ta = (JTable)CellEditorAdapter.this.editor.getCustomEditor().getParent();
            if (ta != null) {
                CellEditorAdapter.this.prevCol = ta.getSelectedColumn();
                CellEditorAdapter.this.prevRow = ta.getSelectedRow();
            }
            if (!(e.getSource() instanceof JTextField)) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JTextField)e.getSource()).selectAll();
                }
            });
        }

        @Override
        public void focusLost(final FocusEvent e) {
            final JTable table = e.getOppositeComponent() instanceof JTable ? (JTable)e.getOppositeComponent() : (JTable)CellEditorAdapter.this.editor.getCustomEditor().getParent();
            if (!CellEditorAdapter.this.verifyEditorInput()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (table != null) {
                            table.changeSelection(CellEditorAdapter.this.prevRow, CellEditorAdapter.this.prevCol, false, false);
                            table.editCellAt(CellEditorAdapter.this.prevRow, CellEditorAdapter.this.prevCol);
                        }
                    }
                });
                if (!(e.getSource() instanceof JTextField)) {
                    return;
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JTextField)e.getSource()).select(0, 0);
                }
            });
        }
    }

    class CancelEditing
    implements ActionListener {
        CancelEditing() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CellEditorAdapter.this.cancelCellEditing();
        }
    }

    class CommitEditing
    implements ActionListener {
        CommitEditing() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CellEditorAdapter.this.stopCellEditing();
        }
    }
}

