/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.commonui.propsheet.panel;

import com.kingdee.bos.bi.model.commonui.propsheet.beans.ExtendedPropertyDescriptor;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.IProperty;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.IPropertyEditorFactory;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.IPropertyRendererFactory;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.IPropertySheet;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.PropertyDescriptorAdapter;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.PropertyEditorFactory;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.PropertyRendererFactory;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.PropertySheetTable;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.PropertySheetTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PropertySheetPanel
extends JPanel
implements IPropertySheet,
PropertyChangeListener {
    private static final long serialVersionUID = -7646350821716986982L;
    public static final String KEY_CATEGORY = "category";
    public static final String KEY_DETAILS = "details";
    public static final String KEY_SORT = "sort";
    private PropertySheetTable table;
    private PropertySheetTableModel model;
    private JScrollPane tableScroll;
    private ListSelectionListener selectionListener = new SelectionListener();
    private JPanel actionPanel;
    private JToggleButton sortButton;
    private JToggleButton asCategoryButton;
    private JToggleButton descriptionButton;
    private JSplitPane split;
    private int lastDescriptionHeight;
    private JEditorPane descriptionPanel;
    private JScrollPane descriptionScrollPane;

    public PropertySheetPanel() {
        this(new PropertySheetTable());
    }

    public PropertySheetPanel(PropertySheetTable table) {
        this.buildUI();
        this.setTable(table);
    }

    public void setTable(PropertySheetTable table) {
        if (table == null) {
            throw new IllegalArgumentException("table must not be null");
        }
        if (this.model != null) {
            this.model.removePropertyChangeListener(this);
        }
        this.model = (PropertySheetTableModel)table.getModel();
        this.model.addPropertyChangeListener(this);
        if (this.table != null) {
            this.table.getSelectionModel().removeListSelectionListener(this.selectionListener);
        }
        table.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.tableScroll.getViewport().setView(table);
        this.table = table;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.repaint();
    }

    public PropertySheetTable getTable() {
        return this.table;
    }

    public void setDescriptionVisible(boolean visible) {
        if (visible) {
            this.add("Center", this.split);
            this.split.setTopComponent(this.tableScroll);
            this.split.setBottomComponent(this.descriptionScrollPane);
            this.split.setDividerLocation(this.split.getHeight() - this.lastDescriptionHeight);
        } else {
            this.lastDescriptionHeight = this.split.getHeight() - this.split.getDividerLocation();
            this.remove(this.split);
            this.add("Center", this.tableScroll);
        }
        this.descriptionButton.setSelected(visible);
        this.revalidate();
    }

    public void setToolBarVisible(boolean visible) {
        this.actionPanel.setVisible(visible);
        this.revalidate();
    }

    public void setMode(int mode) {
        this.model.setMode(mode);
        this.asCategoryButton.setSelected(1 == mode);
    }

    @Override
    public void setProperties(IProperty[] properties) {
        this.model.setProperties(properties);
    }

    @Override
    public IProperty[] getProperties() {
        return this.model.getProperties();
    }

    @Override
    public void addProperty(IProperty property) {
        this.model.addProperty(property);
    }

    @Override
    public void addProperty(int index, IProperty property) {
        this.model.addProperty(index, property);
    }

    @Override
    public void removeProperty(IProperty property) {
        this.model.removeProperty(property);
    }

    @Override
    public int getPropertyCount() {
        return this.model.getPropertyCount();
    }

    @Override
    public Iterator propertyIterator() {
        return this.model.propertyIterator();
    }

    public void setBeanInfo(BeanInfo beanInfo) {
        this.setProperties(beanInfo.getPropertyDescriptors());
    }

    public void setProperties(PropertyDescriptor[] descriptors) {
        IProperty[] properties = new IProperty[descriptors.length];
        int c = descriptors.length;
        for (int i = 0; i < c; ++i) {
            properties[i] = new PropertyDescriptorAdapter((ExtendedPropertyDescriptor)((Object)descriptors[i]));
        }
        this.setProperties(properties);
    }

    public void readFromObject(Object data) {
        this.readFromObject(data, true);
    }

    public void readFromObject(Object data, boolean fireEvent) {
        this.getTable().cancelEditing();
        IProperty[] properties = this.model.getProperties();
        int c = properties.length;
        for (int i = 0; i < c; ++i) {
            properties[i].readFromObject(data, fireEvent);
        }
        this.repaint();
    }

    public void writeToObject(Object data) {
        this.getTable().commitEditing();
        IProperty[] properties = this.getProperties();
        int c = properties.length;
        for (int i = 0; i < c; ++i) {
            properties[i].writeToObject(data);
        }
    }

    public void addPropertySheetChangeListener(PropertyChangeListener listener) {
        this.model.addPropertyChangeListener(listener);
    }

    public void removePropertySheetChangeListener(PropertyChangeListener listener) {
        this.model.removePropertyChangeListener(listener);
    }

    public void setEditorFactory(IPropertyEditorFactory factory) {
        this.table.setEditorFactory(factory);
    }

    public IPropertyEditorFactory getEditorFactory() {
        return this.table.getEditorFactory();
    }

    public void setEditorRegistry(PropertyEditorFactory registry) {
        this.table.setEditorFactory(registry);
    }

    public PropertyEditorFactory getEditorRegistry() {
        return (PropertyEditorFactory)this.table.getEditorFactory();
    }

    public void setRendererFactory(IPropertyRendererFactory factory) {
        this.table.setRendererFactory(factory);
    }

    public IPropertyRendererFactory getRendererFactory() {
        return this.table.getRendererFactory();
    }

    public void setRendererRegistry(PropertyRendererFactory registry) {
        this.table.setRendererRegistry(registry);
    }

    public PropertyRendererFactory getRendererRegistry() {
        return this.table.getRendererRegistry();
    }

    public void setSortingCategories(boolean value) {
        this.model.setSortingCategories(value);
        this.sortButton.setSelected(this.isSorting());
    }

    public boolean isSortingCategories() {
        return this.model.isSortingCategories();
    }

    public void setSortingProperties(boolean value) {
        this.model.setSortingProperties(value);
        this.sortButton.setSelected(this.isSorting());
    }

    public boolean isSortingProperties() {
        return this.model.isSortingProperties();
    }

    public void setSorting(boolean value) {
        this.model.setSortingCategories(value);
        this.model.setSortingProperties(value);
        this.sortButton.setSelected(value);
    }

    public boolean isSorting() {
        return this.model.isSortingCategories() || this.model.isSortingProperties();
    }

    public void setCategorySortingComparator(Comparator comp) {
        this.model.setCategorySortingComparator(comp);
    }

    public void setPropertySortingComparator(Comparator comp) {
        this.model.setPropertySortingComparator(comp);
    }

    public void setRestoreToggleStates(boolean value) {
        this.model.setRestoreToggleStates(value);
    }

    public boolean isRestoreToggleStates() {
        return this.model.isRestoreToggleStates();
    }

    public Map getToggleStates() {
        return this.model.getToggleStates();
    }

    public void setToggleStates(Map toggleStates) {
        this.model.setToggleStates(toggleStates);
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.actionPanel = new JPanel(new FlowLayout(3, 2, 0));
        this.actionPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.actionPanel.setOpaque(false);
        this.add("North", this.actionPanel);
        this.asCategoryButton = new JToggleButton(new ToggleModeAction());
        this.asCategoryButton.setText(null);
        this.asCategoryButton.setOpaque(false);
        this.actionPanel.add(this.asCategoryButton);
        this.sortButton = new JToggleButton(new ToggleSortingAction());
        this.sortButton.setText(null);
        this.sortButton.setOpaque(false);
        this.sortButton.setVisible(true);
        this.actionPanel.add(this.sortButton);
        this.descriptionButton = new JToggleButton(new ToggleDescriptionAction());
        this.descriptionButton.setText(null);
        this.descriptionButton.setOpaque(false);
        this.actionPanel.add(this.descriptionButton);
        this.split = new JSplitPane(0);
        this.split.setBorder(null);
        this.split.setResizeWeight(1.0);
        this.split.setContinuousLayout(true);
        this.add("Center", this.split);
        this.tableScroll = new JScrollPane();
        this.tableScroll.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.split.setTopComponent(this.tableScroll);
        this.descriptionPanel = new JEditorPane("text/html", "<html>");
        this.descriptionPanel.setBorder(BorderFactory.createEmptyBorder());
        this.descriptionPanel.setEditable(false);
        this.descriptionPanel.setBackground(UIManager.getColor("Panel.background"));
        this.selectionListener = new SelectionListener();
        this.descriptionScrollPane = new JScrollPane(this.descriptionPanel);
        this.descriptionScrollPane.getViewport().setBackground(this.descriptionPanel.getBackground());
        this.descriptionScrollPane.setMinimumSize(new Dimension(50, 50));
        this.split.setBottomComponent(this.descriptionScrollPane);
        this.setDescriptionVisible(false);
        this.setToolBarVisible(true);
    }

    class ToggleSortingAction
    extends AbstractAction {
        private static final long serialVersionUID = -3336873040654813163L;

        public ToggleSortingAction() {
            super("toggleSorting", new ImageIcon(IPropertySheet.class.getResource("icons/sort.gif")));
            this.putValue("ShortDescription", "\u6392\u5e8f");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PropertySheetPanel.this.setSorting(PropertySheetPanel.this.sortButton.isSelected());
        }
    }

    class ToggleDescriptionAction
    extends AbstractAction {
        private static final long serialVersionUID = 776983065156195821L;

        public ToggleDescriptionAction() {
            super("toggleDescription", new ImageIcon(IPropertySheet.class.getResource("icons/description.gif")));
            this.putValue("ShortDescription", "\u8be6\u7ec6");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PropertySheetPanel.this.setDescriptionVisible(PropertySheetPanel.this.descriptionButton.isSelected());
        }
    }

    class ToggleModeAction
    extends AbstractAction {
        private static final long serialVersionUID = 6843593651814740418L;

        public ToggleModeAction() {
            super("toggle", new ImageIcon(IPropertySheet.class.getResource("icons/category.gif")));
            this.putValue("ShortDescription", "\u5206\u7c7b");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PropertySheetPanel.this.asCategoryButton.isSelected()) {
                PropertySheetPanel.this.model.setMode(1);
            } else {
                PropertySheetPanel.this.model.setMode(0);
            }
        }
    }

    class SelectionListener
    implements ListSelectionListener {
        SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int row = PropertySheetPanel.this.table.getSelectedRow();
            IProperty prop = null;
            if (row >= 0 && PropertySheetPanel.this.table.getRowCount() > row) {
                prop = PropertySheetPanel.this.model.getPropertySheetElement(row).getProperty();
            }
            if (prop != null) {
                PropertySheetPanel.this.descriptionPanel.setText("<html><b>" + (prop.getDisplayName() == null ? "" : prop.getDisplayName()) + "</b><br>" + (prop.getShortDescription() == null ? "" : prop.getShortDescription()));
            } else {
                PropertySheetPanel.this.descriptionPanel.setText("<html>");
            }
            PropertySheetPanel.this.descriptionPanel.setCaretPosition(0);
        }
    }
}

