/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.appmodel;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.common.formularengine.FormularEngine;
import com.kingdee.bos.bi.model.common.formularengine.FormularParser;
import com.kingdee.bos.bi.model.common.formularengine.exception.FormulaComputingException;
import com.kingdee.bos.bi.model.common.formularengine.exception.NonValueException;
import com.kingdee.bos.bi.model.common.formularengine.exception.StringParsingException;
import com.kingdee.bos.bi.model.common.formularengine.expr.AbstractExpr;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.appmodel.DataRule;
import com.kingdee.bos.bi.model.rt.appmodel.FIPeriod;
import com.kingdee.bos.bi.model.rt.appmodel.VarProvider;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.org.OrgDimension;
import com.kingdee.bos.bi.model.rt.dim.period.PeriodDimension;
import com.kingdee.bos.bi.model.rt.fact.Fact;
import com.kingdee.bos.bi.model.ui.exception.BIModelBizException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AggDataRule
extends DataRule {
    private static final Logger log = CommonLogger.getLogger(AggDataRule.class);

    public AggDataRule(AppModel appmodel, String schemaID, int itemorder, Map mapParameter) {
        super(appmodel, schemaID, itemorder, mapParameter);
        this.type = "calc";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Number calcOneRow(String aggDim, String measureNumber, String orgNumber, String metricNumber, FIPeriod nowPeriod, Map bizMap, Map keyMap, Connection cn, StringBuffer sbError) throws SQLException {
        boolean orgIsLeaf;
        Number value = null;
        if ("period".equalsIgnoreCase(aggDim)) {
            return this.periodAgg(measureNumber, orgNumber, metricNumber, nowPeriod, bizMap, keyMap, cn, sbError);
        }
        Dimension dim = this.appmodel.getDimension("measure");
        String measureFormular = (String)dim.findProperty(measureNumber, "FFormula", cn);
        Object objMeasureCalcAgain = dim.findProperty(measureNumber, "FFormulaCalcFlag", cn);
        boolean measureCalcAgain = objMeasureCalcAgain == null ? false : ((Number)objMeasureCalcAgain).intValue() == 1;
        dim = this.appmodel.getDimension("metric");
        String metricFormula = (String)dim.findProperty(metricNumber, "FFormula", cn);
        Object objMetricCalcAgain = dim.findProperty(metricNumber, "FFormulaCalcFlag", cn);
        boolean metricCalcAgain = objMetricCalcAgain == null ? false : ((Number)objMetricCalcAgain).intValue() == 1;
        dim = this.appmodel.getDimension("org");
        Object objOrgIsLeaf = dim.findProperty(orgNumber, "FIsLeaf", cn);
        boolean bl = orgIsLeaf = ((Number)objOrgIsLeaf).intValue() == 1;
        if (orgIsLeaf) {
            if (!StringUtils.isEmpty((String)measureFormular)) {
                if (measureCalcAgain) return this.calcMeasureFormular(measureFormular, bizMap, keyMap, cn, sbError);
                if (StringUtils.isEmpty((String)metricFormula)) return this.calcMeasureFormular(measureFormular, bizMap, keyMap, cn, sbError);
                if (!metricCalcAgain) return this.calcMeasureFormular(measureFormular, bizMap, keyMap, cn, sbError);
                return this.calcMetricFormular(metricFormula, bizMap, keyMap, cn, sbError);
            }
            if (StringUtils.isEmpty((String)metricFormula)) return null;
            return this.calcMetricFormular(metricFormula, bizMap, keyMap, cn, sbError);
        }
        if (measureCalcAgain && !StringUtils.isEmpty((String)measureFormular)) {
            return this.calcMeasureFormular(measureFormular, bizMap, keyMap, cn, sbError);
        }
        if (!metricCalcAgain) return this.orgAgg(measureNumber, orgNumber, metricNumber, nowPeriod, bizMap, keyMap, cn, sbError);
        if (StringUtils.isEmpty((String)metricFormula)) return this.orgAgg(measureNumber, orgNumber, metricNumber, nowPeriod, bizMap, keyMap, cn, sbError);
        return this.calcMetricFormular(metricFormula, bizMap, keyMap, cn, sbError);
    }

    @Override
    public void calc(Date date, Connection cn, Context ctx, Map params, Map mapDataFlag, StringBuffer sbError) throws BIModelBizException {
        Date calDate = this.adjustDate(date, params);
        FIPeriod nowPeriod = this.checkDate(calDate, true);
        if (nowPeriod == null) {
            return;
        }
        HashMap mapStatement = new HashMap();
        List lstOrg = (List)this.parameters.get("org");
        List lstMetric = (List)this.parameters.get("metric");
        List lstMeasure = (List)this.parameters.get("measure");
        Fact dimMeasure = new Fact(this.appmodel.getAppModelView().getDimRef());
        for (String metricNumber : lstMetric) {
            for (String orgNumber : lstOrg) {
                for (String measureNumber : lstMeasure) {
                    String error;
                    HashMap<String, Object> bizMap = new HashMap<String, Object>();
                    bizMap.put("measure", measureNumber);
                    bizMap.put("org", orgNumber);
                    bizMap.put("metric", metricNumber);
                    bizMap.put("year", new Integer(nowPeriod.getYear()));
                    bizMap.put("period", new Integer(nowPeriod.getMonth()));
                    Map keyMap = null;
                    try {
                        keyMap = this.appmodel.findInnerKey(bizMap, cn);
                    }
                    catch (SQLException e1) {
                        String error2 = "\u67e5\u627e\u4e3b\u952e\u65f6\u5931\u8d25\uff01";
                        log.error((Object)error2, (Throwable)e1);
                        sbError.append(error2 + "\n\r");
                        continue;
                    }
                    FIPeriod p = new FIPeriod(nowPeriod.getYear(), nowPeriod.getMonth(), false, nowPeriod.getMonth());
                    Number value = null;
                    try {
                        value = this.calcOneRow(null, measureNumber, orgNumber, metricNumber, p, bizMap, keyMap, cn, sbError);
                    }
                    catch (SQLException e2) {
                        error = "\u805a\u5408\u8fd0\u7b97\u65f6\u5931\u8d25\uff01";
                        log.error((Object)error, (Throwable)e2);
                        sbError.append(error + "\n\r");
                        continue;
                    }
                    if (value != null) {
                        try {
                            dimMeasure.updateFactData(this.appmodel.getPubnumber(), value, keyMap, 1, cn, mapDataFlag, mapStatement, false);
                        }
                        catch (SQLException e) {
                            error = "\u5199\u5165\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5b9a\u4e49\u7684\u5ea6\u91cf\u7684\u6570\u636e\u548c\u6709\u6548\u4f4d\u662f\u5426\u6709\u8db3\u591f\u7684\u957f\u5ea6\uff01";
                            log.error((Object)error, (Throwable)e);
                            sbError.append(error + "\n\r");
                            continue;
                        }
                    }
                    if (!nowPeriod.useQuarter()) continue;
                    bizMap.put("period", new Integer(nowPeriod.getPeriod()));
                    try {
                        keyMap = this.appmodel.findInnerKey(bizMap, cn);
                    }
                    catch (SQLException e1) {
                        error = "\u67e5\u627e\u4e3b\u952e\u65f6\u5931\u8d25\uff01";
                        log.error((Object)error, (Throwable)e1);
                        sbError.append(error + "\n\r");
                        continue;
                    }
                    try {
                        value = this.calcOneRow("period", measureNumber, orgNumber, metricNumber, nowPeriod, bizMap, keyMap, cn, sbError);
                    }
                    catch (SQLException e1) {
                        error = "\u805a\u5408\u8fd0\u7b97\u65f6\u5931\u8d25\uff01";
                        log.error((Object)error, (Throwable)e1);
                        sbError.append(error + "\n\r");
                        continue;
                    }
                    if (value == null) continue;
                    try {
                        dimMeasure.updateFactData(this.appmodel.getPubnumber(), value, keyMap, 1, cn, mapDataFlag, mapStatement, false);
                    }
                    catch (SQLException e) {
                        error = "\u5199\u5165\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5b9a\u4e49\u7684\u5ea6\u91cf\u7684\u6570\u636e\u548c\u6709\u6548\u4f4d\u662f\u5426\u6709\u8db3\u591f\u7684\u957f\u5ea6\uff01";
                        log.error((Object)error, (Throwable)e);
                        sbError.append(error + "\n\r");
                    }
                }
            }
        }
        DBUtil.executeBatchStatement(mapStatement, sbError, true);
    }

    private Number calcMetricFormular(String metricFormular, Map bizMap, Map keyMap, Connection cn, StringBuffer sbError) {
        FormularEngine engine = new FormularEngine();
        FormularParser parser = new FormularParser();
        Dimension dim = this.appmodel.getDimension("metric");
        VarProvider varProvider = new VarProvider(cn, this.appmodel, dim, keyMap);
        engine.setVarValueProvider(varProvider);
        Variant v = null;
        try {
            AbstractExpr expr = parser.parse(metricFormular);
            v = engine.calculate(expr);
        }
        catch (NonValueException ex) {
            return null;
        }
        catch (FormulaComputingException e) {
            String parameterInfo = "\u5ea6\u91cf\uff1a" + bizMap.get("measure") + " \u7ec4\u7ec7\uff1a" + bizMap.get("org") + " \u5e74\uff1a" + bizMap.get("year") + " \u671f\u95f4\uff1a" + bizMap.get("period");
            String error = "\u6307\u6807\u516c\u5f0f[" + metricFormular + "]\u8fd0\u7b97\u5931\u8d25\uff01" + parameterInfo + " \u51fa\u9519\u4fe1\u606f\uff1a" + e.getMessage();
            log.error((Object)error, (Throwable)e);
            sbError.append(error + "\n\r");
            return null;
        }
        catch (StringParsingException e) {
            String error = "\u6307\u6807\u516c\u5f0f[" + metricFormular + "]\u89e3\u6790\u5931\u8d25\uff01" + e.getMessage();
            log.error((Object)error, (Throwable)e);
            sbError.append(error + "\n\r");
            return null;
        }
        return (Number)v.getValue();
    }

    private Number calcMeasureFormular(String measureFormular, Map bizMap, Map keyMap, Connection cn, StringBuffer sbError) {
        FormularEngine engine = new FormularEngine();
        FormularParser parser = new FormularParser();
        Dimension dim = this.appmodel.getDimension("measure");
        VarProvider varProvider = new VarProvider(cn, this.appmodel, dim, keyMap);
        engine.setVarValueProvider(varProvider);
        Variant v = null;
        try {
            AbstractExpr expr = parser.parse(measureFormular);
            v = engine.calculate(expr);
        }
        catch (NonValueException ex) {
            return null;
        }
        catch (FormulaComputingException e) {
            String parameterInfo = "\u6307\u6807\uff1a" + bizMap.get("metric") + " \u7ec4\u7ec7\uff1a" + bizMap.get("org") + " \u5e74\uff1a" + bizMap.get("year") + " \u671f\u95f4\uff1a" + bizMap.get("period");
            String error = "\u5ea6\u91cf\u516c\u5f0f[" + measureFormular + "]\u8fd0\u7b97\u5931\u8d25\uff01" + parameterInfo + " \u51fa\u9519\u539f\u56e0\uff1a" + e.getMessage();
            log.error((Object)error, (Throwable)e);
            sbError.append(error + "\n\r");
            return null;
        }
        catch (StringParsingException e) {
            String error = "\u5ea6\u91cf\u516c\u5f0f[" + measureFormular + "]\u89e3\u6790\u5931\u8d25\uff01\u539f\u56e0\uff1a" + e.getMessage();
            log.error((Object)error, (Throwable)e);
            sbError.append(error + "\n\r");
            return null;
        }
        return (Number)v.getValue();
    }

    private Number periodAgg(String measureNumber, String orgNumber, String metricNumber, FIPeriod nowPeriod, Map bizMap, Map keyMap, Connection cn, StringBuffer sbError) throws SQLException {
        String timeAggregate = "";
        Dimension dim = this.appmodel.getDimension("metric");
        String timeAgg = (String)dim.findProperty(metricNumber, "FTimeAggType", cn);
        if (timeAgg == null) {
            dim = this.appmodel.getDimension("measure");
            timeAggregate = (String)dim.findProperty(measureNumber, "FAggregation", cn);
        } else {
            timeAggregate = timeAgg;
        }
        PeriodDimension pm = (PeriodDimension)this.appmodel.getDimension("period");
        return pm.aggration(this.appmodel.getPubnumber(), timeAggregate, keyMap, cn);
    }

    private Number orgAgg(String measureNumber, String orgNumber, String metricNumber, FIPeriod nowPeriod, Map bizMap, Map keyMap, Connection cn, StringBuffer sbError) throws SQLException {
        Dimension dim = this.appmodel.getDimension("measure");
        String aggregate = (String)dim.findProperty(measureNumber, "FAggregation", cn);
        OrgDimension om = (OrgDimension)this.appmodel.getDimension("org");
        return om.aggration(aggregate, bizMap, keyMap, cn);
    }
}

