/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.appmodel;

import com.kingdee.bos.bi.model.rt.appmodel.FormulaMapping;
import com.kingdee.bos.bi.model.rt.appmodel.FormulaRepItem;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.util.backport.Collections;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class EASFormulaUtil {
    private static final String MAPPING_FILE = "eas_formula_mapping.xml";
    private static List formulaMappings = null;

    public static String adjustFormular(String fullFormula, Map mapParameter) {
        String newFormula = fullFormula;
        if (formulaMappings == null) {
            InputStream is = EASFormulaUtil.class.getResourceAsStream(MAPPING_FILE);
            try {
                formulaMappings = EASFormulaUtil.fromXML(is);
            }
            catch (Exception e) {
                return newFormula;
            }
        }
        Map mapFormula = StringUtil.splitFormula(fullFormula);
        List<Object> lstKey = Arrays.asList(mapFormula.keySet().toArray());
        Collections.sort(lstKey);
        Collections.reverse(lstKey);
        Iterator<Object> itFormula = lstKey.iterator();
        while (itFormula.hasNext()) {
            int pos = (Integer)itFormula.next();
            String formula = (String)mapFormula.get(new Integer(pos));
            Iterator it = formulaMappings.iterator();
            String repFormula = null;
            while (it.hasNext()) {
                FormulaMapping fm = (FormulaMapping)it.next();
                if (!fm.matchFormula(formula)) continue;
                for (FormulaRepItem item : fm.getRepItems()) {
                    repFormula = item.replaceValue(formula, mapParameter);
                }
            }
            if (repFormula == null) continue;
            newFormula = newFormula.substring(0, pos) + repFormula + newFormula.substring(pos + formula.length());
        }
        return newFormula;
    }

    private static List fromXML(InputStream is) throws ParserConfigurationException, IOException, JDOMException {
        ArrayList<FormulaMapping> lstFormulaMapping = new ArrayList<FormulaMapping>();
        Element e = XmlUtil.loadXmlStream((InputStream)is);
        List eles = e.getChildren("formula");
        for (Element element : eles) {
            FormulaMapping fm = FormulaMapping.fromNode(element);
            lstFormulaMapping.add(fm);
        }
        return lstFormulaMapping;
    }
}

