/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.bireport;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.bireport.DimensionMember;
import com.kingdee.bos.bi.model.common.bireport.DimensionSet;
import com.kingdee.bos.bi.model.common.mm.time.TimeDimensionNode;
import com.kingdee.bos.bi.model.common.mm.time.TimeTreeModel;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.appmodel.AppModelView;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalMember;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalMemberFactory;
import com.kingdee.bos.bi.model.rt.bireport.calmember.zrate.ZRateCalMember;
import com.kingdee.bos.bi.model.rt.bireport.namedset.NamedSet;
import com.kingdee.bos.bi.model.rt.bireport.namedset.NamedSetFactory;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.util.StringUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class BIReportMDXUtils {
    public static final String DOT = ".";

    public static String get$dimName$(DimensionType dimType) {
        String dimName = DimensionType.measure.equals(dimType) ? "Measures" : dimType.getName();
        return "[" + dimName + "].";
    }

    public static String addSquareBrackets(String str) {
        if (StringUtil.isEmpty(str)) {
            return "";
        }
        return "[" + str + "]";
    }

    public static String addAllSquareBrackets(String str) {
        if (StringUtil.isEmpty(str)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        String[] strs = str.split("\\.");
        int n = strs.length;
        for (int i = 0; i < n; ++i) {
            sb.append(BIReportMDXUtils.addSquareBrackets(strs[i]));
            if (i == n - 1) continue;
            sb.append(DOT);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(BIReportMDXUtils.addSquareBrackets("dsd"));
        System.out.println(BIReportMDXUtils.addAllSquareBrackets("dsd.23.54.er"));
    }

    public static boolean isOKInMDX(String str) {
        if (StringUtil.isEmpty(str)) {
            return true;
        }
        char[] cs = str.toCharArray();
        int n = cs.length;
        for (int i = 0; i < n; ++i) {
            switch (cs[i]) {
                case '(': 
                case ')': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    return false;
                }
                case '.': {
                    return false;
                }
            }
        }
        return true;
    }

    public static void findRefSetFromCalMember(Context ctx, List lstCalMember, String apmId, Set lstSets) throws SQLException {
        for (DimensionMember dimMember : lstCalMember) {
            CalMember cm = CalMemberFactory.fromDB(dimMember, ctx);
            if (cm == null || StringUtil.isEmpty(cm.getAssignSet())) continue;
            lstSets.add(DimensionSet.load(ctx, apmId, cm.getDim(), cm.getAssignSet()));
        }
    }

    public static Set sortSet(Context ctx, Set lstSets, String apmId) {
        Hashtable setMap = new Hashtable();
        Iterator it = lstSets.iterator();
        while (it.hasNext()) {
            ArrayList<DimensionSet> lstSubSets = new ArrayList<DimensionSet>();
            DimensionSet dimSet = (DimensionSet)it.next();
            BIReportMDXUtils.subSet(lstSubSets, dimSet, apmId, ctx);
            lstSubSets.add(dimSet);
            Iterator t = lstSubSets.iterator();
            while (t.hasNext()) {
                BIReportMDXUtils.fillSetMap(setMap, (DimensionSet)t.next());
            }
        }
        TreeSet resultSet = new TreeSet();
        for (Map.Entry entry : setMap.entrySet()) {
            resultSet.add(entry.getValue());
        }
        return resultSet;
    }

    private static void fillSetMap(Map setMap, DimensionSet dimSet) {
        if (setMap.containsKey(dimSet.getAlias())) {
            DimensionSet anotherDimSet = (DimensionSet)setMap.get(dimSet.getAlias());
            DimensionSet smallSet = anotherDimSet.getLevel() < dimSet.getLevel() ? anotherDimSet : dimSet;
            setMap.put(smallSet.getAlias(), smallSet);
        } else {
            setMap.put(dimSet.getAlias(), dimSet);
        }
    }

    private static void subSet(List subList, DimensionSet dimSet, String apmId, Context ctx) {
        if (StringUtil.equalsIgnoreCase("Calculation", dimSet.getName())) {
            try {
                NamedSet cm = NamedSetFactory.fromDB(dimSet, apmId, ctx);
                dimSet.decreaseLevel();
                subList.add(DimensionSet.load(ctx, apmId, cm.getDim(), cm.getOperateSet1()).setLevel(dimSet.getLevel() - 1));
                subList.add(DimensionSet.load(ctx, apmId, cm.getDim(), cm.getOperateSet2()).setLevel(dimSet.getLevel() - 1));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        ArrayList subSubList = new ArrayList();
        for (DimensionSet dimSet2 : subList) {
            BIReportMDXUtils.subSet(subSubList, dimSet2, apmId, ctx);
        }
        subList.addAll(subSubList);
    }

    public static String getTimeFullPath(TimeDimensionNode selectNode, boolean isNumber) {
        int n;
        TimeTreeModel model;
        ArrayList<String> paths = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        TimeDimensionNode parentNode = selectNode;
        while ((model = parentNode.getTimeModel()) != null) {
            String str;
            String string = str = isNumber ? model.getShortNumber() : model.getName();
            if (!StringUtil.isEmpty(str)) {
                paths.add(str);
            }
            if ((parentNode = (TimeDimensionNode)parentNode.getParentNode()) != null) continue;
        }
        for (int i = n = paths.size() - 1; i >= 0; --i) {
            sb.append(paths.get(i));
            if (!isNumber || i == 0) continue;
            sb.append(DOT);
        }
        return sb.toString();
    }

    public static TimeTreeModel createTimeTreeModel(TimeDimensionNode node) {
        TimeTreeModel timeModel = new TimeTreeModel();
        timeModel.setNumber(BIReportMDXUtils.getTimeFullPath(node, true));
        timeModel.setName(BIReportMDXUtils.getTimeFullPath(node, false));
        return timeModel;
    }

    public static void findRefAggCalMamberFromCalMember(Context ctx, List lstCalMember, String appmodelId) throws SQLException {
        ArrayList<DimensionMember> refList = new ArrayList<DimensionMember>();
        AppModelView views = AppModelView.fromDB(appmodelId, ctx);
        AppModel apm = new AppModel(views, ctx);
        for (DimensionMember dimMember : lstCalMember) {
            String calDenominator;
            CalMember cm = CalMemberFactory.fromDB(dimMember, ctx);
            if (!(cm instanceof ZRateCalMember) || StringUtil.isEmpty(calDenominator = ((ZRateCalMember)cm).getCalDenominator()) || StringUtil.equalsIgnoreCase("parent", calDenominator)) continue;
            String calDim = ((ZRateCalMember)cm).getCalDim();
            Dimension dim = apm.getDimension(calDim);
            refList.add(new DimensionMember(dim, calDenominator, null, true));
        }
        Iterator it = refList.iterator();
        while (it.hasNext()) {
            lstCalMember.add(0, it.next());
        }
    }
}

