/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.bireport;

import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractTreeNode;
import com.kingdee.bos.ctrl.analysis.web.bimreport.BIMReportModel;
import com.kingdee.bos.ctrl.analysis.web.bimreport.BIMReportNode;
import com.kingdee.bos.ctrl.analysis.web.bimreport.IBIMReportTreeUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class BIReportTreeUtil
implements IBIMReportTreeUtil {
    private BIMReportNode root;

    public BIReportTreeUtil(HttpServletRequest request) throws BIReportException {
        this.root = this.load(request);
    }

    public BIMReportNode getRoot() {
        return this.root;
    }

    public BIMReportNode fromID(String id) {
        if ("-1".equalsIgnoreCase(id) || StringUtils.isEmpty((String)id)) {
            return this.root;
        }
        return this.findChildNode(this.root, id);
    }

    private BIMReportNode findChildNode(BIMReportNode node, String id) {
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            BIMReportNode n = (BIMReportNode)node.getChildNode(i);
            if (n.getModel().getNumber().equalsIgnoreCase(id)) {
                return n;
            }
            if (n.isLeaf()) continue;
            return this.findChildNode(n, id);
        }
        return null;
    }

    private BIMReportNode load(HttpServletRequest request) throws BIReportException {
        RDRowSet rowset;
        StringBuffer sb = new StringBuffer();
        sb.append("select A.FID reportID,A.FName reportName,B.FNumber folderNumber,B.FName folderName,B.FParentNumber folderParentNumber from T_BI_BIReport A left join T_BI_BIFolder B on  A.FFolderID=B.FID where A.FPublishFlag = 1 order by A.FName");
        Connection cn = null;
        try {
            cn = BISystem.getJdbcConnection((HttpServletRequest)request);
            rowset = DBUtil.executeQuery(sb.toString(), cn);
        }
        catch (SQLException e) {
            throw new BIReportException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        rowset.reset();
        if (rowset.isEof()) {
            return null;
        }
        HashMap mapForTree = new HashMap();
        BIMReportNode rootNode = new BIMReportNode(new BIMReportModel("-1", "\u4f01\u4e1a\u6307\u6807\u6a21\u578b\u5206\u6790\u62a5\u8868\u6811", true));
        mapForTree.put("-1", new ArrayList());
        while (rowset.next()) {
            ArrayList<BIMReportNode> children;
            String id = rowset.getString("reportID");
            String name = rowset.getString("reportName");
            String folderNumber = rowset.getString("folderNumber");
            String folderName = rowset.getString("folderName");
            String folderParentNumber = rowset.getString("folderParentNumber");
            BIMReportNode node = new BIMReportNode(new BIMReportModel(id, name, false));
            if (StringUtils.isEmpty((String)folderNumber)) {
                folderNumber = "-1";
            }
            if ((children = (ArrayList<BIMReportNode>)mapForTree.get(folderNumber)) == null) {
                children = new ArrayList<BIMReportNode>();
                mapForTree.put(folderNumber, children);
                BIMReportNode folderNode = new BIMReportNode(new BIMReportModel(folderNumber, folderName, true));
                ArrayList<BIMReportNode> children2 = (ArrayList<BIMReportNode>)mapForTree.get(folderParentNumber);
                if (children2 == null) {
                    children2 = new ArrayList<BIMReportNode>();
                    mapForTree.put(folderParentNumber, children2);
                }
                children2.add(folderNode);
            }
            children.add(node);
        }
        if (rootNode != null) {
            this.buildTree(rootNode, mapForTree);
        }
        return rootNode;
    }

    private void buildTree(BIMReportNode parent, Map mapForTree) {
        String number = parent.getModel().getNumber();
        List children = (List)mapForTree.get(number);
        int childrenCount = children == null ? 0 : children.size();
        for (int i = 0; i < childrenCount; ++i) {
            BIMReportNode child = (BIMReportNode)children.get(i);
            parent.addChildNode((AbstractTreeNode)child);
            this.buildTree(child, mapForTree);
        }
    }
}

