/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.bireport.calmember.history;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalMember;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalculatorType;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import java.io.IOException;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class HistoryCalMember
extends CalMember {
    private String aggType;
    private String asignSet;
    private int solveOrder;
    private String formatString;
    private List advances;
    private String appModelType;

    public HistoryCalMember(String name, String caption, DimensionType dt, String schema) {
        super(null, null, null, name, caption, dt, CalculatorType.history);
        try {
            this.fromXML(schema);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toMDX() {
        StringBuffer sb = new StringBuffer();
        sb.append(" member ");
        sb.append(this.dt.getName() + "." + this.name);
        sb.append(" as '");
        String setMDX = this.dt.getName() + ".members";
        if ("sum".equalsIgnoreCase(this.aggType)) {
            sb.append("sum({");
            sb.append(setMDX);
            sb.append("})");
        } else if ("avg".equalsIgnoreCase(this.aggType)) {
            sb.append("avg({");
            sb.append(setMDX);
            sb.append("})");
        } else if ("max".equalsIgnoreCase(this.aggType)) {
            sb.append("max({");
            sb.append(setMDX);
            sb.append("})");
        } else if ("min".equalsIgnoreCase(this.aggType)) {
            sb.append("min({");
            sb.append(setMDX);
            sb.append("})");
        } else if ("count".equalsIgnoreCase(this.aggType)) {
            sb.append("count({");
            sb.append(setMDX);
            sb.append("})");
        }
        sb.append("'");
        sb.append(",solveOrder=\"" + this.solveOrder + "'");
        if (!StringUtil.isEmpty(this.formatString)) {
            sb.append(",formatString=\"" + this.formatString + "'");
        }
        return sb.toString();
    }

    private void fromXML(String xml) throws IOException, JDOMException {
        if (StringUtil.isEmpty(xml)) {
            return;
        }
        Element e = XmlUtil.loadXmlString((String)xml);
        this.aggType = e.getAttributeValue("type");
        this.asignSet = e.getAttributeValue("asign");
        this.solveOrder = 1;
        try {
            this.solveOrder = Integer.parseInt(e.getAttributeValue("solveOrder"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.appModelType = e.getAttributeValue("appModelType");
        this.formatString = e.getAttributeValue("formatString");
        List eles = e.getChildren("measure");
        if (eles == null || eles.size() > 0) {
            // empty if block
        }
    }

    @Override
    public String getSchema() {
        StringBuffer sb = new StringBuffer();
        sb.append("");
        sb.append("");
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        sb.append("<Agg ");
        sb.append(" type=\"" + this.aggType + "\" ");
        sb.append(" asign=\"" + this.asignSet + "\" ");
        sb.append(" formatString=\"" + this.formatString + "\" ");
        sb.append(" appModelType=\"" + this.appModelType + "\" ");
        sb.append("solveOrder=\"" + this.solveOrder + "\" >");
        sb.append("</Agg>");
        return sb.toString();
    }

    @Override
    public String toMDX(Dimension dim, Context ctx) {
        return null;
    }
}

