/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.bireport.namedset;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.common.bireport.DimensionMember;
import com.kingdee.bos.bi.model.common.mm.ComboBoxObject;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.bireport.BIReportMDXUtils;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.bi.model.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractMainModel;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class NamedSet {
    private Dimension dim = null;
    private String type = null;
    private String alias = null;
    private String xml = null;
    private Integer level = new Integer(0);
    private boolean containsOwn = false;
    private AbstractMainModel[] memembers = new AbstractMainModel[0];
    private String operator = null;
    private String operateSet1 = null;
    private String operateSet2 = null;
    private boolean isNew = false;

    protected NamedSet(Dimension dim, String type, String alias, String xml) {
        this.dim = dim;
        this.type = type;
        this.alias = alias;
        this.xml = xml;
        this.setXml(xml);
        try {
            this.fromXML();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static NamedSet createNewInstanceOfNamedSet(Dimension dim, String alias, String name, String xml) {
        return new NamedSet(dim, name, alias, xml);
    }

    public Dimension getDim() {
        return this.dim;
    }

    public DimensionType getDimensionType() {
        return this.dim.getDimensionDef().getDimensionType();
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public String getOperateSet1() {
        return this.operateSet1;
    }

    public void setOperateSet1(String operateSet1) {
        this.operateSet1 = operateSet1;
    }

    public String getOperateSet2() {
        return this.operateSet2;
    }

    public void setOperateSet2(String operateSet2) {
        this.operateSet2 = operateSet2;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public AbstractMainModel[] getMemembers() {
        return this.memembers;
    }

    public void setMemembers(AbstractMainModel[] memembers) {
        this.memembers = memembers;
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public boolean isContainsOwn() {
        return this.containsOwn;
    }

    public void setContainsOwn(boolean containsOwn) {
        this.containsOwn = containsOwn;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String toString() {
        return this.alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DimensionMember createDimensionMember(AbstractMainModel model, Context ctx) throws SQLException {
        Connection cn = null;
        try {
            cn = BISystem.getJdbcConnection((Context)ctx);
            String number = model.getNumber();
            String levelName = model.getLevelName();
            String alias = (String)this.dim.findProperty(number, "name", cn);
            DimensionMember dimensionMember = new DimensionMember(this.dim, number, alias, false);
            return dimensionMember;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    protected String get$dimName$() {
        return BIReportMDXUtils.get$dimName$(this.getDimensionType());
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<set ");
        sb.append("name=\"").append(this.getAlias()).append("\" ");
        sb.append("dimension=\"").append(this.getDimensionType().getName()).append("\" ");
        sb.append("type=\"").append(this.getType()).append("\" ");
        this.xmlHandler(true, sb, null);
        return sb.toString();
    }

    public void fromXML() throws JDOMException, IOException {
        String xml = this.getXml();
        if (StringUtil.isEmpty(xml)) {
            return;
        }
        Element root = XmlUtil.toRootElement(xml);
        String alias = root.getAttributeValue("name");
        String type = root.getAttributeValue("type");
        this.setAlias(alias);
        this.setType(type);
        this.xmlHandler(false, null, root);
    }

    private void xmlHandler(boolean isToXml, StringBuffer sb, Element root) {
        if (StringUtil.equals("Members", this.type)) {
            if (isToXml) {
                sb.append("/>");
            }
        } else if (StringUtil.equals("MembersAboveLevel", this.type)) {
            if (isToXml) {
                sb.append("level=\"").append(this.getLevel()).append("\" ");
                sb.append("/>");
            } else {
                String level = root.getAttributeValue("level");
                this.setLevel(new Integer(level));
            }
        } else if (StringUtil.equals("Levels", this.type)) {
            if (isToXml) {
                sb.append("level=\"").append(this.getLevel()).append("\" ");
                sb.append("/>");
            } else {
                String level = root.getAttributeValue("level");
                this.setLevel(new Integer(level));
            }
        } else if (StringUtil.equals("Descendants", this.type)) {
            if (isToXml) {
                sb.append("member=\"").append(this.getMemembers()[0].getNumber()).append("\" ");
                sb.append("include=\"").append(this.isContainsOwn()).append("\" ");
                sb.append("/>");
            } else {
                String memberNumber = root.getAttributeValue("member");
                AbstractMainModel memember = new AbstractMainModel();
                memember.setNumber(memberNumber);
                this.setMemembers(new AbstractMainModel[]{memember});
                String include = root.getAttributeValue("include");
                this.setContainsOwn(StringUtil.toBoolean(include));
            }
        } else if (StringUtil.equals("Children", this.type)) {
            if (isToXml) {
                sb.append("member=\"").append(this.getMemembers()[0].getNumber()).append("\" ");
                sb.append("include=\"").append(this.isContainsOwn()).append("\" ");
                sb.append("/>");
            } else {
                String memberNumber = root.getAttributeValue("member");
                AbstractMainModel memember = new AbstractMainModel();
                memember.setNumber(memberNumber);
                this.setMemembers(new AbstractMainModel[]{memember});
                String include = root.getAttributeValue("include");
                this.setContainsOwn(StringUtil.toBoolean(include));
            }
        } else if (StringUtil.equals("Siblings", this.type)) {
            if (isToXml) {
                sb.append("member=\"").append(this.getMemembers()[0].getNumber()).append("\" ");
                sb.append("include=\"").append(this.isContainsOwn()).append("\" ");
                sb.append("/>");
            } else {
                String memberNumber = root.getAttributeValue("member");
                AbstractMainModel memember = new AbstractMainModel();
                memember.setNumber(memberNumber);
                this.setMemembers(new AbstractMainModel[]{memember});
                String include = root.getAttributeValue("include");
                this.setContainsOwn(StringUtil.toBoolean(include));
            }
        } else if (StringUtil.equals("Ancestor", this.type)) {
            if (isToXml) {
                sb.append("member=\"").append(this.getMemembers().length == 0 ? "" : this.getMemembers()[0].getNumber()).append("\" ");
                sb.append("include=\"").append(this.isContainsOwn()).append("\" ");
                sb.append("/>");
            } else {
                String memberNumber = root.getAttributeValue("member");
                AbstractMainModel memember = new AbstractMainModel();
                memember.setNumber(memberNumber);
                this.setMemembers(new AbstractMainModel[]{memember});
                String include = root.getAttributeValue("include");
                this.setContainsOwn(StringUtil.toBoolean(include));
            }
        } else if (StringUtil.equals("Calculation", this.type)) {
            if (isToXml) {
                sb.append("><cal type=\"single\" operator=\"").append(this.getOperator()).append("\">");
                sb.append("<operateSet1><![CDATA[").append(this.getOperateSet1()).append("]]></operateSet1>");
                sb.append("<operateSet2><![CDATA[").append(this.getOperateSet2()).append("]]></operateSet2>");
                sb.append("</cal></set>");
            } else {
                Element cal = root.getChild("cal");
                String operator = cal.getAttributeValue("operator");
                Element operateSet = cal.getChild("operateSet1");
                String operateSetName = operateSet.getText();
                Element operateSetEnd = cal.getChild("operateSet2");
                String operateSetEndName = operateSetEnd.getText();
                this.setOperator(operator);
                this.setOperateSet1(operateSetName);
                this.setOperateSet2(operateSetEndName);
            }
        } else if (StringUtil.equals("AssignMembers", this.type)) {
            if (isToXml) {
                sb.append(">");
                AbstractMainModel[] ms = this.getMemembers();
                int n = ms.length;
                for (int i = 0; i < n; ++i) {
                    sb.append("<member><![CDATA[").append(ms[i].getNumber()).append("]]></member>");
                }
                sb.append("</set>");
            } else {
                List list = root.getChildren("member");
                if (list == null) {
                    return;
                }
                AbstractMainModel[] memembers = new AbstractMainModel[list.size()];
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Element e = (Element)list.get(i);
                    String memberNumber = e.getText();
                    AbstractMainModel memember = new AbstractMainModel();
                    memember.setNumber(memberNumber);
                    memembers[i] = memember;
                }
                this.setMemembers(memembers);
            }
        } else if (isToXml) {
            sb.append("/>");
        }
    }

    public static Map load(IManagementFacade facade, AppModel apm) throws BIModelRemoteException, SQLException, JDOMException, IOException {
        HashMap setMap = new HashMap();
        StringBuffer sb = new StringBuffer();
        sb.append("select FAppModelID,FDimension,FSetName,FSetType,FSetSchema from T_BI_AppModel_Set ");
        sb.append("where FAppModelID ='").append(apm.getId()).append("' order by FDimension");
        RDRowSet rs = facade.executeQuery(sb.toString());
        while (rs.next()) {
            String dimType = rs.getString("FDimension");
            String setName = rs.getString("FSetName");
            String setType = rs.getString("FSetType");
            String xml = rs.getString("FSetSchema");
            Dimension dim = apm.getDimension(dimType);
            if (!setMap.containsKey(dimType)) {
                setMap.put(dimType, new ArrayList());
            }
            ArrayList setList = (ArrayList)setMap.get(dimType);
            setList.add(NamedSet.createNewInstanceOfNamedSet(dim, setName, setType, xml));
        }
        return setMap;
    }

    public static List loadAll(IManagementFacade facade, String appId, Dimension dim) throws SQLException, JDOMException, IOException {
        ArrayList<NamedSet> list = new ArrayList<NamedSet>();
        StringBuffer sb = new StringBuffer();
        sb.append("select FAppModelID,FDimension,FSetName,FSetType,FSetSchema from T_BI_AppModel_Set where ");
        sb.append("FAppModelID ='").append(appId).append("' and FDimension ='").append(dim.getDimensionDef().getType()).append("'");
        RDRowSet rs = facade.executeQuery(sb.toString());
        while (rs.next()) {
            String setName = rs.getString("FSetName");
            String setType = rs.getString("FSetType");
            String xml = rs.getString("FSetSchema");
            list.add(NamedSet.createNewInstanceOfNamedSet(dim, setName, setType, xml));
        }
        return list;
    }

    public static List load(IManagementFacade facade, String appId, Dimension dim, NamedSet currSetModel) throws SQLException {
        ArrayList<ComboBoxObject> list = new ArrayList<ComboBoxObject>();
        StringBuffer sb = new StringBuffer();
        sb.append("select FAppModelID,FDimension,FSetName,FSetType,FSetSchema from T_BI_AppModel_Set where ");
        sb.append("FAppModelID ='").append(appId).append("' and FDimension ='").append(dim.getDimensionDef().getType()).append("' ");
        if (currSetModel != null) {
            sb.append("and FSetName!='").append(currSetModel.getAlias()).append("'");
        }
        RDRowSet rs = facade.executeQuery(sb.toString());
        while (rs.next()) {
            String setAlias = rs.getString("FSetName");
            list.add(new ComboBoxObject(setAlias));
        }
        return list;
    }

    public static NamedSet load(Connection con, String appId, Dimension dim, String setName) throws BIModelRemoteException, SQLException, JDOMException, IOException {
        NamedSet set = null;
        StringBuffer sb = new StringBuffer();
        sb.append("select FAppModelID,FDimension,FSetName,FSetType,FSetSchema from T_BI_AppModel_Set where ");
        sb.append("FAppModelID ='").append(appId).append("' and FDimension ='").append(dim.getDimensionDef().getType()).append("' ");
        sb.append("and FSetName='").append(setName).append("'");
        RDRowSet rs = DBUtil.executeQuery(sb.toString(), con);
        while (rs.next()) {
            String setType = rs.getString("FSetType");
            String xml = rs.getString("FSetSchema");
            set = NamedSet.createNewInstanceOfNamedSet(dim, setName, setType, xml);
        }
        return set;
    }

    public static boolean isExist(IManagementFacade facade, String appId, Dimension dim, String setName) throws BIModelRemoteException, SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("select FAppModelID,FDimension,FSetName,FSetType,FSetSchema from T_BI_AppModel_Set where ");
        sb.append("FAppModelID ='").append(appId).append("'");
        sb.append("and FSetName='").append(setName).append("'");
        RDRowSet rs = facade.executeQuery(sb.toString());
        return rs.next();
    }

    public static void save(IManagementFacade facade, String appId, Dimension dim, NamedSet model) throws BIModelRemoteException, SQLException {
        NamedSet.delete(facade, appId, dim, model);
        String sql = "insert into T_BI_AppModel_Set(FAppModelID,FDimension,FSetName,FSetType,FSetSchema) values(?,?,?,?,?)";
        Object[] params = new Object[]{appId, dim.getDimensionDef().getType(), model.getAlias(), model.getType(), model.toXML()};
        facade.executeUpdate("insert into T_BI_AppModel_Set(FAppModelID,FDimension,FSetName,FSetType,FSetSchema) values(?,?,?,?,?)", params);
    }

    public static void delete(IManagementFacade facade, String appId, Dimension dim, NamedSet model) throws BIModelRemoteException, SQLException {
        facade.executeUpdate(NamedSet.getDeleteSql(appId, dim, model));
    }

    private static String getDeleteSql(String appId, Dimension dim, NamedSet model) {
        StringBuffer sb = new StringBuffer();
        sb.append("delete from T_BI_AppModel_Set where FAppModelID ='").append(appId);
        sb.append("' and FDimension='").append(dim.getDimensionDef().getType());
        sb.append("' and FSetName='").append(model.getAlias()).append("'");
        return sb.toString();
    }

    public String toMDX(Context ctx) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.get$dimName$()).append("members");
        return sb.toString();
    }

    public static void main(String[] args) {
        AbstractSet set = new HashSet();
        set = new TreeSet();
        set.add("b");
        set.add("a");
        set.add("d");
        set.add("c");
        set.add("d");
        Iterator it = set.iterator();
        while (it.hasNext()) {
            System.out.print(it.next());
        }
        System.out.println();
    }
}

