/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.bireport.namedset;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.bireport.DimensionSet;
import com.kingdee.bos.bi.model.rt.bireport.namedset.NamedSet;
import com.kingdee.bos.bi.model.rt.bireport.namedset.impl.AncestorNamedSet;
import com.kingdee.bos.bi.model.rt.bireport.namedset.impl.AssignMembersNamedSet;
import com.kingdee.bos.bi.model.rt.bireport.namedset.impl.CalculationNamedSet;
import com.kingdee.bos.bi.model.rt.bireport.namedset.impl.ChildrenNamedSet;
import com.kingdee.bos.bi.model.rt.bireport.namedset.impl.DescendantsNamedSet;
import com.kingdee.bos.bi.model.rt.bireport.namedset.impl.LevelsNamedSet;
import com.kingdee.bos.bi.model.rt.bireport.namedset.impl.MembersAboveLevelNamedSet;
import com.kingdee.bos.bi.model.rt.bireport.namedset.impl.MembersNamedSet;
import com.kingdee.bos.bi.model.rt.bireport.namedset.impl.SiblingsNamedSet;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.jdom2.JDOMException;

public class NamedSetFactory {
    public static NamedSet createNamedSet(Dimension dim, String setType, String alias, String xml) {
        if (StringUtil.equalsIgnoreCase("Members", setType)) {
            return new MembersNamedSet(dim, setType, alias, xml);
        }
        if (StringUtil.equals("MembersAboveLevel", setType)) {
            return new MembersAboveLevelNamedSet(dim, setType, alias, xml);
        }
        if (StringUtil.equals("Levels", setType)) {
            return new LevelsNamedSet(dim, setType, alias, xml);
        }
        if (StringUtil.equals("Descendants", setType)) {
            return new DescendantsNamedSet(dim, setType, alias, xml);
        }
        if (StringUtil.equals("Children", setType)) {
            return new ChildrenNamedSet(dim, setType, alias, xml);
        }
        if (StringUtil.equals("Siblings", setType)) {
            return new SiblingsNamedSet(dim, setType, alias, xml);
        }
        if (StringUtil.equals("Ancestor", setType)) {
            return new AncestorNamedSet(dim, setType, alias, xml);
        }
        if (StringUtil.equals("Calculation", setType)) {
            return new CalculationNamedSet(dim, setType, alias, xml);
        }
        if (StringUtil.equals("AssignMembers", setType)) {
            return new AssignMembersNamedSet(dim, setType, alias, xml);
        }
        return new MembersNamedSet(dim, setType, alias, xml);
    }

    public static NamedSet fromXML(String xml, Context ctx) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamedSet fromDB(DimensionSet dimSet, String appId, Context ctx) {
        Connection cn = null;
        try {
            cn = BISystem.getJdbcConnection((Context)ctx);
            NamedSet set = NamedSet.load(cn, appId, dimSet.getDim(), dimSet.getAlias());
            NamedSet namedSet = NamedSetFactory.createNamedSet(set.getDim(), set.getType(), set.getAlias(), set.getXml());
            return namedSet;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BIModelRemoteException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return null;
    }
}

