/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.dim.custom.time;

import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.common.mm.time.TimeDimensionNode;
import com.kingdee.bos.bi.model.common.mm.time.TimeModel;
import com.kingdee.bos.bi.model.common.mm.time.TimeUtil;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.DimensionView;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractTreeNode;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;

public class TimeDimensionView
extends DimensionView {
    private static final long serialVersionUID = 72742333790266427L;

    public TimeDimensionView(DimensionType dt, String viewId) {
        super(dt, viewId, null, null);
    }

    @Override
    protected void transData(String pubnumber, Connection cn) throws SQLException {
        TimeModel t = this.getTimeModel(this.id, cn);
        this.insertTimeData(pubnumber, this.id, t, cn);
    }

    @Override
    public String getTablename() {
        if (this.view_table == null) {
            DimensionType dt = this.dm.getDimensionType();
            String name = dt.getName();
            String type = dt.getInnerType();
            this.view_table = ("T_BI_MM_" + type + "_" + name).toUpperCase();
        }
        return this.view_table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimeModel getTimeModel(String viewid, Connection cn) throws SQLException {
        TimeModel m = null;
        StringBuffer sb = new StringBuffer();
        sb.append("select FTimeBegin,FTimeEnd,FYearEnabled,FHalfYearEnabled,FQuarterEnabled,FMonthEnabled,FDayEnabled from ");
        sb.append(this.getTablename()).append(" where FViewID='").append(viewid).append("'");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = cn.prepareStatement(sb.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                m = new TimeModel();
                m.setDateBegin((Date)rs.getObject("FTimeBegin"));
                m.setDateEnd((Date)rs.getObject("FTimeEnd"));
                m.setUseYear(rs.getInt("FYearEnabled") == 1);
                m.setUseHalfYear(rs.getInt("FHalfYearEnabled") == 1);
                m.setUseQuarter(rs.getInt("FQuarterEnabled") == 1);
                m.setUseMonth(rs.getInt("FMonthEnabled") == 1);
                m.setUseDay(rs.getInt("FDayEnabled") == 1);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)stmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return m;
    }

    private Time createRowData(Calendar calendar) {
        Time time = new Time();
        time.setId(TimeUtil.getIntTime(calendar));
        time.setYear(TimeUtil.getYear(calendar));
        time.setHalfYear(TimeUtil.getHalfYear(calendar));
        time.setQuarter(TimeUtil.getQuarter(calendar));
        time.setMonth(TimeUtil.getMonth(calendar));
        time.setDate(TimeUtil.getDay(calendar));
        time.setTime(new Timestamp(calendar.getTime().getTime()));
        time.setFlag(0);
        return time;
    }

    private void insertTimeData(String pubnumber, String viewid, TimeModel tm, Connection cn) throws SQLException {
        Set set = this.getInsertDatas(tm);
        String tableName = this.dm.getTablename(pubnumber);
        this.doInsertDatas(set, tableName, cn);
    }

    private Set getInsertDatas(TimeModel tm) {
        int h;
        int j;
        int m;
        int i;
        int n;
        TreeSet<Time> set = new TreeSet<Time>();
        Calendar calendar = null;
        Calendar startTime = TimeUtil.createCalendar(tm.getDateBegin());
        Calendar endTime = TimeUtil.createCalendar(tm.getDateEnd());
        int startYear = TimeUtil.getYear(startTime);
        int endYear = TimeUtil.getYear(endTime);
        if (tm.getUseYear()) {
            calendar = TimeUtil.createCalendar(startTime.getTime());
            int n2 = endYear;
            for (int i2 = startYear; i2 <= n2; ++i2) {
                TimeUtil.resetCalendarAll(calendar, i2, 1, 1);
                set.add(this.createRowData(calendar));
            }
        }
        if (tm.getUseHalfYear()) {
            calendar = TimeUtil.createCalendar(startTime.getTime());
            int sh = TimeUtil.getHalfYear(startTime);
            int eh = TimeUtil.getHalfYear(endTime);
            n = endYear;
            for (i = startYear; i <= n; ++i) {
                m = 2;
                for (j = 1; j <= m; ++j) {
                    if (i == startYear && j < sh || i == endYear && j > eh) continue;
                    h = (j - 1) * 6 + 1;
                    TimeUtil.resetCalendarAll(calendar, i, h, 1);
                    set.add(this.createRowData(calendar));
                }
            }
        }
        if (tm.getUseQuarter()) {
            calendar = TimeUtil.createCalendar(startTime.getTime());
            int sq = TimeUtil.getQuarter(startTime);
            int eq = TimeUtil.getQuarter(endTime);
            n = endYear;
            for (i = startYear; i <= n; ++i) {
                m = 4;
                for (j = 1; j <= m; ++j) {
                    if (i == startYear && j < sq || i == endYear && j > eq) continue;
                    h = (j - 1) * 3 + 1;
                    TimeUtil.resetCalendarAll(calendar, i, h, 1);
                    set.add(this.createRowData(calendar));
                }
            }
        }
        if (tm.getUseMonth()) {
            calendar = TimeUtil.createCalendar(startTime.getTime());
            int sm = TimeUtil.getMonth(startTime);
            int em = TimeUtil.getMonth(endTime);
            n = endYear;
            for (i = startYear; i <= n; ++i) {
                m = 12;
                for (j = 1; j <= m; ++j) {
                    if (i == startYear && j < sm || i == endYear && j > em) continue;
                    h = j;
                    TimeUtil.resetCalendarAll(calendar, i, h, 1);
                    set.add(this.createRowData(calendar));
                }
            }
        }
        if (tm.getUseDay()) {
            calendar = TimeUtil.createCalendar(startTime.getTime());
            int endDay = TimeUtil.getIntTime(endTime);
            while (TimeUtil.getIntTime(calendar) <= endDay) {
                set.add(this.createRowData(calendar));
                calendar.add(5, 1);
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getDataBaseDatas(String pubnumber, Connection cn) throws SQLException {
        TreeSet<Time> set = new TreeSet<Time>();
        String tableName = this.dm.getTablename(pubnumber);
        String sql = "select FId,FYear,FHalfYear,FQuarter,FMonth,FDay,FTime,FFlag from " + tableName + " order by FId asc";
        PreparedStatement stmt = cn.prepareStatement(sql);
        ResultSet rs = stmt.executeQuery();
        Time time = null;
        try {
            while (rs.next()) {
                time = new Time();
                time.setId(rs.getInt("FId"));
                time.setYear(rs.getInt("FYear"));
                time.setHalfYear(rs.getInt("FHalfYear"));
                time.setQuarter(rs.getInt("FQuarter"));
                time.setDate(rs.getInt("FDay"));
                time.setTime((Date)rs.getObject("FTime"));
                time.setFlag(rs.getInt("FFlag"));
                set.add(time);
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        }
        return set;
    }

    private int[] doInsertDatas(Set set, String tableName, Connection cn) throws SQLException {
        String sql = "insert into " + tableName + "(FID,FYEAR,FHALFYEAR,FQUARTER,FMONTH,FDAY,FTIME,FFlag) VALUES(?,?,?,?,?,?,?,0)";
        PreparedStatement pstmt = cn.prepareStatement(sql);
        Time t2 = null;
        for (Time t2 : set) {
            pstmt.setInt(1, t2.getId());
            pstmt.setInt(2, t2.getYear());
            pstmt.setInt(3, t2.getHalfYear());
            pstmt.setInt(4, t2.getQuarter());
            pstmt.setInt(5, t2.getMonth());
            pstmt.setInt(6, t2.getDate());
            pstmt.setObject(7, t2.getTime());
            pstmt.addBatch();
        }
        return pstmt.executeBatch();
    }

    private int[] doDeleteDatas(Set set, String tableName, Connection cn) throws SQLException {
        String sql = "update " + tableName + " set FFlag=1 where FID=?";
        PreparedStatement pstmt = cn.prepareStatement(sql);
        Time t2 = null;
        for (Time t2 : set) {
            if (t2.getFlag() == 1) continue;
            pstmt.setInt(1, t2.getId());
            pstmt.addBatch();
        }
        return pstmt.executeBatch();
    }

    private int[] doUpdateDatas(Set set, String tableName, Connection cn) throws SQLException {
        String sql = "update " + tableName + " set FFlag=0 where FID=?";
        PreparedStatement pstmt = cn.prepareStatement(sql);
        Time t2 = null;
        for (Time t2 : set) {
            if (t2.getFlag() == 0) continue;
            pstmt.setInt(1, t2.getId());
            pstmt.addBatch();
        }
        return pstmt.executeBatch();
    }

    @Override
    protected void synData(String pubnumber, String viewid, Connection cn) throws SQLException {
        DimensionMeta dm = this.getDimensionDef();
        DimensionType dt = dm.getDimensionType();
        String dimType = dt.getName();
        TimeModel newMetaData = null;
        TimeModel oldMetaData = null;
        try {
            newMetaData = TimeModel.load(cn, viewid, dimType);
            oldMetaData = TimeModel.load2(cn, pubnumber, dimType);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        if (!newMetaData.equals(oldMetaData)) {
            Set newSet = this.getInsertDatas(newMetaData);
            Set oldSet = this.getDataBaseDatas(pubnumber, cn);
            TreeSet<Time> update = new TreeSet<Time>();
            Time oTime2 = null;
            for (Time oTime2 : oldSet) {
                if (!newSet.contains(oTime2)) continue;
                update.add(oTime2);
            }
            newSet.removeAll(update);
            oldSet.removeAll(update);
            String tableName = dm.getTablename(pubnumber);
            this.doInsertDatas(newSet, tableName, cn);
            this.doDeleteDatas(oldSet, tableName, cn);
            this.doUpdateDatas(update, tableName, cn);
            try {
                String xml = TimeModel.toXml(newMetaData);
                this.updateMetaData(xml, pubnumber, dimType, cn);
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
        }
    }

    private void updateMetaData(String metaDate, String pubNumber, String dimType, Connection cn) throws SQLException {
        String sql = "update T_BI_AM_MetaData set FLastUpdateTime=getdate(),FDimMetaData=? where FAMID= (select FID from T_BI_AppModel where FPublishNumber=? ) and FDimType=? ";
        DBUtil.executeUpdate(cn, "update T_BI_AM_MetaData set FLastUpdateTime=getdate(),FDimMetaData=? where FAMID= (select FID from T_BI_AppModel where FPublishNumber=? ) and FDimType=? ", new Object[]{metaDate, pubNumber, dimType});
    }

    @Override
    public AbstractTreeNode getRootNode(IManagementFacade facade) throws BIModelRemoteException {
        return TimeDimensionNode.load(facade, this.id, this.dm.getDimensionType());
    }

    private class Time
    implements Comparable {
        private int id;
        private int year;
        private int halfYear;
        private int quarter;
        private int month;
        private int date;
        private Date time;
        private int flag;

        private Time() {
        }

        public int getFlag() {
            return this.flag;
        }

        public void setFlag(int flag) {
            this.flag = flag;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getYear() {
            return this.year;
        }

        public void setYear(int year) {
            this.year = year;
        }

        public int getHalfYear() {
            return this.halfYear;
        }

        public void setHalfYear(int halfYear) {
            this.halfYear = halfYear;
        }

        public int getQuarter() {
            return this.quarter;
        }

        public void setQuarter(int quarter) {
            this.quarter = quarter;
        }

        public int getMonth() {
            return this.month;
        }

        public void setMonth(int month) {
            this.month = month;
        }

        public int getDate() {
            return this.date;
        }

        public void setDate(int date) {
            this.date = date;
        }

        public Date getTime() {
            return this.time;
        }

        public void setTime(Date time) {
            this.time = time;
        }

        public String toString() {
            return Integer.toString(this.id);
        }

        public int compareTo(Object obj) {
            Time another = (Time)obj;
            return another == null ? -1 : this.getId() - another.getId();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Time) {
                return ((Time)obj).getId() == this.getId();
            }
            return false;
        }
    }
}

