/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.security;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.Member;
import com.kingdee.bos.bi.model.rt.dim.MemberBaseTreeNode;
import com.kingdee.bos.bi.model.rt.dim.Property;
import com.kingdee.bos.bi.model.security.Logic;
import com.kingdee.bos.bi.model.security.Operator;
import com.kingdee.bos.bi.model.security.Parenthesis;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractTreeNode;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;

public class SecureFilterItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Parenthesis leftP;
    public Property prop;
    public Member measure;
    public Operator op;
    public Object value;
    public Parenthesis rightP;
    public Logic logic;
    public DimensionMeta dm;
    private boolean isForMeasure;
    public static final String TAG_ITEM = "item";
    private static final String ITEM_LeftP = "LeftP";
    private static final String ITEM_Attribute = "Attribute";
    private static final String ITEM_MeasureNumber = "MeasureNumber";
    private static final String ITEM_MeasureName = "MeasureName";
    private static final String ITEM_Operator = "Operator";
    private static final String TAG_Member = "Member";
    private static final String TAG_Value = "Value";
    private static final String TAG_Number = "Number";
    private static final String TAG_Caption = "Caption";
    private static final String ITEM_RightP = "RightP";
    private static final String ITEM_Logic = "Logic";

    public SecureFilterItem(Parenthesis leftP, Property prop, Operator op, Object value, Parenthesis rightP, Logic logic, DimensionMeta dm) {
        this.leftP = leftP;
        this.prop = prop;
        this.op = op;
        this.value = value;
        this.rightP = rightP;
        this.logic = logic;
        this.dm = dm;
        this.isForMeasure = false;
    }

    public SecureFilterItem(Parenthesis leftP, Member member, Operator op, Object value, Parenthesis rightP, Logic logic, DimensionMeta dm) {
        this.leftP = leftP;
        this.measure = member;
        this.op = op;
        this.value = value;
        this.rightP = rightP;
        this.logic = logic;
        this.dm = dm;
        this.isForMeasure = true;
    }

    public Object clone() {
        Property newProp;
        ArrayList newValue = null;
        if (this.measure != null || this.op.getMethod().equalsIgnoreCase(Operator.METHOD_INPUT)) {
            newValue = this.value;
        } else if (this.value != null) {
            newValue = new ArrayList();
            for (MemberBaseTreeNode node : (List)this.value) {
                ((List)newValue).add(node.clone());
            }
        }
        Parenthesis newLeftP = this.leftP != null ? (Parenthesis)this.leftP.clone() : null;
        Operator newOp = this.op != null ? (Operator)this.op.clone() : null;
        Parenthesis newRightP = this.rightP != null ? (Parenthesis)this.rightP.clone() : null;
        Logic newLogic = this.logic != null ? (Logic)this.logic.clone() : null;
        Property property = newProp = this.prop != null ? (Property)this.prop.clone() : null;
        if (this.isForMeasure) {
            return new SecureFilterItem(newLeftP, this.measure, newOp, newValue, newRightP, newLogic, this.dm);
        }
        return new SecureFilterItem(newLeftP, newProp, newOp, newValue, newRightP, newLogic, this.dm);
    }

    public Logic getLogic() {
        return this.logic;
    }

    public boolean isMeasure() {
        return this.dm.isMeasure();
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<item");
        if (this.leftP.getCount() != 0) {
            sb.append(" LeftP=\"" + this.leftP.getCount() + "\"");
        }
        if (this.measure == null) {
            sb.append(" Attribute=\"" + this.prop.getName() + "\"");
        } else {
            sb.append(" MeasureNumber=\"" + this.measure.getNumber() + "\"");
            sb.append(" MeasureName=\"" + this.measure.getName() + "\"");
        }
        sb.append(" Operator=\"" + this.op.toXML() + "\"");
        if (this.rightP.getCount() != 0) {
            sb.append(" RightP=\"" + this.rightP.getCount() + "\"");
        }
        if (this.logic != null) {
            sb.append(" Logic=\"" + this.logic.getName() + "\"");
        }
        sb.append(">");
        if (this.measure != null || this.op.getMethod().equalsIgnoreCase(Operator.METHOD_INPUT)) {
            sb.append("<Value>");
            sb.append(this.value);
            sb.append("</Value>");
        } else {
            Iterator it = ((List)this.value).iterator();
            while (it.hasNext()) {
                Object node;
                sb.append("<Member>");
                sb.append("<Number><![CDATA[");
                String name = "";
                String number = "";
                Object obj = it.next();
                Object userObj = ((DefaultKingdeeTreeNode)obj).getUserObject();
                if (userObj instanceof AbstractTreeNode) {
                    node = (AbstractTreeNode)userObj;
                    number = node.getModel().getNumber();
                    name = node.getModel().getName();
                } else if (userObj instanceof Member) {
                    node = (Member)userObj;
                    number = ((Member)node).getNumber();
                    name = ((Member)node).getName();
                }
                sb.append(number);
                sb.append("]]></Number>");
                sb.append("<Caption><![CDATA[");
                sb.append(name);
                sb.append("]]></Caption>");
                sb.append("</Member>");
            }
        }
        sb.append("</item>");
        return sb.toString();
    }

    public Parenthesis getLeftP() {
        return this.leftP;
    }

    public Parenthesis getRightP() {
        return this.rightP;
    }

    public String getInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getLeftP());
        sb.append("[");
        if (this.measure == null) {
            if (this.prop != null) {
                if (this.prop.isInner()) {
                    sb.append(this.dm.getDimensionType().getAlias());
                } else {
                    sb.append(this.prop.getAlias());
                }
            }
        } else {
            sb.append(this.measure.getName());
        }
        sb.append("]");
        sb.append(" " + (this.op == null ? "" : this.op.getAlias()));
        sb.append(" ");
        if (this.measure != null || this.op.getMethod().equalsIgnoreCase(Operator.METHOD_INPUT)) {
            if (this.measure == null) {
                sb.append("'");
            }
            sb.append(this.value);
            if (this.measure == null) {
                sb.append("'");
            }
        } else {
            Iterator it = ((List)this.value).iterator();
            boolean isFirst = true;
            sb.append("\"");
            while (it.hasNext()) {
                Object node;
                String name = "";
                Object obj = it.next();
                Object userObj = ((DefaultKingdeeTreeNode)obj).getUserObject();
                if (userObj instanceof AbstractTreeNode) {
                    node = (AbstractTreeNode)userObj;
                    name = node.getModel().getName();
                } else if (userObj instanceof Member) {
                    node = (Member)userObj;
                    name = ((Member)node).getName();
                }
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(",");
                }
                sb.append(name);
            }
            sb.append("\"");
        }
        sb.append(this.getRightP());
        if (this.logic != null) {
            sb.append(" " + this.logic + " ");
        }
        return sb.toString();
    }

    public static SecureFilterItem fromNode(Element ele, DimensionMeta dm) {
        String strLeftP = ele.getAttributeValue(ITEM_LeftP);
        int iLeftP = strLeftP == null ? 0 : Integer.parseInt(strLeftP);
        Parenthesis left = new Parenthesis(true, iLeftP);
        Property prop = null;
        Member measure = null;
        String propName = ele.getAttributeValue(ITEM_Attribute);
        if (propName != null) {
            prop = dm.findProperty(propName);
        } else {
            String measureNmmber = ele.getAttributeValue(ITEM_MeasureNumber);
            String measureName = ele.getAttributeValue(ITEM_MeasureName);
            measure = new Member(measureNmmber, measureName);
        }
        String operator = ele.getAttributeValue(ITEM_Operator);
        Operator op = Operator.getObj(operator);
        String strRightP = ele.getAttributeValue(ITEM_RightP);
        int iRightP = strRightP == null ? 0 : Integer.parseInt(strRightP);
        Parenthesis right = new Parenthesis(false, iRightP);
        Logic logic = Logic.getObj(ele.getAttributeValue(ITEM_Logic));
        Object objValue = null;
        ArrayList<MemberBaseTreeNode> members = new ArrayList<MemberBaseTreeNode>();
        if (measure != null || op.getMethod().equalsIgnoreCase(Operator.METHOD_INPUT)) {
            objValue = ele.getChild(TAG_Value).getText();
        } else {
            List lstValue = ele.getChildren(TAG_Member);
            if (lstValue != null) {
                for (Element e : lstValue) {
                    String number = e.getChild(TAG_Number).getText();
                    String caption = e.getChild(TAG_Caption).getText();
                    members.add(new MemberBaseTreeNode(number, caption));
                }
            }
            objValue = members;
        }
        if (measure == null) {
            return new SecureFilterItem(left, prop, op, objValue, right, logic, dm);
        }
        return new SecureFilterItem(left, measure, op, objValue, right, logic, dm);
    }

    public String toSql(Context ctx) {
        StringBuffer sb = new StringBuffer();
        sb.append(" " + this.leftP.toString());
        sb.append(this.op.toSql(ctx, this.prop, this.value));
        sb.append(this.rightP.toString() + " ");
        return sb.toString();
    }

    public boolean match(Object compareValue, Dimension dm, Connection cn) throws SQLException {
        if (!this.prop.isInner()) {
            compareValue = dm.findProperty((String)compareValue, this.prop.getField(), cn);
        }
        return this.op.match(compareValue, this.value);
    }
}

