/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.security;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.rt.appmodel.AppModelView;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.DimensionView;
import com.kingdee.bos.bi.model.rt.dim.Member;
import com.kingdee.bos.bi.model.security.SecurityObjectType;
import com.kingdee.bos.bi.model.security.cell.CellSecureFilter;
import com.kingdee.bos.bi.model.security.row.RowSecureFilter;
import com.kingdee.bos.bi.model.security.row.RowSecureMapping;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class SecureManager {
    private static final Logger log = CommonLogger.getLogger(SecureManager.class);
    private static Map allDimSecurity = new HashMap();
    private static Map allCellSecurity = new HashMap();
    public static final String KEY_USER_MAPPING = "userMapping";
    public static final String KEY_ORG_MAPPING = "orgMapping";

    private static Map getSecurityDimensionViews(Context ctx) {
        String ais = ctx.getAIS();
        Map securityDimensionViews = null;
        if (allDimSecurity.containsKey(ais)) {
            securityDimensionViews = (Map)allDimSecurity.get(ais);
        } else {
            securityDimensionViews = new HashMap();
            allDimSecurity.put(ais, securityDimensionViews);
        }
        return securityDimensionViews;
    }

    public static Map getRowSecure(Context ctx, Dimension dim) throws SQLException {
        Map securityDimensionViews = SecureManager.getSecurityDimensionViews(ctx);
        Map<String, RowSecureMapping> secureDimensionView = null;
        String view_id = dim.getViewId();
        if (securityDimensionViews.containsKey(view_id)) {
            secureDimensionView = (Map)securityDimensionViews.get(view_id);
        } else {
            RowSecureMapping rmOrg;
            secureDimensionView = new HashMap();
            securityDimensionViews.put(view_id, secureDimensionView);
            SecureManager.loadRowSecureFilter(ctx, dim, secureDimensionView);
            RowSecureMapping rmUser = SecureManager.loadRowSecureMapping(ctx, dim, SecurityObjectType.user);
            if (rmUser != null) {
                secureDimensionView.put(KEY_USER_MAPPING, rmUser);
            }
            if ((rmOrg = SecureManager.loadRowSecureMapping(ctx, dim, SecurityObjectType.org)) != null) {
                secureDimensionView.put(KEY_ORG_MAPPING, rmOrg);
            }
        }
        return secureDimensionView;
    }

    public static void delRowSecureMapping(Context ctx, String view_id, String mappingType) throws SQLException {
        Map securityDimensionViews = SecureManager.getSecurityDimensionViews(ctx);
        Map secureDimensionView = (Map)securityDimensionViews.get(view_id);
        if (secureDimensionView != null) {
            secureDimensionView.remove(mappingType);
        }
    }

    public static void delRowSecureFilter(Context ctx, String view_id) throws SQLException {
        Map securityDimensionViews = SecureManager.getSecurityDimensionViews(ctx);
        Map secureDimensionView = (Map)securityDimensionViews.get(view_id);
        if (secureDimensionView != null) {
            Iterator it = secureDimensionView.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                if (KEY_USER_MAPPING.equals(key) || KEY_ORG_MAPPING.equals(key)) continue;
                it.remove();
            }
        }
    }

    public static void delCellSecureFilter(Context ctx, String view_id) throws SQLException {
        Map secureAppmodels = SecureManager.getCellSecureAis(ctx);
        Iterator it = secureAppmodels.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key.indexOf(view_id + "!") != 0) continue;
            it.remove();
        }
    }

    public static void saveRowSecureFilter(Context ctx, String view_id, RowSecureFilter rsf) {
        Map securityDimensionViews = SecureManager.getSecurityDimensionViews(ctx);
        Map<String[], RowSecureFilter> secureDimensionView = null;
        if (securityDimensionViews.containsKey(view_id)) {
            secureDimensionView = (Map)securityDimensionViews.get(view_id);
        } else {
            secureDimensionView = new HashMap();
            securityDimensionViews.put(view_id, secureDimensionView);
        }
        secureDimensionView.put(rsf.getSecurityObjects().getIds(), rsf);
    }

    public static void saveCellSecureFilter(Context ctx, String view_id, String measureNumber, CellSecureFilter csf) throws SQLException {
        Map secureAppmodels = SecureManager.getCellSecureAis(ctx);
        Map<String, CellSecureFilter> secureAppmodel = null;
        String key = view_id + "!" + measureNumber;
        if (secureAppmodels.containsKey(key)) {
            secureAppmodel = (Map)secureAppmodels.get(key);
        } else {
            secureAppmodel = new HashMap();
            secureAppmodels.put(key, secureAppmodel);
        }
        secureAppmodel.put(key, csf);
    }

    public static void saveRowSecureMapping(Context ctx, String view_id, RowSecureMapping rsm) {
        Map securityDimensionViews = SecureManager.getSecurityDimensionViews(ctx);
        Map<String, RowSecureMapping> secureDimensionView = null;
        if (securityDimensionViews.containsKey(view_id)) {
            secureDimensionView = (Map)securityDimensionViews.get(view_id);
        } else {
            secureDimensionView = new HashMap();
            securityDimensionViews.put(view_id, secureDimensionView);
        }
        if (rsm.getObjectType().equals(SecurityObjectType.user)) {
            secureDimensionView.put(KEY_USER_MAPPING, rsm);
        } else if (rsm.getObjectType().equals(SecurityObjectType.org)) {
            secureDimensionView.put(KEY_ORG_MAPPING, rsm);
        }
    }

    public static void updateRowSecureMappingStatus(Context ctx, String view_id, boolean useFlag, SecurityObjectType st) {
        Map securityDimensionViews = SecureManager.getSecurityDimensionViews(ctx);
        Map secureDimensionView = null;
        if (!securityDimensionViews.containsKey(view_id)) {
            return;
        }
        secureDimensionView = (Map)securityDimensionViews.get(view_id);
        RowSecureMapping rsm = null;
        if (st.equals(SecurityObjectType.user)) {
            rsm = (RowSecureMapping)secureDimensionView.get(KEY_USER_MAPPING);
        } else if (st.equals(SecurityObjectType.org)) {
            rsm = (RowSecureMapping)secureDimensionView.get(KEY_ORG_MAPPING);
        } else {
            return;
        }
        if (rsm != null) {
            rsm.setUsedFlag(useFlag);
        }
    }

    public static Map getCellSecure(Context ctx, String view_id, String measureNumber) throws SQLException {
        Map secureAppmodels = SecureManager.getCellSecureAis(ctx);
        Map secureAppmodel = null;
        String key = view_id + "!" + measureNumber;
        if (secureAppmodels.containsKey(key)) {
            secureAppmodel = (Map)secureAppmodels.get(key);
        } else {
            secureAppmodel = new HashMap();
            secureAppmodels.put(key, secureAppmodel);
            AppModelView apv = AppModelView.fromDB(view_id, ctx);
            DimensionView dv = apv.getDimRef().getDimensionView(DimensionType.measure.getName());
            Member measure = dv.findMember(ctx, measureNumber);
            SecureManager.loadCellSecure(ctx, apv, measure, secureAppmodel);
        }
        return secureAppmodel;
    }

    public static Map getCellSecureAis(Context ctx) throws SQLException {
        String ais = ctx.getAIS();
        Map secureAppmodels = null;
        if (allCellSecurity.containsKey(ais)) {
            secureAppmodels = (Map)allCellSecurity.get(ais);
        } else {
            secureAppmodels = new HashMap();
            allCellSecurity.put(ais, secureAppmodels);
        }
        return secureAppmodels;
    }

    /*
     * Exception decompiling
     */
    private static void loadRowSecureFilter(Context ctx, Dimension dim, Map secureDimensionView) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RowSecureMapping loadRowSecureMapping(Context ctx, Dimension dim, SecurityObjectType objectType) throws SQLException {
        String sql;
        RowSecureMapping rsm;
        String view_id;
        PreparedStatement stmt;
        ResultSet rs;
        Connection cn;
        block6: {
            RowSecureMapping rowSecureMapping;
            cn = null;
            rs = null;
            stmt = null;
            view_id = dim.getViewId();
            rsm = null;
            try {
                cn = BISystem.getJdbcConnection((Context)ctx);
                sql = "";
                if (SecurityObjectType.user == objectType) {
                    sql = "select FMapCenterID, FMapTable, FUserColumn, FFilterAttr,FAttrColumn,FUseFlag from T_BI_SU_Mapping where FMMViewID=?";
                    break block6;
                }
                if (SecurityObjectType.org == objectType) {
                    sql = "select FMapCenterID, FMapTable, FOrgColumn, FFilterAttr,FAttrColumn,FUseFlag from T_BI_SO_Mapping where FMMViewID=?";
                    break block6;
                }
                rowSecureMapping = null;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)stmt, (Connection)cn);
            return rowSecureMapping;
        }
        stmt = cn.prepareStatement(sql);
        stmt.setString(1, view_id);
        rs = stmt.executeQuery();
        if (rs.next()) {
            String centerId = rs.getString(1);
            String mapTablename = rs.getString(2);
            String mapObjColumn = rs.getString(3);
            String filterAttr = rs.getString(4);
            String mapAttrColumn = rs.getString(5);
            int useFlag = rs.getInt(6);
            rsm = new RowSecureMapping(centerId, mapTablename, objectType, mapObjColumn, filterAttr, mapAttrColumn, view_id, useFlag == 1);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return rsm;
    }

    /*
     * Exception decompiling
     */
    private static void loadCellSecure(Context ctx, AppModelView apv, Member measure, Map secureAppmodel) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

