/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.bireport;

import com.kingdee.bos.bi.model.common.EnumObj;
import com.kingdee.bos.bi.model.common.mm.ComboBoxObject;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.dialog.bireport.BIReportDialog;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;

public class SelAppModelListener
implements SelectorListener {
    private KDPromptBox promptSelector;
    private IManagementFacade facade;
    private JComponent owner;
    private SimpleDialog dlg;
    private KDPanel panel = new KDPanel();
    private KDList lstAppModel;
    private BIReportDialog dlgReport;

    public SelAppModelListener(KDPromptBox promptSelector, IManagementFacade facade, BIReportDialog dlgReport) throws SQLException {
        BIReportDialog.appTypes.clear();
        this.owner = promptSelector;
        this.promptSelector = promptSelector;
        this.facade = facade;
        this.dlgReport = dlgReport;
        this.lstAppModel = new KDList();
        List appModels = facade.getAppModels();
        int len = appModels.size();
        for (int i = 0; i < len; ++i) {
            ComboBoxObject comb = (ComboBoxObject)appModels.get(i);
            String name = comb.getName();
            String id = comb.getCode();
            String type = comb.getInfo();
            BIReportDialog.appTypes.put(id, type);
            EnumObj obj = new EnumObj(id, name);
            this.lstAppModel.addElement((Object)obj);
        }
        this.addControls();
    }

    public void willShow(SelectorEvent e) {
        EnumObj app;
        if (this.dlg == null) {
            Window win = SwingUtilities.getWindowAncestor(this.owner);
            this.dlg = win instanceof Frame ? new SimpleDialog((Frame)win) : (win instanceof Dialog ? new SimpleDialog((Dialog)win) : new SimpleDialog());
            this.dlg.setComponent((Component)this.getPanel());
            this.dlg.setTitle("\u9009\u62e9\u5e94\u7528\u6a21\u578b");
            this.dlg.setSize(400, 500);
        }
        EnumObj oldApp = (EnumObj)this.promptSelector.getValue();
        if (this.dlg.showDialog() && !(app = (EnumObj)this.lstAppModel.getSelectedValue()).equals(oldApp) && (oldApp == null || WindowUtil.msgboxYesNo((Component)this.dlg, (Object)("\u662f\u5426\u771f\u7684\u8981\u5c06\u5f15\u7528\u5e94\u7528\u6a21\u578b\u3010" + oldApp.getAlias() + "\u3011\u66f4\u6539\u4e3a\u3010" + app.getAlias() + "\u3011\uff1f\r\n\u6ce8\u610f\uff1a\u6a21\u578b\u7684\u4fee\u6539\u4f1a\u4e22\u5931\u62a5\u8868\u7684\u90e8\u5206\u8bbe\u8ba1\u4fe1\u606f\uff01"), (String)"\u7cfb\u7edf\u63d0\u793a"))) {
            this.promptSelector.setValue((Object)app);
            this.refreshTree(app);
            this.dlgReport.reloadAppModel(app.getName());
            this.dlgReport.clearLayout();
        }
    }

    private void refreshTree(EnumObj app) {
        String modelId = app.getName();
        this.dlgReport.reloadAppModel(modelId);
        KDTree treeForLayout = this.dlgReport.getTreeAppModelLayOut();
        KDTree treeForCalculate = this.dlgReport.getTreeForCalculate();
        treeForLayout.setRootVisible(true);
        treeForLayout.setShowsRootHandles(true);
        treeForLayout.setDragEnabled(true);
        treeForLayout.getSelectionModel().setSelectionMode(1);
        TreeModel tmLayout = null;
        TreeModel tmCalculate = null;
        try {
            tmLayout = this.facade.getAppmodelTreeInfoForReport(0, modelId);
            tmCalculate = this.facade.getCalMemberTree(0, modelId);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        treeForLayout.setModel(tmLayout);
        treeForCalculate.setModel(tmCalculate);
        try {
            this.dlgReport.loadSetDefined();
        }
        catch (BIModelRemoteException e1) {
            e1.printStackTrace();
        }
    }

    protected KDPanel getPanel() {
        return this.panel;
    }

    private void addControls() {
        TableLayout2 layout = new TableLayout2(2, 2);
        layout.setFixedHeight(0, 20);
        layout.setRatableHeight(1, 8);
        layout.setRowsSpacing(TableLayout2.ALL, 3);
        layout.setFixedWidth(0, 200);
        layout.setRatableWidth(1, 100);
        KDPanel pan = this.getPanel();
        pan.setLayout((LayoutManager)layout);
        pan.add((Component)new KDLabel("\u5907\u9009\u5e94\u7528\u6a21\u578b\uff1a"), (Object)TableLayout2.param((int)0, (int)0, (int)0, (int)1));
        pan.add((Component)new KDScrollPane((Component)this.lstAppModel), (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)1));
    }
}

