/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.general;

import com.kingdee.bos.bi.model.common.mm.customdim.GeneralDimProperty;
import com.kingdee.bos.bi.model.common.mm.general.GeneralDimensionNode;
import com.kingdee.bos.bi.model.common.mm.general.GeneralModel;
import com.kingdee.bos.bi.model.common.mm.general.GeneralUtil;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JComponent;

public class GeneralDimensionAttributeDialog
extends KDPanel
implements SimpleDialog.PanelOfSimpleDialog {
    private static final long serialVersionUID = 4619808037942746026L;
    private KDTextField txtNumber;
    private KDTextField txtName;
    private KDTextArea txaDescription;
    private KDTable tblCustomAttribute;
    private KDTree currentEditTree;
    private String currentNodeNumber;
    private List attributeList = null;
    private String dimNumber = null;

    public GeneralDimensionAttributeDialog(String dimNumber, List attributeList) {
        this.attributeList = attributeList;
        this.dimNumber = dimNumber;
        this.init();
    }

    private void init() {
        KDLabelContainer lbctnNumber = CtrlSwingUtilities.createLabelContainer((JComponent)this.getTxtNumber(), (String)"\u7f16\u7801", (int)120);
        KDLabelContainer lbctnName = CtrlSwingUtilities.createLabelContainer((JComponent)this.getTxtName(), (String)"\u540d\u79f0", (int)120);
        TableLayout2 tly = new TableLayout2(5, 1);
        tly.setRowsSpacing(TableLayout2.ALL, 5);
        tly.setFixedHeight(new int[]{0, 1, 3}, 21);
        tly.setFixedHeight(new int[]{4}, 40);
        tly.setRatableHeight(2, 100);
        this.setLayout((LayoutManager)tly);
        this.add((Component)lbctnNumber, TableLayout2.param((int)0, (int)0));
        this.add((Component)lbctnName, TableLayout2.param((int)1, (int)0));
        this.add(this.getTblCustomAttribute(), TableLayout2.param((int)2, (int)0));
        this.add((Component)new KDLabel("\u5907\u6ce8\uff1a"), TableLayout2.param((int)3, (int)0));
        this.add((Component)new KDScrollPane(this.getTxaDescription()), TableLayout2.param((int)4, (int)0));
    }

    public JComponent getTxtNumber() {
        if (this.txtNumber == null) {
            this.txtNumber = new KDTextField();
        }
        return this.txtNumber;
    }

    public JComponent getTxtName() {
        if (this.txtName == null) {
            this.txtName = new KDTextField();
        }
        return this.txtName;
    }

    public Component getTxaDescription() {
        if (this.txaDescription == null) {
            this.txaDescription = new KDTextArea();
        }
        return this.txaDescription;
    }

    public Component getTblCustomAttribute() {
        if (this.tblCustomAttribute == null) {
            this.tblCustomAttribute = new KDTable();
            this.setTblCustomAttribute();
        }
        return this.tblCustomAttribute;
    }

    private void setTblCustomAttribute() {
        String[] columnKeys = new String[]{"name", "type", "value"};
        Object[] headNames = new String[]{"\u5c5e\u6027\u540d", "\u5c5e\u6027\u7c7b\u578b", "\u5c5e\u6027\u503c"};
        KDTableHelper.initTable((KDTable)this.tblCustomAttribute, (String[])columnKeys, (Object[])headNames, (Object[][])null);
        this.tblCustomAttribute.setAutoResize(true);
        KDTableHelper.updateEnterWithTab((KDTable)this.tblCustomAttribute, (boolean)false);
        this.tblCustomAttribute.getSelectManager().setSelectMode(10);
        IRow row = null;
        GeneralDimProperty attr = null;
        int m = this.attributeList.size();
        for (int k = 0; k < m; ++k) {
            attr = (GeneralDimProperty)this.attributeList.get(k);
            row = this.tblCustomAttribute.addRow(k);
            row.getCell("name").setValue((Object)attr.getName());
            row.getCell("type").setValue((Object)attr.toShowType());
            if (!StringUtil.equalsIgnoreCase((String)"datetime", (String)attr.getType())) continue;
            KDDatePicker datePicker = new KDDatePicker();
            datePicker.setTimeEnabled(true);
            row.getCell("value").setEditor((ICellEditor)new KDTDefaultCellEditor(datePicker));
            StyleAttributes style = Styles.getSA((StyleAttributes)row.getCell("value").getStyleAttributes());
            style.setNumberFormat("yyyy-MM-dd HH:mm:ss.sss");
            row.getCell("value").setStyleAttributes(style);
        }
        this.tblCustomAttribute.getColumn("name").getStyleAttributes().setLocked(true);
        this.tblCustomAttribute.getColumn("type").getStyleAttributes().setLocked(true);
    }

    public void setEditable(boolean isEditable) {
        this.txtNumber.setEnabled(isEditable);
        this.txtName.setEnabled(isEditable);
        this.tblCustomAttribute.setEnabled(isEditable);
        this.txaDescription.setEnabled(isEditable);
    }

    public void loadModel(GeneralModel model) {
        if (model == null) {
            return;
        }
        this.txtNumber.setText(model.getNumber() == null ? "" : model.getNumber());
        this.txtName.setText(model.getName() == null ? "" : model.getName());
        this.txaDescription.setText(model.getMemo() == null ? "" : model.getMemo());
        List attributeList = model.getPropertyList();
        GeneralDimProperty attr = null;
        IRow row = null;
        int m = attributeList.size();
        for (int k = 0; k < m; ++k) {
            attr = (GeneralDimProperty)attributeList.get(k);
            row = this.tblCustomAttribute.getRow(k);
            if (StringUtil.equalsIgnoreCase((String)"datetime", (String)attr.getType())) {
                row.getCell("value").getEditor().setValue((Object)((Date)attr.getValue()));
                row.getCell("value").setValue(attr.getValue());
                continue;
            }
            row.getCell("value").setValue(attr.getValue());
            if (!(attr.getValue() instanceof Date)) continue;
            ICellEditor cellEdit = this.tblCustomAttribute.getCellEditor(k, 2);
            KDDatePicker datePicker = (KDDatePicker)cellEdit.getComponent();
            datePicker.setTimeEnabled(true);
            StyleAttributes style = Styles.getSA((StyleAttributes)row.getCell("value").getStyleAttributes());
            style.setNumberFormat("yyyy-MM-dd HH:mm:ss.sss");
            row.getCell("value").setStyleAttributes(style);
        }
    }

    public void getModel(GeneralModel model) {
        model.setNumber(this.txtNumber.getText().trim());
        model.setName(this.txtName.getText().trim());
        model.setMemo(this.txaDescription.getText().trim());
        List attributeList = model.getPropertyList();
        ICell cell = null;
        GeneralDimProperty attr = null;
        int m = attributeList.size();
        for (int k = 0; k < m; ++k) {
            attr = (GeneralDimProperty)attributeList.get(k);
            cell = this.tblCustomAttribute.getRow(k).getCell("value");
            if (StringUtil.equalsIgnoreCase((String)"datetime", (String)attr.getType())) {
                attr.setValue(cell.getEditor().getValue());
                continue;
            }
            attr.setValue(cell.getValue());
        }
    }

    public boolean verify() {
        GeneralModel model = new GeneralModel(this.dimNumber);
        model.setPropertyList(this.attributeList);
        this.getModel(model);
        String errInfo = GeneralDimensionAttributeDialog.checkModel(model);
        if (errInfo != null) {
            WindowUtil.msgboxInfo((Object)errInfo, (String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u5c5e\u6027", (Component)((Object)this));
            return false;
        }
        if (!StringUtil.equalsIgnoreCase((String)this.currentNodeNumber, (String)model.getNumber())) {
            Enumeration e = ((DefaultKingdeeTreeNode)this.currentEditTree.getModel().getRoot()).breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultKingdeeTreeNode ctrlNode = (DefaultKingdeeTreeNode)e.nextElement();
                Object moNode = ctrlNode.getUserObject();
                if (!(moNode instanceof GeneralDimensionNode)) continue;
                GeneralModel m = ((GeneralDimensionNode)moNode).getGeneralModel();
                if (!StringUtil.equalsIgnoreCase((String)model.getNumber(), (String)m.getNumber())) continue;
                WindowUtil.msgboxInfo((Object)("\u7f16\u7801 " + model.getNumber() + " \u5df2\u5b58\u5728\u3002"), (String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u5c5e\u6027", (Component)((Object)this));
                return false;
            }
        }
        List attributeList = model.getPropertyList();
        GeneralDimProperty attr = null;
        int m = attributeList.size();
        for (int k = 0; k < m; ++k) {
            attr = (GeneralDimProperty)attributeList.get(k);
            if (GeneralUtil.isValid(attr.getType(), attr.getValue())) continue;
            WindowUtil.msgboxInfo((Object)("\u7b2c " + (k + 1) + "\u884c\uff0c\u5c5e\u6027\u7c7b\u578b\u3010" + attr.toShowType() + "\u3011\u5c5e\u6027\u503c\u3010" + attr.getValue() + "\u3011\u4e0d\u5408\u6cd5\uff01"), (String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u5c5e\u6027", (Component)((Object)this));
            return false;
        }
        return true;
    }

    public void setEditing(KDTree editingTree, String editingNumber) {
        this.currentEditTree = editingTree;
        this.currentNodeNumber = editingNumber;
    }

    private static String checkModel(GeneralModel model) {
        if (StringUtil.isEmptyString((String)model.getNumber())) {
            return "\u672a\u8bbe\u7f6e\u7f16\u7801\u3002";
        }
        if (StringUtil.isEmptyString((String)model.getName())) {
            return "\u672a\u8bbe\u7f6e\u540d\u79f0\u3002";
        }
        if (!Pattern.matches("[^!]+", model.getNumber())) {
            return "\u7f16\u7801\u4e0d\u5141\u8bb8\u5305\u542b!\uff08\u611f\u53f9\u53f7\uff09\u3002";
        }
        if (model.getNumber().length() > 80) {
            return "\u7f16\u7801\u592a\u957f\uff0c\u4e0d\u80fd\u8d85\u8fc780\u4e2a\u5b57\u7b26\u3002";
        }
        if (model.getName().length() > 255) {
            return "\u540d\u79f0\u592a\u957f\uff0c\u4e0d\u80fd\u8d85\u8fc7255\u4e2a\u5b57\u7b26\u3002";
        }
        if (model.getMemo().length() > 2000) {
            return "\u5907\u6ce8\u592a\u957f\uff0c\u4e0d\u80fd\u8d85\u8fc72000\u4e2a\u5b57\u7b26\u3002";
        }
        return null;
    }
}

