/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.general.importscheme;

import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public abstract class AbstractImportWizardStep
implements IWizardStep {
    protected static final Logger log = CommonLogger.getLogger(AbstractImportWizardStep.class);
    protected IManagementFacade facade = null;
    protected WizardDialog.StepsManager stepsManager = null;
    protected Component owner = null;

    public AbstractImportWizardStep(IManagementFacade facade, Component owner) {
        this.facade = facade;
        this.owner = owner;
    }

    public JComponent getContent() {
        String prompt = this.getPromptText();
        if (prompt != null) {
            KDTextArea txa = new KDTextArea();
            txa.setEditable(false);
            txa.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            txa.setSelectAllOnFocus(false);
            txa.setText(prompt);
            TableLayout tly = TableLayout.splitRow((int)3);
            tly.rowStyle(0).setPriY(1);
            tly.rowStyle(1).setHeight(6);
            tly.rowStyle(2).setHeight(70);
            KDPanel pan = new KDPanel((LayoutManager)tly);
            pan.add((Component)this.getRealContent(), (Object)tly.cell(0));
            pan.add((Component)txa, (Object)tly.cell(2));
            return pan;
        }
        return this.getRealContent();
    }

    protected JComponent getRealContent() {
        return (JComponent)this.getPanMain();
    }

    protected abstract Component getPanMain();

    protected abstract String getPromptText();

    public void initStep(WizardDialog.StepsManager manager) {
        this.stepsManager = manager;
    }

    protected void changeTitle() {
        String oldTitle = this.stepsManager.getWizardDialog().getTitle();
        int gongIndex = oldTitle.lastIndexOf("\u5171");
        if (gongIndex > 0) {
            this.stepsManager.getWizardDialog().setTitle(oldTitle.substring(0, gongIndex) + "\u51714\u6b65");
        }
    }

    public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
        this.changeTitle();
        this.beforeIntoThisStep();
        this.loadModel();
        this.setNextAndFinishButtonEnable(false);
        this.afterIntoThisStep();
    }

    protected void beforeIntoThisStep() {
    }

    protected void afterIntoThisStep() {
    }

    public boolean isReturnable() {
        return true;
    }

    protected abstract void loadModel();

    public IWizardStep outThisStep(boolean isOppose) {
        if (!isOppose) {
            if (!this.checkBeforeInject()) {
                return this;
            }
            boolean success = this.injectModel();
            if (success) {
                return this.getNextStep();
            }
            return this;
        }
        return null;
    }

    protected AbstractImportWizardStep getNextStep() {
        return null;
    }

    protected abstract boolean injectModel();

    protected abstract boolean checkBeforeInject();

    protected void setNextAndFinishButtonEnable(boolean isEnd) {
        this.stepsManager.setNextStepEnabled(!isEnd);
        this.stepsManager.setFinishEnabled(isEnd);
    }

    protected void clearEditTag(boolean isOppose) {
    }

    public void destroy(boolean isFinished) {
    }

    public Component getOwner() {
        return this.owner;
    }

    public WizardDialog.StepsManager getStepsManager() {
        return this.stepsManager;
    }
}

