/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.schedule;

import com.kingdee.bos.bi.model.common.mm.ComboBoxObject;
import com.kingdee.bos.bi.model.common.mm.schedule.ScheduleModel;
import com.kingdee.bos.bi.model.ui.ProgressbarGlassPane;
import com.kingdee.bos.bi.model.ui.dialog.schedule.AbstractScheduleDialog;
import com.kingdee.bos.bi.model.ui.dialog.schedule.ManuallyExecutingDialog;
import com.kingdee.bos.bi.model.ui.dialog.schedule.logs.ScheduleLogDialog;
import com.kingdee.bos.bi.model.ui.exception.BIModelBizException;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.eas.base.job.QuartzParser;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;

public class ScheduleDialog
extends AbstractScheduleDialog {
    private static final long serialVersionUID = 8489395420184388445L;
    private Vector ComBoxModelIteams = null;
    private Vector ComBoxFailIteams = null;
    private List modelList = null;
    private ProgressbarGlassPane progressGlasspane;

    public ScheduleDialog() {
    }

    public ScheduleDialog(Dialog owner) {
        super(owner);
    }

    public ScheduleDialog(Frame owner) {
        super(owner);
    }

    @Override
    protected void todoInit() {
        super.todoInit();
    }

    @Override
    protected void todoAddControls(Container parent, Cell thisCell) {
        super.todoAddControls(parent, thisCell);
        this.initTblMain();
        this.initialUpdateStrategy();
    }

    private void initialUpdateStrategy() {
        if (this.modelList != null && this.modelList.size() > 0) {
            ScheduleModel m = (ScheduleModel)this.modelList.get(0);
            this.scheduleXML = m.getFQuartsExp();
            this.txtScheduleTime.setText(this.toScheduleTime(this.scheduleXML));
            int FPeriodCalcRule = -1;
            FPeriodCalcRule = m.getFPeriodCalcRule().equals("13") ? 2 : (m.getFPeriodCalcRule().equals("now") ? 1 : 0);
            this.rbtnGroup.setValue(FPeriodCalcRule);
        }
    }

    private void initTblMain() {
        if (this.modelList != null && this.modelList.size() > 0) {
            int n = this.modelList.size();
            block0: for (int r = 0; r < n; ++r) {
                ScheduleModel model = (ScheduleModel)this.modelList.get(r);
                IRow row_RX = this.tblMain.addRow(r);
                ICell cell_R0 = row_RX.getCell(0);
                KDComboBox comBo_R0 = new KDComboBox();
                Vector ComBoxRuleIteams = null;
                int m = this.ComBoxModelIteams.size();
                for (int i = 0; i < m; ++i) {
                    ComboBoxObject comBoxModel_Select = (ComboBoxObject)this.ComBoxModelIteams.get(i);
                    if (!comBoxModel_Select.getCode().equals(model.getFAMID())) continue;
                    comBo_R0.addItems(this.ComBoxModelIteams);
                    comBo_R0.setSelectedItem((Object)comBoxModel_Select);
                    cell_R0.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comBo_R0));
                    cell_R0.setValue((Object)comBoxModel_Select);
                    ComBoxRuleIteams = comBoxModel_Select.getIteams();
                    break;
                }
                comBo_R0.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        ScheduleDialog.this.action_CellChanged();
                    }
                });
                ICell cell_R1 = row_RX.getCell(1);
                KDComboBox comBo_R1 = new KDComboBox();
                if (ComBoxRuleIteams != null) {
                    int m2 = ComBoxRuleIteams.size();
                    for (int k = 0; k < m2; ++k) {
                        ComboBoxObject comBoxRule_Select = (ComboBoxObject)ComBoxRuleIteams.get(k);
                        if (!comBoxRule_Select.getCode().equals(model.getFDRSchemaID())) continue;
                        comBo_R1.addItems(ComBoxRuleIteams.toArray());
                        comBo_R1.setSelectedItem((Object)comBoxRule_Select);
                        cell_R1.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comBo_R1));
                        cell_R1.setValue((Object)comBoxRule_Select);
                        break;
                    }
                }
                ICell cell_R2 = row_RX.getCell(2);
                KDComboBox comBo_R2 = new KDComboBox();
                int m3 = this.ComBoxFailIteams.size();
                for (int j = 0; j < m3; ++j) {
                    ComboBoxObject comBoxFail_Select = (ComboBoxObject)this.ComBoxFailIteams.get(j);
                    if (!comBoxFail_Select.getCode().equals(model.getFFailStrategy())) continue;
                    comBo_R2.addItems(this.ComBoxFailIteams);
                    comBo_R2.setSelectedItem((Object)comBoxFail_Select);
                    cell_R2.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comBo_R2));
                    cell_R2.setValue((Object)comBoxFail_Select);
                    continue block0;
                }
            }
        }
    }

    @Override
    public void action_SetTime() {
        this.openProcessSchedulePlan();
    }

    private void openProcessSchedulePlan() {
        try {
            String prevscheduleXML = this.scheduleXML;
            if (prevscheduleXML == null || prevscheduleXML.length() < "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Scheduale xmlns=\"http://www.kingdee.com/2003/K-PDL1.0\" RetryTime=\"0\" Type=\"EVERYDAY\" BeginTime=\"1258446031557\" EndTime=\"1258446031557\" UseCalendar=\"false\" InstructionType=\"0\"></Scheduale>".length()) {
                prevscheduleXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Scheduale xmlns=\"http://www.kingdee.com/2003/K-PDL1.0\" RetryTime=\"0\" Type=\"EVERYDAY\" BeginTime=\"1258446031557\" EndTime=\"1258446031557\" UseCalendar=\"false\" InstructionType=\"0\"></Scheduale>";
            }
            this.scheduleXML = ProcessSchedulePlan.open((Object)((Object)this), (String)prevscheduleXML);
            if (this.scheduleXML != null && this.scheduleXML.length() > 0 && !this.scheduleXML.equals(prevscheduleXML)) {
                this.setIsScheduleChanged(true);
                this.txtScheduleTime.setText(this.toScheduleTime(this.scheduleXML));
            }
        }
        catch (LinkageError e) {
            WindowUtil.msgboxWarning((Object)"\u975eEAS\u73af\u5883\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u8c03\u5ea6\u65f6\u95f4\u5468\u671f\uff01", (String)"\u7cfb\u7edf\u63d0\u793a", (Component)((Object)this));
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private String toScheduleTime(String xml) {
        if (xml == null || xml.length() == 0 || xml.equals("null")) {
            return "";
        }
        ScheduleDef scheduleDef = null;
        QuartzParser quartzParser = null;
        String result = null;
        try {
            scheduleDef = KpdlParser.parseSchedule((String)xml);
            quartzParser = new QuartzParser(scheduleDef.getDefine());
            result = quartzParser.parse();
        }
        catch (WfKpdlParseException wfKpdlParseException) {
            // empty catch block
        }
        return result == null ? xml : result;
    }

    @Override
    protected void action_CellChanged() {
        if (this.currCol == 0 && this.tblMain != null && this.tblMain.getRow(this.currRow) != null && this.tblMain.getRow(this.currRow).getCell(0) != null && this.tblMain.getRow(this.currRow).getCell(0).getEditor() != null) {
            KDComboBox cb_col_one = (KDComboBox)this.tblMain.getRow(this.currRow).getCell(0).getEditor().getComponent();
            ComboBoxObject m_col_one = (ComboBoxObject)cb_col_one.getSelectedItem();
            if (m_col_one != null) {
                this.tblMain.getRow(this.currRow).getCell(1).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(m_col_one.getIteams())));
                this.tblMain.getRow(this.currRow).getCell(1).setValue(m_col_one.getIteams().get(0));
            }
            if (m_col_one != null) {
                this.tblMain.getRow(this.currRow).getCell(2).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(this.ComBoxFailIteams)));
                this.tblMain.getRow(this.currRow).getCell(2).setValue(this.ComBoxFailIteams.get(0));
            }
        }
    }

    @Override
    public void action_Add() {
        this.tblMain.addRow();
        KDComboBox comBo_0 = new KDComboBox();
        comBo_0.addItems(this.ComBoxModelIteams);
        this.tblMain.getCell(this.tblMain.getRowCount() - 1, 0).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comBo_0));
        comBo_0.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ScheduleDialog.this.action_CellChanged();
            }
        });
    }

    @Override
    public void action_Delete() {
        if (this.checkSelected()) {
            ArrayList selectBlocks = this.tblMain.getSelectManager().getBlocks();
            KDTSelectBlock selectBlock = null;
            int n = selectBlocks.size();
            for (int i = 0; i < n; ++i) {
                selectBlock = (KDTSelectBlock)selectBlocks.get(i);
                if (selectBlock.getTop() != selectBlock.getBottom()) {
                    WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55\u5220\u9664\uff01", (String)this.getTitle(), (Component)((Object)this));
                    return;
                }
                this.tblMain.removeRow(selectBlock.getTop());
            }
        }
    }

    @Override
    public void action_Up() {
        if (this.checkSelected()) {
            ArrayList selectBlocks = this.tblMain.getSelectManager().getBlocks();
            KDTSelectBlock selectBlock = null;
            int rowIndex = -1;
            IRow row = null;
            int n = selectBlocks.size();
            for (int i = 0; i < n; ++i) {
                selectBlock = (KDTSelectBlock)selectBlocks.get(i);
                if (selectBlock.getTop() != selectBlock.getBottom()) {
                    WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55\u79fb\u52a8\uff01", (String)this.getTitle(), (Component)((Object)this));
                    break;
                }
                if (this.tblMain.getRowCount() == rowIndex) {
                    return;
                }
                rowIndex = selectBlock.getTop();
                if (rowIndex == -1 || rowIndex == 0) {
                    return;
                }
                int targetRowIndex = rowIndex - 1;
                row = this.tblMain.removeRow(rowIndex);
                this.tblMain.addRow(targetRowIndex, row);
                this.tblMain.getSelectManager().setActiveRowIndex(targetRowIndex);
                this.tblMain.getSelectManager().select(targetRowIndex, 0);
            }
        }
    }

    @Override
    public void action_Down() {
        if (this.checkSelected()) {
            ArrayList selectBlocks = this.tblMain.getSelectManager().getBlocks();
            KDTSelectBlock selectBlock = null;
            int rowIndex = -1;
            IRow row = null;
            int n = selectBlocks.size();
            for (int i = 0; i < n; ++i) {
                selectBlock = (KDTSelectBlock)selectBlocks.get(i);
                if (selectBlock.getTop() != selectBlock.getBottom()) {
                    WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55\u79fb\u52a8\uff01", (String)this.getTitle(), (Component)((Object)this));
                    break;
                }
                if (this.tblMain.getRowCount() == rowIndex) {
                    return;
                }
                rowIndex = selectBlock.getTop();
                if (rowIndex == -1 || rowIndex == this.tblMain.getRowCount() - 1) {
                    return;
                }
                int targetRowIndex = rowIndex + 1;
                row = this.tblMain.removeRow(rowIndex);
                this.tblMain.addRow(targetRowIndex, row);
                this.tblMain.getSelectManager().setActiveRowIndex(targetRowIndex);
                this.tblMain.getSelectManager().select(targetRowIndex, 0);
            }
        }
    }

    private boolean checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        return true;
    }

    @Override
    public boolean action_CheckBeforeSave() {
        if (this.tblMain.getRowCount() == 0) {
            WindowUtil.msgboxInfo((Object)"\u81f3\u5c11\u8981\u6709\u4e00\u6761\u6570\u636e\u89c4\u5219\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (this.txtScheduleTime.getText() == null || this.txtScheduleTime.getText().trim().length() == 0) {
            WindowUtil.msgboxInfo((Object)"\u5fc5\u987b\u8bbe\u7f6e\u65f6\u95f4\u5468\u671f\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        for (int r = this.tblMain.getRowCount() - 1; r >= 0; --r) {
            IRow row = this.tblMain.getRow(r);
            for (int c = this.tblMain.getColumnCount() - 1; c >= 0; --c) {
                ICell cell = row.getCell(c);
                if (cell.getValue() != null) continue;
                WindowUtil.msgboxInfo((Object)"\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u4e0d\u80fd\u4fdd\u5b58\uff01", (String)this.getTitle(), (Component)((Object)this));
                return false;
            }
        }
        if (this.getDiscriptionTxt().length() > 2000) {
            WindowUtil.msgboxWarning((Object)"\u8bf4\u660e\u6587\u5b57\u7684\u6700\u5927\u957f\u5ea6\u4e3a2000\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        return true;
    }

    public Vector getComBoxModelIteams() {
        return this.ComBoxModelIteams;
    }

    public void setComBoxModelIteams(Vector comBoxIteams) {
        this.ComBoxModelIteams = comBoxIteams;
    }

    public List getModelList() {
        ArrayList<ScheduleModel> lst = new ArrayList<ScheduleModel>();
        ScheduleModel m = null;
        int n = this.tblMain.getRowCount();
        for (int r = 0; r < n; ++r) {
            m = new ScheduleModel();
            IRow row = this.tblMain.getRow(r);
            m.setFAMID(((ComboBoxObject)row.getCell("FAMID").getValue()).getCode());
            m.setFDRSchemaID(((ComboBoxObject)row.getCell("FDRSchemaID").getValue()).getCode());
            m.setFFailStrategy(((ComboBoxObject)row.getCell("FFailStrategy").getValue()).getCode());
            m.setFPeriodCalcRule(this.getPeriodCalcRule());
            m.setFQuartsExp(this.scheduleXML == null ? "" : this.scheduleXML);
            lst.add(m);
        }
        return lst;
    }

    public String getPeriodCalcRule() {
        String FPeriodCalcRule = null;
        switch (this.rbtnGroup.getValue()) {
            case 0: {
                FPeriodCalcRule = "last";
                break;
            }
            case 1: {
                FPeriodCalcRule = "now";
                break;
            }
            case 2: {
                FPeriodCalcRule = "13";
                break;
            }
        }
        return FPeriodCalcRule;
    }

    public void setModelList(List modelLst) {
        this.modelList = modelLst;
    }

    public Vector getComBoxFailIteams() {
        return this.ComBoxFailIteams;
    }

    public void setComBoxFailIteams(Vector comBoxFailIteams) {
        this.ComBoxFailIteams = comBoxFailIteams;
    }

    @Override
    public void action_Run() {
        ManuallyExecutingDialog runDlg = (ManuallyExecutingDialog)((Object)WindowUtil.createWindow(ManuallyExecutingDialog.class, (Component)((Object)this)));
        if (runDlg.showDialog()) {
            Date dateBegin = (Date)runDlg.datBegin.getValue();
            Date dateEnd = (Date)runDlg.datEnd.getValue();
            List dataRuleList = this.getRunDataList();
            if (this.facade != null && this.id != null && dateBegin != null && dateEnd != null) {
                if (dataRuleList != null && dataRuleList.size() > 0) {
                    this.runSchedule(dateBegin, dateEnd, dataRuleList);
                } else {
                    WindowUtil.msgboxInfo((Object)"\u6ca1\u6709\u6570\u636e\u89c4\u5219\uff0c\u4e0d\u80fd\u624b\u5de5\u6267\u884c\uff01", (String)this.getTitle(), (Component)((Object)this));
                }
            }
        }
    }

    public void runSchedule(final Date dateBegin, final Date dateEnd, final List dataRuleList) {
        this.setProgressPaneVisible(true);
        this.excuteLongTimeTask(new Runnable(){

            @Override
            public void run() {
                try {
                    ScheduleDialog.this.facade.runDataRules(ScheduleDialog.this.id, dataRuleList, dateBegin, dateEnd);
                }
                catch (BIModelRemoteException e) {
                    ScheduleDialog.this.setProgressPaneVisible(false);
                    WindowUtil.msgboxWarning((Object)("\u6267\u884c\u65f6\u51fa\u73b0\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage()), (String)ScheduleDialog.this.getTitle(), (Component)((Object)ScheduleDialog.this));
                    return;
                }
                catch (BIModelBizException e) {
                    ScheduleDialog.this.setProgressPaneVisible(false);
                    WindowUtil.msgboxError((Object)("\u6267\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage()), (String)ScheduleDialog.this.getTitle(), (Component)((Object)ScheduleDialog.this));
                    return;
                }
                ScheduleDialog.this.setProgressPaneVisible(false);
                WindowUtil.msgboxInfo((Object)"\u624b\u5de5\u6267\u884c\u5b8c\u6bd5\uff01", (String)ScheduleDialog.this.getTitle(), (Component)((Object)ScheduleDialog.this));
            }
        });
    }

    private void excuteLongTimeTask(Runnable runnable) {
        new Thread(runnable).start();
    }

    private void setProgressPaneVisible(boolean b) {
        if (this.progressGlasspane == null) {
            this.progressGlasspane = new ProgressbarGlassPane((Window)((Object)this));
        }
        this.progressGlasspane.display(b);
    }

    public List getRunDataList() {
        ArrayList lst = new ArrayList();
        HashMap<String, String> m = null;
        IRow row = null;
        for (int r = 0; r < this.tblMain.getRowCount(); ++r) {
            m = new HashMap<String, String>();
            row = this.tblMain.getRow(r);
            m.put("FailStrategy", ((ComboBoxObject)row.getCell("FFailStrategy").getValue()).getCode());
            m.put("PeriodCalcRule", this.getPeriodCalcRule());
            m.put("amid", ((ComboBoxObject)row.getCell("FAMID").getValue()).getCode());
            m.put("drschemaid", ((ComboBoxObject)row.getCell("FDRSchemaID").getValue()).getCode());
            lst.add(m);
        }
        return lst;
    }

    @Override
    public void action_Log() {
        ScheduleLogDialog logDlg = (ScheduleLogDialog)((Object)WindowUtil.createWindow(ScheduleLogDialog.class, (Component)((Object)this)));
        logDlg.setFacade(this.facade);
        logDlg.setScheduleId(this.id);
        if (logDlg.showDialog()) {
            // empty if block
        }
    }
}

