/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.util;

import com.kingdee.bos.util.BOSUuid;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtil {
    public static final String NULLSTRING = "";
    private static final String IS_LETTER_NUMBER_UNDERLINE = "^(?!_)(?!.*?_$)[a-zA-Z0-9_]+$";
    private static final String IS_NUMERIC = "\\d*";
    private static final String IS_LETTER_NUMBER_UNDERLINE_2 = "^[a-zA-Z]\\w*$";
    private static final String IS_CHINESE_CHARACTER_LETTER_NUMBER_UNDERLINE = "^(?!_)(?!.*?_$)[a-zA-Z0-9_\u4e00-\u9fa5]+$";
    private static final String IS_SIGNLESS_INTEGER = "^[1-9]\\d*$";
    private static final String IS_DECIMAL = "^[+\\-]?\\d+(.\\d+)?$";
    private static final String IS_INTEGER = "^-?[1-9]\\d*$";

    public static String getNullString() {
        return NULLSTRING;
    }

    public static Map splitFormula(String fullFormula) {
        int current = 0;
        boolean y2Start = false;
        boolean yStart = false;
        int iVarStart = 0;
        HashMap map = new HashMap();
        int p = 0;
        block5: while (current < fullFormula.length()) {
            char t;
            char c = fullFormula.charAt(current);
            if (current > 0 && (t = fullFormula.charAt(current - 1)) != ' ') {
                p = t;
            }
            switch (c) {
                case '\"': {
                    y2Start = !y2Start;
                    ++current;
                    continue block5;
                }
                case '\'': {
                    yStart = !yStart;
                    ++current;
                    continue block5;
                }
                case '*': 
                case '+': 
                case '-': 
                case '/': {
                    ++current;
                    if (y2Start || yStart || p == 40 || p == 44 || p == 0) continue block5;
                    StringUtil.addVarToList(fullFormula, iVarStart, current, map);
                    iVarStart = current;
                    continue block5;
                }
            }
            ++current;
        }
        StringUtil.addVarToList(fullFormula, iVarStart, current + 1, map);
        return map;
    }

    private static void addVarToList(String str, int start, int end, Map map) {
        String var = str.substring(start, end - 1);
        var = var.trim();
        while (var.startsWith("(")) {
            var = var.substring(1);
        }
        if ((var = var.trim()).length() > 0 && Character.isLetter(var.charAt(0)) && var.indexOf("(") != -1) {
            while (var.charAt(var.length() - 2) == ')') {
                var = var.substring(0, var.length() - 1);
            }
            int pos = str.indexOf(var, start);
            map.put(new Integer(pos), var);
        }
    }

    public static String replaceFuncParam(String function, int index, String newValue) {
        Matcher m = Pattern.compile("[\\(,]?(\"([^\"]*)\"|([^,\"()]+))[\\),]").matcher(function);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int nStart = 0;
        while (m.find()) {
            if (i++ == index) {
                sb.append(function.substring(nStart, m.start()));
                String oldValue = NULLSTRING;
                if (index == 0) {
                    sb.append(function.substring(m.start(), m.start() + 1));
                    oldValue = function.substring(m.start() + 1, m.end() - 1);
                } else {
                    oldValue = function.substring(m.start(), m.end() - 1);
                }
                if (oldValue.equals("\"\"") || oldValue.equals("''")) {
                    sb.append(newValue);
                } else {
                    sb.append(oldValue);
                }
                sb.append(function.substring(m.end() - 1, function.length()));
                break;
            }
            sb.append(function.substring(nStart, m.end()));
            nStart = m.end();
        }
        return sb.toString();
    }

    public static String getUUID() {
        return BOSUuid.create((String)"ABCDEF00").toString();
    }

    public static boolean isLetterNumberOrUnderline(String str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        return str.trim().matches(IS_LETTER_NUMBER_UNDERLINE);
    }

    public static boolean isNumeric(String str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        return str.trim().matches(IS_NUMERIC);
    }

    public static boolean isLetterNumberOrUnderline2(String str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        return str.trim().matches(IS_LETTER_NUMBER_UNDERLINE_2);
    }

    public static boolean isChineseCharacterLetterNumberOrUnderline(String str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        return str.trim().matches(IS_CHINESE_CHARACTER_LETTER_NUMBER_UNDERLINE);
    }

    public static boolean isEmpty(String str) {
        return com.kingdee.bos.ctrl.common.util.StringUtil.isEmptyString((String)str);
    }

    public static boolean isSignlessInteger(String str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        return str.trim().matches(IS_SIGNLESS_INTEGER);
    }

    public static boolean isDecimal(String str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        return str.trim().matches(IS_DECIMAL);
    }

    public static boolean isInteger(String str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        return str.trim().matches(IS_INTEGER);
    }

    public static boolean equals(String str, String str2) {
        return com.kingdee.bos.ctrl.common.util.StringUtil.equals((String)str, (String)str2);
    }

    public static boolean equalsIgnoreCase(String str, String str2) {
        if (null == str) {
            return null == str2;
        }
        return str.equalsIgnoreCase(str2);
    }

    public static String replaceBlank(String str) {
        Matcher m = Pattern.compile("\t|\r|\n").matcher(str);
        return m.replaceAll(" ");
    }

    public static String getViewSQL(String innerSQL, boolean isTop) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ").append(isTop ? "TOP 1" : NULLSTRING).append(" * FROM ( ");
        sb.append(innerSQL.toUpperCase()).append(" ) Z ");
        return StringUtil.deleteOrderGroup(StringUtil.replaceBlank(sb.toString()));
    }

    public static String deleteOrderGroup(String str) {
        StringBuffer sb = new StringBuffer(str.toUpperCase());
        if (sb.lastIndexOf(" GROUP ") > 0) {
            sb.delete(sb.lastIndexOf(" GROUP ") + 1, sb.lastIndexOf(") Z "));
        }
        if (sb.lastIndexOf(" ORDER ") > 0) {
            sb.delete(sb.lastIndexOf(" ORDER ") + 1, sb.lastIndexOf(") Z "));
        }
        return sb.toString();
    }

    public static boolean toBoolean(String str) {
        return StringUtil.equalsIgnoreCase(str, "true");
    }

    public static String replaceSQLParam(String str) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        if (str.indexOf(39) < 0) {
            return str;
        }
        return str.replaceAll("'", "''");
    }

    public static void main(String[] args) {
        System.out.println(StringUtil.isChineseCharacterLetterNumberOrUnderline("u_i"));
    }
}

