/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;

public class SimpleTreeNode
implements Serializable {
    private List childList = null;
    private Object value;

    public SimpleTreeNode() {
        this(null, 0);
    }

    public SimpleTreeNode(Object value, int initSize) {
        this.value = value;
        this.childList = new ArrayList(initSize);
    }

    public static SimpleTreeNode parseFrom(TreeModel tm) {
        return SimpleTreeNode.convert((DefaultMutableTreeNode)tm.getRoot());
    }

    public static SimpleTreeNode convert(DefaultMutableTreeNode node) {
        int n = node.getChildCount();
        SimpleTreeNode tn = new SimpleTreeNode(node.getUserObject(), n);
        for (int i = 0; i < n; ++i) {
            tn.addChild(SimpleTreeNode.convert((DefaultMutableTreeNode)node.getChildAt(i)));
        }
        return tn;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void addChild(SimpleTreeNode child) {
        this.childList.add(child);
    }

    public void removeChild(SimpleTreeNode child) {
        this.childList.remove(child);
    }

    public int getChildCount() {
        return this.childList.size();
    }

    public Iterator childIterator() {
        return this.childList.iterator();
    }

    public SimpleTreeNode getChildAt(int i) {
        return (SimpleTreeNode)this.childList.get(i);
    }

    public List dumpNodeTreeValueList() {
        return this._dumpNodeTreeValueList(this);
    }

    private List _dumpNodeTreeValueList(SimpleTreeNode root) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(root.getValue());
        int n = root.getChildCount();
        for (int i = 0; i < n; ++i) {
            list.addAll(this._dumpNodeTreeValueList(root.getChildAt(i)));
        }
        return list;
    }

    public Iterator breadthFirstIterator() {
        return new BreadthFirstIterator(this);
    }

    final class BreadthFirstIterator
    implements Iterator {
        protected Queue queue;

        public BreadthFirstIterator(SimpleTreeNode rootNode) {
            ArrayList<SimpleTreeNode> arr = new ArrayList<SimpleTreeNode>(1);
            arr.add(rootNode);
            this.queue = new Queue();
            this.queue.enqueue(arr.iterator());
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty() && ((Iterator)this.queue.firstObject()).hasNext();
        }

        public Object next() {
            Iterator iter = (Iterator)this.queue.firstObject();
            SimpleTreeNode node = (SimpleTreeNode)iter.next();
            Iterator children = node.childIterator();
            if (!iter.hasNext()) {
                this.queue.dequeue();
            }
            if (children.hasNext()) {
                this.queue.enqueue(children);
            }
            return node;
        }

        @Override
        public void remove() {
        }

        final class Queue {
            QNode head;
            QNode tail;

            Queue() {
            }

            public void enqueue(Object anObject) {
                if (this.head == null) {
                    this.head = this.tail = new QNode(anObject, null);
                } else {
                    this.tail = this.tail.next = new QNode(anObject, null);
                }
            }

            public Object dequeue() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                Object retval = this.head.object;
                QNode oldHead = this.head;
                this.head = this.head.next;
                if (this.head == null) {
                    this.tail = null;
                } else {
                    oldHead.next = null;
                }
                return retval;
            }

            public Object firstObject() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                return this.head.object;
            }

            public boolean isEmpty() {
                return this.head == null;
            }

            final class QNode {
                public Object object;
                public QNode next;

                public QNode(Object object, QNode next) {
                    this.object = object;
                    this.next = next;
                }
            }
        }
    }
}

