/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.bireport.bimanager.BIProjectSchemeInfo;
import com.kingdee.eas.framework.bireport.bimanager.BillStatusEnum;
import com.kingdee.eas.framework.bireport.bimanager.GetCurProjectFacadeFactory;
import com.kingdee.eas.framework.bireport.bimanager.IGetCurProjectFacade;
import com.kingdee.eas.framework.bireport.bimanager.basedata.BIDataBaseFactory;
import com.kingdee.eas.framework.bireport.bimanager.basedata.BIDataBaseInfo;
import com.kingdee.eas.framework.bireport.bimanager.basedata.client.AbstractBITreeBaseListUI;
import com.kingdee.eas.framework.bireport.bimanager.util.BiManagerUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.framework.bireport.bimanager.util.UIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BITreeBaseListUI
extends AbstractBITreeBaseListUI {
    private static final Logger logger = CoreUIObject.getLogger(BITreeBaseListUI.class);
    BIProjectSchemeInfo BIProjectSchemeInfo;

    public BITreeBaseListUI() throws Exception {
        IGetCurProjectFacade iGetCurProjectFacade = GetCurProjectFacadeFactory.getRemoteInstance();
        this.BIProjectSchemeInfo = iGetCurProjectFacade.getBIProjectSchemeByUserID(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.setButtonDefaultStyl(this.btnAudit);
        this.setButtonDefaultStyl(this.btnUnAudit);
        super.lockAction();
        ItemAction[] itemActions = new ItemAction[]{this.actionImportData, this.actionExportData};
        BiManagerUtil.setActionsEnabledStatus(itemActions, false);
        itemActions = new ItemAction[]{this.actionAddNew, this.actionView, this.actionEdit, this.actionRemove, this.actionRefresh, this.actionQuery, this.actionLocate};
        BiManagerUtil.setActionsEnabledStatus(itemActions, true);
        BiManagerUtil.setVisibleToolBarStatus(this.toolBar);
        BiManagerUtil.setVisibleMenuBarStatus(this.menuBar);
        com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil.setSelectedRow((KDTable)this.tblMain, (int)0);
    }

    protected String getGroupEditUIName() {
        return null;
    }

    protected String getQueryFieldName() {
        return null;
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.tblMain.getColumn("isUsed") != null) {
            if (!UIHelper.isAllFalse(this.tblMain, "isUsed")) {
                MsgBox.showInfo((String)Constant.isUsedCanNotRemove);
                SysUtil.abort();
            } else {
                super.actionRemove_actionPerformed(e);
            }
        } else {
            super.actionRemove_actionPerformed(e);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        Boolean isUsed;
        IRow row = com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        if ((isUsed = (Boolean)row.getCell("isUsed").getValue()) != null && isUsed.booleanValue()) {
            MsgBox.showInfo((String)Constant.isUsedCanNotModify);
            SysUtil.abort();
        } else {
            super.actionEdit_actionPerformed(e);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        if (this.confirmDialog(cancelMsg)) {
            String[] selectIDs = this.getSelectIDs();
            BIDataBaseFactory.getRemoteInstance().setEnable(selectIDs, false, this.getBizType().toString());
            this.btnCancelCancel.setEnabled(true);
            this.btnCancel.setEnabled(false);
        }
        this.refresh(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            String[] selectIDs = this.getSelectIDs();
            BIDataBaseFactory.getRemoteInstance().setEnable(selectIDs, true, this.getBizType().toString());
            this.btnCancelCancel.setEnabled(false);
            this.btnCancel.setEnabled(true);
            this.refresh(e);
        }
    }

    private String[] getSelectIDs() {
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectedRows == null || selectedRows.length == 0) {
            return null;
        }
        String[] ids = new String[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            ids[i] = this.tblMain.getRow(selectedRows[i]).getCell("id").getValue().toString();
        }
        return ids;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        IRow row = com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            return;
        }
        BIDataBaseInfo info = this.getSelectBIBaseInfo();
        if (info.isIsUsed()) {
            this.btnCancelCancel.setEnabled(false);
            this.btnCancel.setEnabled(true);
        } else {
            this.btnCancelCancel.setEnabled(true);
            this.btnCancel.setEnabled(false);
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        BIDataBaseInfo info = this.getSelectBIBaseInfo();
        info.setBillStatus(BillStatusEnum.Audited);
        this.getBizInterface().update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        this.refresh(e);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        BIDataBaseInfo info = this.getSelectBIBaseInfo();
        info.setBillStatus(BillStatusEnum.Submit);
        this.getBizInterface().update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        this.refresh(e);
    }

    protected BIDataBaseInfo getSelectBIBaseInfo() throws Exception {
        String id;
        this.checkSelected();
        IRow row = com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        if ((id = (String)row.getCell("id").getValue()) == null) {
            MsgBox.showInfo((String)Constant.IdIsNoll);
            SysUtil.abort();
        }
        BIDataBaseInfo info = (BIDataBaseInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(id));
        return info;
    }

    public void refreshListForF7() {
        try {
            if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo) {
                TreeBaseInfo sourceTreeNode = (TreeBaseInfo)this.getSelectedTreeNode().getUserObject();
                if (!this.getTreeInterface().exists((IObjectPK)new ObjectUuidPK(sourceTreeNode.getId()))) {
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
            }
            this.setLocatePre(false);
            this.buildTreeFilter();
            this.execQuery();
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
            this.setSelectFirstRow(this.tblMain);
            this.setLocatePre(true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        if (filter == null) {
            filter = new FilterInfo();
        }
        if (this.BIProjectSchemeInfo == null || this.BIProjectSchemeInfo.getId() == null) {
            MsgBox.showWarning((String)Constant.HasNotProjectScheme);
            SysUtil.abort();
        }
        filter.getFilterItems().add(new FilterItemInfo("BIProjectScheme.id", (Object)this.BIProjectSchemeInfo.getId().toString()));
        Object object = this.getUIContext().get("filterForF7");
        if (object instanceof FilterInfo) {
            try {
                filter.mergeFilter((FilterInfo)object, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return filter;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (this.BIProjectSchemeInfo == null || this.BIProjectSchemeInfo.getId() == null) {
            MsgBox.showWarning((String)Constant.HasNotProjectScheme);
            SysUtil.abort();
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo filter = super.getDefaultFilterForTree();
        if (filter == null) {
            filter = new FilterInfo();
        }
        if (this.BIProjectSchemeInfo == null || this.BIProjectSchemeInfo.getId() == null) {
            MsgBox.showWarning((String)Constant.HasNotProjectScheme);
            SysUtil.abort();
        }
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("BIProjectScheme.id", (Object)this.BIProjectSchemeInfo.getId().toString()));
        try {
            filter.mergeFilter(f, "AND");
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return filter;
    }
}

