/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableIndexFactory;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableIndexInfo;
import com.kingdee.eas.framework.bireport.bimanager.basedata.client.AbstractTableIndexListUI;
import com.kingdee.eas.framework.bireport.bimanager.basedata.client.TableViewUI;
import com.kingdee.eas.framework.bireport.bimanager.util.BiManagerUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.framework.bireport.bimanager.util.DBConnectionMap;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class TableIndexListUI
extends AbstractTableIndexListUI {
    private static final Logger logger = CoreUIObject.getLogger(TableIndexListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.tblMain.getSelectManager().setSelectMode(1);
    }

    private void initUI() throws Exception {
        super.lockAction();
        ItemAction[] itemActions = new ItemAction[]{this.actionImportData, this.actionExportData};
        BiManagerUtil.setActionsEnabledStatus(itemActions, false);
        itemActions = new ItemAction[]{this.actionRefresh, this.actionLocate, this.actionViewStruct, this.actionViewData};
        BiManagerUtil.setActionsEnabledStatus(itemActions, true);
        BiManagerUtil.setVisibleToolBarStatus(this.toolBar);
        BiManagerUtil.setVisibleMenuBarStatus(this.menuBar);
        this.tblMain.getColumn("entityName").setWidth(150);
        this.tblMain.getColumn("tableType").setWidth(150);
        this.tblMain.getColumn("dataCenter").setWidth(150);
        this.tblMain.getColumn("tableName").setWidth(250);
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                String sql;
                IRowSet rs;
                String tableName;
                if (rowSet.getString("dataCenterID") != null) {
                    rowSet.updateString("dataCenter", DBConnectionMap.getInstance(null).get(rowSet.getString("dataCenterID")).toString());
                }
                if (rowSet.getString("quoteID") == null) continue;
                String uuid = rowSet.getString("quoteID");
                BOSObjectType bosType = null;
                try {
                    bosType = BOSUuid.read((String)uuid).getType();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (bosType == null) continue;
                EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bosType);
                if (entityInfo != null) {
                    rowSet.updateString("entity", entityInfo.getAlias());
                }
                if ((tableName = entityInfo.getTable().getName()) == null || !(rs = SQLExecutorFactory.getRemoteInstance((String)(sql = "select fnumber,fname_l2 from " + tableName + " where FID='" + uuid + "'")).executeSQL()).next()) continue;
                rowSet.updateString("entityNumber", rs.getString(1));
                rowSet.updateString("entityName", rs.getString(2));
            }
            rowSet.beforeFirst();
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionViewStruct_actionPerformed(ActionEvent e) throws Exception {
        String id;
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        if ((id = (String)row.getCell("id").getValue()) == null) {
            MsgBox.showInfo((String)Constant.IdIsNoll);
            SysUtil.abort();
        }
        String tableName = (String)row.getCell("tableName").getValue();
        if (id == null) {
            tableName = "";
        }
        RptRowSet rs = TableIndexFactory.getRemoteInstance().viewStruct(id);
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.putAll(this.getUIContext());
        uiCtx.put((Object)"title", (Object)(Constant.ViewTableStruct + "   " + tableName));
        uiCtx.put((Object)"rs", (Object)rs);
        uiCtx.put((Object)"isStruct", (Object)new Boolean(true));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TableViewUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionViewData_actionPerformed(ActionEvent e) throws Exception {
        String id;
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        if ((id = (String)row.getCell("id").getValue()) == null) {
            MsgBox.showInfo((String)Constant.IdIsNoll);
            SysUtil.abort();
        }
        String tableName = (String)row.getCell("tableName").getValue();
        if (id == null) {
            tableName = "";
        }
        RptRowSet rs = TableIndexFactory.getRemoteInstance().viewData(id);
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.putAll(this.getUIContext());
        uiCtx.put((Object)"title", (Object)(Constant.ViewData + "   " + tableName));
        uiCtx.put((Object)"rs", (Object)rs);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TableViewUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return TableIndexFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        TableIndexInfo objectValue = new TableIndexInfo();
        return objectValue;
    }

    protected String getEditUIName() {
        return null;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"entity", "entityNumber", "entityName", "tableType"};
        return locateNames;
    }
}

