/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.bireport.bimanager.BIProjectSchemeFactory;
import com.kingdee.eas.framework.bireport.bimanager.BIProjectSchemeInfo;
import com.kingdee.eas.framework.bireport.bimanager.BIProjectSchemeManagementFactory;
import com.kingdee.eas.framework.bireport.bimanager.BIProjectSchemeManagementInfo;
import com.kingdee.eas.framework.bireport.bimanager.GetCurProjectFacadeFactory;
import com.kingdee.eas.framework.bireport.bimanager.IBIProjectSchemeManagement;
import com.kingdee.eas.framework.bireport.bimanager.IGetCurProjectFacade;
import com.kingdee.eas.framework.bireport.bimanager.client.AbstractAssignUserGroupUI;
import com.kingdee.eas.framework.bireport.bimanager.sc.UserGroupCollection;
import com.kingdee.eas.framework.bireport.bimanager.sc.UserGroupFactory;
import com.kingdee.eas.framework.bireport.bimanager.sc.UserGroupInfo;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class AssignUserGroupUI
extends AbstractAssignUserGroupUI {
    private static final Logger logger = CoreUIObject.getLogger(AssignUserGroupUI.class);
    String ProjectSchemeId = null;
    IBIProjectSchemeManagement mng = BIProjectSchemeManagementFactory.getRemoteInstance();

    public void onLoad() throws Exception {
        this.kDTable1.checkParsed();
        super.onLoad();
        this.ProjectSchemeId = this.getUIContext().get("ID").toString();
        this.setData();
    }

    @Override
    protected void btnCansel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        int rowSize = this.kDTable1.getRowCount();
        for (int i = 0; i < rowSize; ++i) {
            IRow row = this.kDTable1.getRow(i);
            String ugID = row.getCell("id").getValue().toString();
            if (row.getCell("isCurProScheme").getValue().equals(Boolean.TRUE)) {
                this.saveData(ugID, this.ProjectSchemeId);
                continue;
            }
            IGetCurProjectFacade gcpf = GetCurProjectFacadeFactory.getRemoteInstance();
            BIProjectSchemeInfo info = gcpf.getBIProjectSchemeByUserGroupID(ugID);
            if (info == null || !info.getId().toString().equals(this.ProjectSchemeId)) continue;
            FilterInfo f = new FilterInfo();
            f.getFilterItems().add(new FilterItemInfo("userGroup.id", (Object)ugID));
            this.mng.delete(f);
        }
        MsgBox.showInfo((String)Constant.SetUserGroup);
        this.disposeUIWindow();
    }

    private void saveData(String userGroupID, String id) throws BOSException, EASBizException {
        BIProjectSchemeManagementInfo BIProjectSchemeManagementInfo2 = new BIProjectSchemeManagementInfo();
        UserGroupInfo ugInfo = new UserGroupInfo();
        ugInfo.setId(BOSUuid.read((String)userGroupID));
        BIProjectSchemeManagementInfo2.setUserGroup(ugInfo);
        BIProjectSchemeInfo newBIProSchemeInfo = new BIProjectSchemeInfo();
        newBIProSchemeInfo.setId(BOSUuid.read((String)id));
        BIProjectSchemeManagementInfo2.setBIProjectScheme(newBIProSchemeInfo);
        String MngId = this.mng.getSchemeMngIDByUserGroupID(userGroupID);
        if (MngId == null) {
            this.mng.addnew(BIProjectSchemeManagementInfo2);
        } else {
            BOSUuid pk = BOSUuid.read((String)MngId);
            BIProjectSchemeManagementInfo2.setId(pk);
            this.mng.save((CoreBaseInfo)BIProjectSchemeManagementInfo2);
        }
    }

    private void setData() throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("name");
        view.getSelector().add("number");
        view.getSelector().add("description");
        view.getSelector().add("company.name");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE));
        view.setFilter(filter);
        UserGroupCollection ugCollection = UserGroupFactory.getRemoteInstance().getUserGroupCollection(view);
        if (ugCollection != null && ugCollection.size() > 0) {
            UserGroupInfo ugInfo = new UserGroupInfo();
            block0: for (int i = 0; i < ugCollection.size(); ++i) {
                IRow row = this.kDTable1.addRow();
                ugInfo = ugCollection.get(i);
                row.getCell("number").setValue((Object)ugInfo.getNumber());
                row.getCell("name").setValue((Object)ugInfo.getName());
                row.getCell("description").setValue((Object)ugInfo.getDescription());
                row.getCell("id").setValue((Object)ugInfo.getId().toString());
                row.getCell("isCurProScheme").setValue((Object)Boolean.FALSE);
                UserGroupCollection ugColl = (UserGroupCollection)BIProjectSchemeFactory.getRemoteInstance().getUserGroupsbyBIProSchemeID(this.ProjectSchemeId);
                if (ugColl == null || ugColl.size() <= 0) continue;
                for (int j = 0; j < ugColl.size(); ++j) {
                    if (!row.getCell("id").getValue().toString().equals(ugColl.get(j).getId().toString())) continue;
                    row.getCell("isCurProScheme").setValue((Object)Boolean.TRUE);
                    continue block0;
                }
            }
        }
    }
}

