/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.client;

import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.BIProjectSchemeFactory;
import com.kingdee.eas.framework.bireport.bimanager.BIProjectSchemeInfo;
import com.kingdee.eas.framework.bireport.bimanager.BIProjectSchemeTreeInfo;
import com.kingdee.eas.framework.bireport.bimanager.client.AbstractBIProjectSchemeEditUI;
import com.kingdee.eas.framework.bireport.bimanager.client.DBCenterSelector;
import com.kingdee.eas.framework.bireport.bimanager.util.BiManagerUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.DBConnectionMap;
import com.kingdee.eas.framework.bireport.bimanager.util.client.BIClientVerifyHelper;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BIProjectSchemeEditUI
extends AbstractBIProjectSchemeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BIProjectSchemeEditUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        UIContext uiMap = new UIContext((Object)this);
        this.prmtODS.setSelector((KDPromptSelector)new DBCenterSelector(uiMap));
        this.prmtDW.setSelector((KDPromptSelector)new DBCenterSelector(uiMap));
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnSubmit.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.btnEdit.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.txtNumber.requestFocus();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BIProjectSchemeFactory.getRemoteInstance();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.editData.put("treeid", (BIProjectSchemeTreeInfo)this.getUIContext().get("ParentNode"));
        }
    }

    @Override
    protected IObjectValue createNewData() {
        BIProjectSchemeInfo objectValue = new BIProjectSchemeInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.btnSubmit.setEnabled(true);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.btnSubmit.setEnabled(true);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        BIClientVerifyHelper.verifyRequire((CoreUIObject)this);
        BIClientVerifyHelper.verifyEmpty((CoreUIObject)this, this.prmtODS);
        BIClientVerifyHelper.verifyEmpty((CoreUIObject)this, this.prmtDW);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        Object value = this.prmtODS.getValue();
        if (value instanceof DBCenterModel) {
            this.editData.setODS(((DBCenterModel)value).getDbCenterId());
        } else {
            this.editData.setODS(null);
        }
        value = this.prmtDW.getValue();
        if (value instanceof DBCenterModel) {
            this.editData.setDW(((DBCenterModel)value).getDbCenterId());
        } else {
            this.editData.setDW(null);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            DBCenterModel odsValue = DBConnectionMap.getInstance(null).get(this.editData.getODS());
            this.prmtODS.setValue((Object)odsValue);
            DBCenterModel dwValue = DBConnectionMap.getInstance(null).get(this.editData.getDW());
            this.prmtDW.setValue((Object)dwValue);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initUI() {
        super.lockAction();
        ItemAction[] itemActions = new ItemAction[]{this.actionAddNew, this.actionEdit, this.actionRemove, this.actionSubmit};
        BiManagerUtil.setActionsEnabledStatus(itemActions, true);
        BiManagerUtil.setVisibleToolBarStatus(this.toolBar);
        BiManagerUtil.setVisibleMenuBarStatus(this.menuBar);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("ODS"));
        sic.add(new SelectorItemInfo("DW"));
        return sic;
    }
}

