/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.da.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.FieldTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.TableTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.basedata.ITableIndex;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableIndexFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.BaseDataAcquisitionTempletFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.BaseDataAcquisitionTempletInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.client.AbstractBaseDataTreeViewUI;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataModelEntryCollection;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataModelEntryInfo;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BaseDataTreeViewUI
extends AbstractBaseDataTreeViewUI {
    private static final Logger logger = CoreUIObject.getLogger(BaseDataTreeViewUI.class);
    private HashMap uiMap = new HashMap();
    private String searchDataSql;
    private DefaultKingdeeTreeNode rootNode;
    private HashMap nodeTreeMap;
    private String selectedNodeId;
    private HashMap oldData;
    private String baseDataTableName;
    private BaseDataAcquisitionTempletInfo baseDataTempletInfo;
    private String baseDataId;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.initTree();
    }

    private void init() throws BOSException, EASBizException {
        String company = this.getUIContext().get("company.name").toString();
        String baseDataTempletId = this.getUIContext().get("baseDataTemplet.id").toString();
        String baseDataTempletName = this.getUIContext().get("baseDataTemplet.name").toString();
        this.txtCompany.setText(company);
        this.txtTemplet.setText(baseDataTempletName);
        this.baseDataId = this.getUIContext().get(Constant.ID).toString();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("masterData.name");
        selector.add("masterData.MasterDataModel.name");
        selector.add("masterData.baseDataTableName");
        selector.add("masterData.MasterDataModel.*");
        selector.add("masterData.MasterDataModel.Entry.*");
        this.baseDataTempletInfo = BaseDataAcquisitionTempletFactory.getRemoteInstance().getBaseDataAcquisitionTempletInfo((IObjectPK)new ObjectUuidPK(this.getUIContext().get("baseDataTemplet.id").toString()), selector);
        Boolean isRemark = (Boolean)this.getUIContext().get("isRemark");
        if (isRemark != null && isRemark.booleanValue()) {
            this.baseDataTableName = (String)this.getUIContext().get("tableName");
        } else {
            ITableIndex iTableIndex = TableIndexFactory.getRemoteInstance();
            String masterDataId = this.baseDataTempletInfo.getMasterData().getId().toString();
            this.baseDataTableName = iTableIndex.getTableNameById(masterDataId, TableTypeEnum.BaseDataTable);
        }
        this.txtMasterDataModel.setText(this.baseDataTempletInfo.getMasterData().getMasterDataModel().getName());
        this.treeMain.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                BaseDataTreeViewUI.this.showInfo();
            }
        });
    }

    private String getSearchDataSql() throws Exception {
        StringBuffer sb = new StringBuffer("select ");
        MasterDataModelEntryCollection col = this.baseDataTempletInfo.getMasterData().getMasterDataModel().getEntry();
        if (col == null || col.size() <= 0) {
            throw new BOSException(Constant.ModelNotCompleted);
        }
        MasterDataModelEntryInfo entry = null;
        String fieldName = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            entry = col.get(i);
            fieldName = entry.getAttribute();
            sb.append("F").append(fieldName).append(",");
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        sb.append(" from ").append(this.baseDataTableName).append(" where F").append(Constant.BaseDataID).append(" = '").append(this.baseDataId).append("' order by F").append(Constant.Number);
        return sb.toString();
    }

    private void addNode(HashMap objMap, HashMap nodeMap, DefaultKingdeeTreeNode rootNode) {
        String number = (String)objMap.get(Constant.Number);
        String name = (String)objMap.get(Constant.Name);
        String nodeStr = number + "(" + name + ")";
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)nodeStr);
        node.setUserObject((Object)objMap);
        this.nodeTreeMap.put(objMap.get(Constant.ID), node);
        if (objMap.get("childIDs") != null) {
            ArrayList list = (ArrayList)objMap.get("childIDs");
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                this.addNode((HashMap)nodeMap.get(list.get(i)), nodeMap, node);
            }
        }
        rootNode.add((MutableTreeNode)node);
    }

    private void initTree() throws Exception {
        int i;
        int size;
        this.nodeTreeMap = new HashMap();
        ArrayList<String> idsList = new ArrayList<String>();
        ArrayList<String> treeIdsList = new ArrayList<String>();
        HashMap<String, HashMap> nodeMap = new HashMap<String, HashMap>();
        Object row = null;
        HashMap objMap = null;
        String id = null;
        String parentID = null;
        FieldTypeEnum fieldType = null;
        Object value = null;
        String rootNodeName = this.baseDataTempletInfo.getMasterData().getName();
        this.rootNode = new DefaultKingdeeTreeNode((Object)rootNodeName);
        ((DefaultTreeModel)this.treeMain.getModel()).setRoot((TreeNode)this.rootNode);
        if (this.searchDataSql == null) {
            this.searchDataSql = this.getSearchDataSql();
        }
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)this.searchDataSql).executeSQL();
        MasterDataModelEntryCollection col = this.baseDataTempletInfo.getMasterData().getMasterDataModel().getEntry();
        MasterDataModelEntryInfo entry = null;
        String fieldName = null;
        String attribute = null;
        while (rs.next()) {
            objMap = new HashMap();
            size = col.size();
            for (i = 0; i < size; ++i) {
                entry = col.get(i);
                attribute = entry.getAttribute();
                fieldName = "F" + attribute;
                fieldType = entry.getFieldType();
                if (FieldTypeEnum.Integer.equals((Object)fieldType)) {
                    value = new Integer(rs.getInt(fieldName));
                } else if (FieldTypeEnum.Decimal.equals((Object)fieldType)) {
                    value = rs.getBigDecimal(fieldName);
                } else if (FieldTypeEnum.Date.equals((Object)fieldType)) {
                    value = rs.getDate(fieldName);
                } else if (FieldTypeEnum.DateTime.equals((Object)fieldType)) {
                    value = rs.getTimestamp(fieldName);
                } else if (FieldTypeEnum.Text.equals((Object)fieldType)) {
                    value = rs.getString(fieldName);
                }
                objMap.put(attribute, value);
                if (!Constant.ID.equals(attribute)) continue;
                id = rs.getString(fieldName);
            }
            nodeMap.put(id, objMap);
            idsList.add(id);
            treeIdsList.add(id);
        }
        size = idsList.size();
        for (i = 0; i < size; ++i) {
            objMap = (HashMap)nodeMap.get(idsList.get(i));
            parentID = (String)objMap.get(Constant.ParentID);
            id = (String)objMap.get(Constant.ID);
            if (parentID == null || !nodeMap.containsKey(parentID)) continue;
            HashMap parentObjMap = (HashMap)nodeMap.get(parentID);
            ArrayList list = null;
            list = parentObjMap.get("childIDs") == null ? new ArrayList() : (ArrayList)parentObjMap.get("childIDs");
            list.add(id);
            parentObjMap.put("childIDs", list);
            treeIdsList.remove(idsList.get(i));
        }
        size = treeIdsList.size();
        for (i = 0; i < size; ++i) {
            objMap = (HashMap)nodeMap.get(treeIdsList.get(i));
            this.addNode(objMap, nodeMap, this.rootNode);
        }
        this.treeMain.expandAllNodes(true, (TreeNode)this.rootNode);
        if (this.selectedNodeId == null) {
            if (this.rootNode.getChildCount() > 0) {
                this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)this.rootNode.getFirstChild());
            }
        } else {
            this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)this.nodeTreeMap.get(this.selectedNodeId));
        }
    }

    private void showInfo() {
        this.plMain.removeAll();
        this.uiMap.clear();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (node == null || node.getUserObject() instanceof String) {
            this.repaint();
            return;
        }
        MasterDataModelEntryCollection col = this.baseDataTempletInfo.getMasterData().getMasterDataModel().getEntry();
        if (col == null || col.size() <= 0) {
            MsgBox.showInfo((String)Constant.ModelNotCompleted);
            SysUtil.abort();
        }
        int x = 10;
        int y = 10;
        MasterDataModelEntryInfo entry = null;
        FieldTypeEnum fieldType = null;
        KDFormattedTextField component = null;
        String attribute = null;
        this.oldData = (HashMap)node.getUserObject();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            KDFormattedTextField comp;
            entry = col.get(i);
            attribute = entry.getAttribute();
            fieldType = entry.getFieldType();
            KDLabelContainer label = new KDLabelContainer();
            label.setBoundLabelText(entry.getAlias());
            label.setBoundLabelLength(100);
            label.setBoundLabelUnderline(true);
            label.setBounds(new Rectangle(x, y, 270, 19));
            this.plMain.add((Component)label, null);
            if (Constant.ID.equals(attribute) || Constant.ParentID.equals(attribute)) {
                label.setVisible(false);
            } else {
                y += 22;
            }
            if (FieldTypeEnum.Integer.equals((Object)fieldType)) {
                comp = new KDFormattedTextField();
                comp.setHorizontalAlignment(2);
                comp.setDataType(0);
                comp.setName(attribute);
                comp.setEnabled(false);
                if (!entry.isIsNull()) {
                    comp.setRequired(true);
                }
                label.setBoundEditor((JComponent)comp);
                component = comp;
                if (this.oldData != null) {
                    comp.setValue(this.oldData.get(attribute));
                }
            } else if (FieldTypeEnum.Decimal.equals((Object)fieldType)) {
                comp = new KDFormattedTextField();
                comp.setHorizontalAlignment(2);
                comp.setDataType(1);
                comp.setMinimumValue((Comparable)new BigDecimal("-1.0E18"));
                comp.setMaximumValue((Comparable)new BigDecimal("1.0E18"));
                comp.setPrecision(10);
                comp.setName(attribute);
                comp.setEnabled(false);
                if (!entry.isIsNull()) {
                    comp.setRequired(true);
                }
                label.setBoundEditor((JComponent)comp);
                component = comp;
                if (this.oldData != null) {
                    comp.setValue(this.oldData.get(attribute));
                }
            } else if (FieldTypeEnum.Date.equals((Object)fieldType)) {
                comp = new KDDatePicker();
                comp.setName(attribute);
                comp.setEnabled(false);
                if (!entry.isIsNull()) {
                    comp.setRequired(true);
                }
                label.setBoundEditor((JComponent)comp);
                component = comp;
                if (this.oldData != null) {
                    comp.setValue(this.oldData.get(attribute));
                }
            } else if (FieldTypeEnum.DateTime.equals((Object)fieldType)) {
                comp = new KDDatePicker();
                comp.setTimeEnabled(true);
                comp.setName(attribute);
                comp.setEnabled(false);
                if (!entry.isIsNull()) {
                    comp.setRequired(true);
                }
                label.setBoundEditor((JComponent)comp);
                component = comp;
                if (this.oldData != null) {
                    comp.setValue(this.oldData.get(attribute));
                }
            } else if (FieldTypeEnum.Text.equals((Object)fieldType)) {
                comp = new KDTextField();
                comp.setMaxLength(80);
                comp.setName(attribute);
                comp.setEnabled(false);
                if (!entry.isIsNull()) {
                    comp.setRequired(true);
                }
                label.setBoundEditor((JComponent)comp);
                component = comp;
                if (this.oldData != null) {
                    comp.setText((String)this.oldData.get(attribute));
                }
                if (Constant.ID.equals(attribute)) {
                    comp.setEnabled(false);
                    comp.setVisible(false);
                    if (this.oldData != null) {
                        comp.setText((String)this.oldData.get(Constant.ID));
                    }
                }
                if (Constant.ParentID.equals(attribute)) {
                    comp.setEnabled(false);
                    comp.setVisible(false);
                    if (this.oldData != null) {
                        comp.setText((String)this.oldData.get(Constant.ParentID));
                    }
                }
            }
            this.uiMap.put(attribute, component);
            this.plMain.setPreferredSize(new Dimension(540, y));
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }
}

