/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlCompanyDBMappingInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlDispatchStatusEnum;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlSchemeManagerFactory;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlSchemeManagerGroupInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlSchemeManagerInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.client.AbstractEtlSchemeManagerEditUI;
import com.kingdee.eas.framework.bireport.bimanager.etl.client.EtlCompanyDBMappingListUI;
import com.kingdee.eas.framework.bireport.bimanager.util.client.F7ListUISelector;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class EtlSchemeManagerEditUI
extends AbstractEtlSchemeManagerEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EtlSchemeManagerEditUI.class);
    private static final String resourceFileName = "com.kingdee.eas.framework.bireport.bimanager.etl.client.EtlClientResource";

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        F7ListUISelector.setListToPrmtF7(this.prmtCompanyDBMapping, (ListUI)new EtlCompanyDBMappingListUI());
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.prmtCompanyDBMapping.setValue((Object)this.editData.getComDBMapping());
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setComDBMapping((EtlCompanyDBMappingInfo)this.prmtCompanyDBMapping.getValue());
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        String number = this.txtNumber.getText();
        if (StringUtils.isEmpty((String)number)) {
            this.txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"numberIsNotNull"));
            SysUtil.abort();
        } else {
            char[] chs = number.trim().toCharArray();
            Pattern p = Pattern.compile("[a-zA-Z_0-9]");
            for (int i = 0; i < chs.length; ++i) {
                Matcher m = p.matcher(Character.toString(chs[i]));
                if (m.matches()) continue;
                this.txtNumber.requestFocus(true);
                MsgBox.showInfo((String)EASResource.getString((String)resourceFileName, (String)"onlyCharOANum"));
                SysUtil.abort();
            }
        }
        Object objName = this.txtName.getDefaultLangItemData();
        if (objName == null || StringUtils.isEmpty((String)objName.toString())) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"nameIsNotNull"));
            SysUtil.abort();
        }
    }

    @Override
    protected IObjectValue createNewData() {
        EtlSchemeManagerInfo info = new EtlSchemeManagerInfo();
        Object objGroup = this.getUIContext().get("groupInfo");
        if (objGroup instanceof EtlSchemeManagerGroupInfo) {
            info.setGroup((EtlSchemeManagerGroupInfo)objGroup);
        }
        info.setStatus(EtlDispatchStatusEnum.NOTSTART);
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return EtlSchemeManagerFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add("*");
        selectors.add("comDBMapping.id");
        selectors.add("comDBMapping.name");
        selectors.add("comDBMapping.number");
        return selectors;
    }
}

