/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.mdm.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.BIProjectSchemeInfo;
import com.kingdee.eas.framework.bireport.bimanager.GetCurProjectFacadeFactory;
import com.kingdee.eas.framework.bireport.bimanager.IGetCurProjectFacade;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataModelFactory;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataModelInfo;
import com.kingdee.eas.framework.bireport.bimanager.mdm.client.AbstractMasterDataModelDefineEditUI;
import com.kingdee.eas.framework.bireport.bimanager.util.BiManagerUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.framework.bireport.bimanager.util.UIHelper;
import com.kingdee.eas.framework.bireport.bimanager.util.client.BIClientVerifyHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class MasterDataModelDefineEditUI
extends AbstractMasterDataModelDefineEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MasterDataModelDefineEditUI.class);
    private Map defaultAttributeMap = new HashMap();
    private ActionListener[] actions;

    public MasterDataModelDefineEditUI() throws Exception {
        this.setPreferredSize(new Dimension(600, 400));
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MasterDataModelFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        MasterDataModelInfo objectValue = new MasterDataModelInfo();
        return objectValue;
    }

    @Override
    public void onLoad() throws Exception {
        this.kdtEntry.checkParsed();
        super.onLoad();
        this.initUI();
    }

    private void initUI() throws Exception {
        super.lockAction();
        ItemAction[] itemActions = new ItemAction[]{this.actionEdit, this.actionRemove, this.actionSubmit};
        BiManagerUtil.setActionsEnabledStatus(itemActions, true);
        BiManagerUtil.setVisibleToolBarStatus(this.toolBar);
        BiManagerUtil.setVisibleMenuBarStatus(this.menuBar);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnSubmit.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.btnEdit.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
        UIHelper.setTableTitle(this.kdtEntry_detailPanel, Constant.AttribuEntry, 110);
        KDComboBox kdtEntry_fieldType_ComboBox = new KDComboBox();
        kdtEntry_fieldType_ComboBox.setName("kdtEntry_fieldType_ComboBox");
        kdtEntry_fieldType_ComboBox.setVisible(true);
        kdtEntry_fieldType_ComboBox.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.framework.bireport.bimanager.FieldTypeEnum").toArray());
        KDTDefaultCellEditor kdtEntry_fieldType_CellEditor = new KDTDefaultCellEditor((JComboBox)kdtEntry_fieldType_ComboBox);
        this.kdtEntry.getColumn("fieldType").setEditor((ICellEditor)kdtEntry_fieldType_CellEditor);
        this.kdtEntry.getColumn("attribute").setRequired(true);
        this.kdtEntry.getColumn("alias").setRequired(true);
        this.kdtEntry.getColumn("fieldType").setRequired(true);
        this.prmtMasterDataLable.setEditable(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        IGetCurProjectFacade iGetCurProjectFacade = GetCurProjectFacadeFactory.getRemoteInstance();
        BIProjectSchemeInfo bIProjectSchemeInfo = iGetCurProjectFacade.getBIProjectSchemeByUserID(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        filter.getFilterItems().add(new FilterItemInfo("BIProjectScheme.id", (Object)bIProjectSchemeInfo.getId().toString()));
        view.setFilter(filter);
        this.prmtMasterDataLable.setEntityViewInfo(view);
        this.defaultAttributeMap.put(Constant.ID, "");
        this.defaultAttributeMap.put(Constant.Name, "");
        this.defaultAttributeMap.put(Constant.Number, "");
        this.defaultAttributeMap.put(Constant.ParentID, "");
        this.defaultAttributeMap.put(Constant.Order, "");
        this.hideDefaultField();
        KDWorkButton removeLinesButton = this.kdtEntry_detailPanel.getRemoveLinesButton();
        this.actions = removeLinesButton.getActionListeners();
        int size = this.actions.length;
        for (int i = 0; i < size; ++i) {
            removeLinesButton.removeActionListener(this.actions[i]);
        }
        removeLinesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    boolean isRemove = MsgBox.isYes((int)MsgBox.showConfirm2((String)Constant.DeleteDataConfirm));
                    if (!isRemove) {
                        return;
                    }
                    int size = MasterDataModelDefineEditUI.this.actions.length;
                    for (int i = 0; i < size; ++i) {
                        MasterDataModelDefineEditUI.this.actions[i].actionPerformed(e);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.hideDefaultField();
    }

    private void hideDefaultField() {
        int size = this.kdtEntry.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdtEntry.getRow(i);
            String attribute = (String)row.getCell("attribute").getValue();
            if (attribute == null || !this.defaultAttributeMap.containsKey(attribute)) continue;
            row.getStyleAttributes().setHided(true);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        boolean isUsed = this.editData.isIsUsed();
        if (isUsed) {
            MsgBox.showInfo((String)Constant.isUsedCanNotModify);
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        BIClientVerifyHelper.verifyRequire((CoreUIObject)this);
        String number = this.txtNumber.getText();
        int maxLength = 12;
        if (number.length() > maxLength) {
            MsgBox.showWarning((String)(Constant.NumberChineseName + number + Constant.LengthExceed + maxLength));
            SysUtil.abort();
        }
        if (!number.matches("[a-zA-Z]\\w*")) {
            MsgBox.showWarning((String)(Constant.NumberChineseName + number + Constant.NumberFormatError));
            SysUtil.abort();
        }
        if ("id".equals(number)) {
            MsgBox.showWarning((String)(Constant.NumberChineseName + number + Constant.IsDefault));
            SysUtil.abort();
        }
        if (this.kdtEntry.getRowCount() <= 0) {
            MsgBox.showInfo((String)Constant.EntryNotBeNull);
            SysUtil.abort();
        }
        UIHelper.verifyTableRequire((CoreUIObject)this, this.kdtEntry);
        HashMap<String, String> map = new HashMap<String, String>();
        int rows = this.kdtEntry.getRowCount();
        for (int i = 0; i < rows; ++i) {
            String value = (String)this.kdtEntry.getCell(i, "attribute").getValue();
            int entryNumberMaxLength = 12;
            if (value.length() > entryNumberMaxLength) {
                MsgBox.showWarning((String)(Constant.Attribute + value + Constant.LengthExceed + entryNumberMaxLength));
                SysUtil.abort();
            }
            if (!value.matches("[a-zA-Z]\\w*")) {
                MsgBox.showWarning((String)(Constant.Attribute + value + Constant.NumberFormatError));
                SysUtil.abort();
            }
            if (this.defaultAttributeMap.containsKey(value) && !this.kdtEntry.getRow(i).getStyleAttributes().isHided()) {
                MsgBox.showWarning((String)(Constant.Attribute + value + Constant.IsDefault));
                SysUtil.abort();
            }
            if (map.containsKey(value.toUpperCase())) {
                MsgBox.showWarning((String)(Constant.Attribute + value + Constant.DoubleName));
                SysUtil.abort();
            }
            map.put(value.toUpperCase(), "");
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        return sic;
    }
}

