/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio;

import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.ExceptionMonitor;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoHandler;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoServiceConfig;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.support.BaseIoAcceptor;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.SocketIoProcessor;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.SocketSessionConfig;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.SocketSessionImpl;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.util.NamePreservingRunnable;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.util.NewThreadExecutor;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.util.Queue;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SocketAcceptor
extends BaseIoAcceptor {
    private static volatile int nextId = 0;
    private final Executor executor;
    private final Object lock = new Object();
    private final int id = nextId++;
    private final String threadName = "SocketAcceptor-" + this.id;
    private SocketAcceptorConfig defaultConfig = new SocketAcceptorConfig();
    private final Map channels = new HashMap();
    private final Queue registerQueue = new Queue();
    private final Queue cancelQueue = new Queue();
    private final SocketIoProcessor[] ioProcessors;
    private final int processorCount;
    private Selector selector;
    private Worker worker;
    private int processorDistributor = 0;

    public SocketAcceptor() {
        this(1, new NewThreadExecutor());
    }

    public SocketAcceptor(int processorCount, Executor executor) {
        if (processorCount < 1) {
            throw new IllegalArgumentException("Must have at least one processor");
        }
        ((SocketSessionConfig)this.defaultConfig.getSessionConfig()).setReuseAddress(true);
        this.executor = executor;
        this.processorCount = processorCount;
        this.ioProcessors = new SocketIoProcessor[processorCount];
        for (int i = 0; i < processorCount; ++i) {
            this.ioProcessors[i] = new SocketIoProcessor("SocketAcceptorIoProcessor-" + this.id + "." + i, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(SocketAddress address, IoHandler handler, IoServiceConfig config) throws IOException {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (address != null && !(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        RegistrationRequest request = new RegistrationRequest(address, handler, config);
        Object object = this.lock;
        synchronized (object) {
            this.startupWorker();
            Queue queue = this.registerQueue;
            synchronized (queue) {
                this.registerQueue.push(request);
            }
            this.selector.wakeup();
        }
        object = request;
        synchronized (object) {
            while (!request.done) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        if (request.exception != null) {
            throw request.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Selector getSelector() {
        Object object = this.lock;
        synchronized (object) {
            return this.selector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupWorker() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.worker == null) {
                this.selector = Selector.open();
                this.worker = new Worker();
                this.executor.execute((Runnable)new NamePreservingRunnable(this.worker, this.threadName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(SocketAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        CancellationRequest request = new CancellationRequest(address);
        try {
            this.startupWorker();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Address not bound: " + address);
        }
        Object object = this.cancelQueue;
        synchronized (object) {
            this.cancelQueue.push(request);
        }
        this.selector.wakeup();
        object = request;
        synchronized (object) {
            while (!request.done) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        if (request.exception != null) {
            request.exception.fillInStackTrace();
            throw request.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindAll() {
        ArrayList addresses;
        Map map = this.channels;
        synchronized (map) {
            addresses = new ArrayList(this.channels.keySet());
        }
        Iterator i = addresses.iterator();
        while (i.hasNext()) {
            this.unbind((SocketAddress)i.next());
        }
    }

    private SocketIoProcessor nextProcessor() {
        if (this.processorDistributor == Integer.MAX_VALUE) {
            this.processorDistributor = Integer.MAX_VALUE % this.processorCount;
        }
        return this.ioProcessors[this.processorDistributor++ % this.processorCount];
    }

    @Override
    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(SocketAcceptorConfig defaultConfig) {
        if (defaultConfig == null) {
            throw new NullPointerException("defaultConfig");
        }
        this.defaultConfig = defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerNew() {
        if (this.registerQueue.isEmpty()) {
            return;
        }
        Selector selector = this.getSelector();
        while (true) {
            RegistrationRequest req;
            Queue queue = this.registerQueue;
            synchronized (queue) {
                req = (RegistrationRequest)this.registerQueue.pop();
            }
            if (req == null) return;
            ServerSocketChannel ssc = null;
            try {
                ssc = ServerSocketChannel.open();
                ssc.configureBlocking(false);
                SocketAcceptorConfig cfg = req.config instanceof SocketAcceptorConfig ? (SocketAcceptorConfig)req.config : (SocketAcceptorConfig)this.getDefaultConfig();
                ssc.socket().setReuseAddress(cfg.isReuseAddress());
                ssc.socket().setReceiveBufferSize(((SocketSessionConfig)cfg.getSessionConfig()).getReceiveBufferSize());
                ssc.socket().bind(req.address, cfg.getBacklog());
                if (req.address == null || req.address.getPort() == 0) {
                    req.address = (InetSocketAddress)ssc.socket().getLocalSocketAddress();
                }
                ssc.register(selector, 16, req);
                Map map = this.channels;
                synchronized (map) {
                    this.channels.put(req.address, ssc);
                }
                this.getListeners().fireServiceActivated(this, req.address, req.handler, req.config);
                continue;
            }
            catch (IOException e) {
                req.exception = e;
                continue;
            }
            finally {
                RegistrationRequest e = req;
                synchronized (e) {
                    req.done = true;
                    req.notifyAll();
                }
                if (ssc == null || req.exception == null) continue;
                try {
                    ssc.close();
                }
                catch (IOException e2) {
                    ExceptionMonitor.getInstance().exceptionCaught(e2);
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cancelKeys() {
        if (this.cancelQueue.isEmpty()) {
            return;
        }
        Selector selector = this.getSelector();
        while (true) {
            ServerSocketChannel ssc;
            CancellationRequest request;
            Queue queue = this.cancelQueue;
            synchronized (queue) {
                request = (CancellationRequest)this.cancelQueue.pop();
            }
            if (request == null) return;
            Object object = this.channels;
            synchronized (object) {
                ssc = (ServerSocketChannel)this.channels.remove(request.address);
            }
            try {
                if (ssc == null) {
                    request.exception = new IllegalArgumentException("Address not bound: " + request.address);
                    continue;
                }
                SelectionKey key = ssc.keyFor(selector);
                request.registrationRequest = (RegistrationRequest)key.attachment();
                key.cancel();
                selector.wakeup();
                ssc.close();
                continue;
            }
            catch (IOException e) {
                ExceptionMonitor.getInstance().exceptionCaught(e);
                continue;
            }
            finally {
                object = request;
                synchronized (object) {
                    request.done = true;
                    request.notifyAll();
                }
                if (request.exception != null) continue;
                this.getListeners().fireServiceDeactivated(this, request.address, request.registrationRequest.handler, request.registrationRequest.config);
                continue;
            }
            break;
        }
    }

    private static class CancellationRequest {
        private final SocketAddress address;
        private boolean done;
        private RegistrationRequest registrationRequest;
        private RuntimeException exception;

        private CancellationRequest(SocketAddress address) {
            this.address = address;
        }
    }

    private static class RegistrationRequest {
        private InetSocketAddress address;
        private final IoHandler handler;
        private final IoServiceConfig config;
        private IOException exception;
        private boolean done;

        private RegistrationRequest(SocketAddress address, IoHandler handler, IoServiceConfig config) {
            this.address = (InetSocketAddress)address;
            this.handler = handler;
            this.config = config;
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Selector selector = SocketAcceptor.this.getSelector();
            while (true) {
                try {
                    do {
                        int nKeys = selector.select();
                        SocketAcceptor.this.registerNew();
                        if (nKeys > 0) {
                            this.processSessions(selector.selectedKeys());
                        }
                        SocketAcceptor.this.cancelKeys();
                    } while (!selector.keys().isEmpty());
                    Object object = SocketAcceptor.this.lock;
                    synchronized (object) {
                        if (selector.keys().isEmpty() && SocketAcceptor.this.registerQueue.isEmpty() && SocketAcceptor.this.cancelQueue.isEmpty()) {
                            SocketAcceptor.this.worker = null;
                            try {
                                selector.close();
                            }
                            catch (IOException e) {
                                ExceptionMonitor.getInstance().exceptionCaught(e);
                            }
                            finally {
                                SocketAcceptor.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ExceptionMonitor.getInstance().exceptionCaught(e1);
                    }
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processSessions(Set keys) throws IOException {
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                ServerSocketChannel ssc;
                SocketChannel ch;
                SelectionKey key = (SelectionKey)it.next();
                it.remove();
                if (!key.isAcceptable() || (ch = (ssc = (ServerSocketChannel)key.channel()).accept()) == null) continue;
                boolean success = false;
                try {
                    RegistrationRequest req = (RegistrationRequest)key.attachment();
                    SocketSessionImpl session = new SocketSessionImpl(SocketAcceptor.this, SocketAcceptor.this.nextProcessor(), SocketAcceptor.this.getListeners(), req.config, ch, req.handler, req.address);
                    SocketAcceptor.this.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
                    req.config.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
                    req.config.getThreadModel().buildFilterChain(session.getFilterChain());
                    session.getIoProcessor().addNew(session);
                    success = true;
                }
                catch (Throwable t) {
                    ExceptionMonitor.getInstance().exceptionCaught(t);
                }
                finally {
                    if (success) continue;
                    ch.close();
                }
            }
        }
    }
}

