/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.sc.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.sc.MessageReceiveCollection;
import com.kingdee.eas.framework.bireport.bimanager.sc.MessageReceiveFactory;
import com.kingdee.eas.framework.bireport.bimanager.sc.MessageReceiveInfo;
import com.kingdee.eas.framework.bireport.bimanager.sc.ReceiverTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.sc.UserGroupInfo;
import com.kingdee.eas.framework.bireport.bimanager.sc.client.AbstractMessageReceiveEditUI;
import com.kingdee.eas.framework.bireport.bimanager.util.BiManagerUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.framework.bireport.bimanager.util.client.BIClientVerifyHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class MessageReceiveEditUI
extends AbstractMessageReceiveEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MessageReceiveEditUI.class);

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MessageReceiveFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() {
        super.lockAction();
        ItemAction[] itemActions = new ItemAction[]{this.actionAddNew, this.actionEdit, this.actionRemove, this.actionSubmit};
        BiManagerUtil.setActionsEnabledStatus(itemActions, true);
        BiManagerUtil.setVisibleToolBarStatus(this.toolBar);
        BiManagerUtil.setVisibleMenuBarStatus(this.menuBar);
        this.prmtCompany.setSelector((KDPromptSelector)new CompanyF7());
        if (!this.getOprtState().equals("ADDNEW")) {
            this.prmtCompany.setEnabled(false);
        }
        this.prmtUser.setEnabled(false);
        this.prmtUserGroup.setEnabled(false);
        ReceiverTypeEnum receiverType = this.editData.getReceiverType();
        if (receiverType != null) {
            if (receiverType.getValue().equals("0")) {
                this.radUser.setSelected(true);
                this.prmtUser.setEnabled(true);
                this.prmtUserGroup.setEnabled(false);
            } else {
                this.radUserGroup.setSelected(true);
                this.prmtUser.setEnabled(false);
                this.prmtUserGroup.setEnabled(true);
            }
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnSubmit.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.btnEdit.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("receiverType"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("userGroup.*"));
        sic.add(new SelectorItemInfo("user.*"));
        return sic;
    }

    @Override
    protected void radUser_actionPerformed(ActionEvent e) throws Exception {
        super.radUser_actionPerformed(e);
        if (this.radUser.isSelected()) {
            this.prmtUser.setEnabled(true);
            this.prmtUserGroup.setValue(null);
            this.prmtUserGroup.setEnabled(false);
        } else {
            this.prmtUser.setEnabled(false);
            this.prmtUserGroup.setEnabled(true);
        }
    }

    @Override
    protected void radUserGroup_actionPerformed(ActionEvent e) throws Exception {
        super.radUserGroup_actionPerformed(e);
        if (this.radUserGroup.isSelected()) {
            this.prmtUserGroup.setEnabled(true);
            this.prmtUser.setValue(null);
            this.prmtUser.setEnabled(false);
        } else {
            this.prmtUserGroup.setEnabled(false);
            this.prmtUser.setEnabled(true);
        }
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCompany_dataChanged(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        ReceiverTypeEnum receiverType = this.editData.getReceiverType();
        if (receiverType != null) {
            if (receiverType.getValue().equals("0")) {
                this.radUser.setSelected(true);
                this.prmtUser.setEnabled(true);
                this.prmtUserGroup.setEnabled(false);
            } else {
                this.radUserGroup.setSelected(true);
                this.prmtUser.setEnabled(false);
                this.prmtUserGroup.setEnabled(true);
            }
        }
        this.btnSubmit.setEnabled(true);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.btnSubmit.setEnabled(true);
    }

    @Override
    protected IObjectValue createNewData() {
        MessageReceiveInfo objectValue = new MessageReceiveInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.radUser.isSelected() && this.prmtUser.getValue() != null) {
            this.editData.setReceiverType(ReceiverTypeEnum.user);
        } else if (this.radUserGroup.isSelected() && this.prmtUserGroup.getValue() != null) {
            this.editData.setReceiverType(ReceiverTypeEnum.userGroup);
        } else {
            MsgBox.showWarning((String)Constant.chooseReceiver);
            SysUtil.abort();
        }
        EntityViewInfo view = new EntityViewInfo();
        if (this.radUser.isSelected()) {
            view.getSelector().add("user.*");
        } else {
            view.getSelector().add("userGroup.*");
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId()));
        filter.getFilterItems().add(new FilterItemInfo("receiverType", (Object)this.editData.getReceiverType()));
        view.setFilter(filter);
        MessageReceiveCollection col = MessageReceiveFactory.getRemoteInstance().getMessageReceiveCollection(view);
        if (this.radUser.isSelected()) {
            for (int i = 0; i < col.size(); ++i) {
                if (!col.get(i).getUser().getId().equals((Object)((UserInfo)this.prmtUser.getValue()).getId())) continue;
                MsgBox.showWarning((String)Constant.EntryIsOnly);
                SysUtil.abort();
            }
        } else {
            for (int i = 0; i < col.size(); ++i) {
                if (!col.get(i).getUserGroup().getId().equals((Object)((UserGroupInfo)this.prmtUserGroup.getValue()).getId())) continue;
                MsgBox.showWarning((String)Constant.EntryIsOnly);
                SysUtil.abort();
            }
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        BIClientVerifyHelper.verifyRequire((CoreUIObject)this);
    }
}

