/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.sc.client;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.sc.UserGroupEntryCollection;
import com.kingdee.eas.framework.bireport.bimanager.sc.UserGroupFactory;
import com.kingdee.eas.framework.bireport.bimanager.sc.UserGroupInfo;
import com.kingdee.eas.framework.bireport.bimanager.sc.client.AbstractUserGroupEditUI;
import com.kingdee.eas.framework.bireport.bimanager.util.BiManagerUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.framework.bireport.bimanager.util.UIHelper;
import com.kingdee.eas.framework.bireport.bimanager.util.client.BIClientVerifyHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class UserGroupEditUI
extends AbstractUserGroupEditUI {
    private static final Logger logger = CoreUIObject.getLogger(UserGroupEditUI.class);
    ICellEditor cellEditor = null;
    UserGroupEntryCollection col;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() {
        super.lockAction();
        ItemAction[] itemActions = new ItemAction[]{this.actionAddNew, this.actionEdit, this.actionRemove, this.actionSubmit};
        BiManagerUtil.setActionsEnabledStatus(itemActions, true);
        BiManagerUtil.setVisibleToolBarStatus(this.toolBar);
        BiManagerUtil.setVisibleMenuBarStatus(this.menuBar);
        this.kDTblUsers.checkParsed();
        this.remove((Component)this.btnInsert);
        this.remove((Component)this.btnDelete);
        this.kDContainer1.addButton((JButton)this.btnInsert);
        this.kDContainer1.addButton((JButton)this.btnDelete);
        this.col = this.editData.getUsers();
        if (this.getOprtState().equals("ADDNEW")) {
            this.editData.setIsUsed(true);
        }
        KDBizPromptBox f7user = new KDBizPromptBox();
        f7user.setQueryInfo("com.kingdee.eas.base.permission.app.UserListQuery");
        f7user.setVisible(true);
        f7user.setEditable(false);
        f7user.setEditFormat("$number$");
        f7user.setDisplayFormat("$number$");
        ObjectValueRender obj = new ObjectValueRender();
        obj.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.cellEditor = new KDTDefaultCellEditor((IKDEditor)f7user);
        this.kDTblUsers.getColumn("userNumber").setRenderer((IBasicRender)obj);
        this.kDTblUsers.getColumn("userNumber").setEditor(this.cellEditor);
        this.kDTblUsers.getColumn("userName").getEditor().getComponent().setEnabled(false);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnSubmit.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.btnEdit.setEnabled(false);
        } else if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
        f7user.setEditable(false);
    }

    @Override
    protected void btnDelete_mouseClicked(MouseEvent e) throws Exception {
        super.btnDelete_mouseClicked(e);
        int[] index = KDTableUtil.getSelectedRows((KDTable)this.kDTblUsers);
        if (index == null || index.length <= 0) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        for (int i = index.length; i > 0; --i) {
            this.kDTblUsers.removeRow(index[i - 1]);
        }
        this.kDTblUsers.updateUI();
    }

    @Override
    protected void btnInsert_mouseClicked(MouseEvent e) throws Exception {
        super.btnInsert_mouseClicked(e);
        IRow row = this.kDTblUsers.addRow();
    }

    @Override
    protected void kDTblUsers_editStopped(KDTEditEvent e) throws Exception {
        UserInfo info;
        String userName;
        super.kDTblUsers_editStopped(e);
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.kDTblUsers);
        Object user = row.getCell("userNumber").getValue();
        if (user == null) {
            row.getCell("userName").setValue(null);
            SysUtil.abort();
        }
        if ((userName = (info = (UserInfo)user).getName()) != null) {
            row.getCell("userName").setValue((Object)userName);
        }
    }

    @Override
    protected void kDTblUsers_editValueChanged(KDTEditEvent e) throws Exception {
        UserInfo info;
        String userName;
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.kDTblUsers);
        Object user = row.getCell("userNumber").getValue();
        if (user == null) {
            SysUtil.abort();
        }
        if ((userName = (info = (UserInfo)user).getName()) != null) {
            row.getCell("userName").setValue((Object)userName);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("isUsed"));
        return sic;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            boolean isUsed = this.editData.isIsUsed();
            if (isUsed) {
                MsgBox.showInfo((String)Constant.isUsedCanNotRemove);
                SysUtil.abort();
            } else {
                super.actionRemove_actionPerformed(e);
            }
        } else {
            super.actionRemove_actionPerformed(e);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            boolean isUsed = this.editData.isIsUsed();
            if (isUsed) {
                MsgBox.showInfo((String)Constant.isUsedCanNotModify);
                SysUtil.abort();
            } else {
                super.actionEdit_actionPerformed(e);
            }
        } else {
            super.actionEdit_actionPerformed(e);
        }
        this.btnSubmit.setEnabled(true);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.btnSubmit.setEnabled(true);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return UserGroupFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        UserGroupInfo objectValue = new UserGroupInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        BIClientVerifyHelper.verifyRequire((CoreUIObject)this);
        UIHelper.verifyTableRequire((CoreUIObject)this, this.kDTblUsers);
        for (int i = 0; i < this.kDTblUsers.getRowCount() - 1; ++i) {
            Object userInfo = this.kDTblUsers.getRow(i).getCell("userNumber").getValue();
            for (int j = i + 1; j < this.kDTblUsers.getRowCount(); ++j) {
                Object anotherUserInfo = this.kDTblUsers.getRow(j).getCell("userNumber").getValue();
                if (userInfo == null || anotherUserInfo == null || !((UserInfo)userInfo).getNumber().equals(((UserInfo)anotherUserInfo).getNumber())) continue;
                MsgBox.showWarning((String)Constant.RepeatedData);
                SysUtil.abort();
            }
        }
    }
}

