/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.sc.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.sc.UserGroupFactory;
import com.kingdee.eas.framework.bireport.bimanager.sc.UserGroupInfo;
import com.kingdee.eas.framework.bireport.bimanager.sc.client.AbstractUserGroupListUI;
import com.kingdee.eas.framework.bireport.bimanager.sc.client.UserGroupEditUI;
import com.kingdee.eas.framework.bireport.bimanager.util.BiManagerUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class UserGroupListUI
extends AbstractUserGroupListUI {
    private static final Logger logger = CoreUIObject.getLogger(UserGroupListUI.class);
    private FilterInfo oldFilter;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() {
        super.lockAction();
        ItemAction[] itemActions = new ItemAction[]{this.actionAddNew, this.actionEdit, this.actionRemove, this.actionView, this.actionQuery, this.actionLocate, this.actionRefresh, this.actionCancelCancel, this.actionCancel};
        BiManagerUtil.setActionsEnabledStatus(itemActions, true);
        BiManagerUtil.setVisibleToolBarStatus(this.toolBar);
        BiManagerUtil.setVisibleMenuBarStatus(this.menuBar);
    }

    protected UserGroupInfo getSelectInfo() throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        String id = (String)row.getCell("id").getValue();
        UserGroupInfo info = (UserGroupInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(id));
        return info;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        UserGroupInfo info = this.getSelectInfo();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        if (this.confirmDialog(cancelMsg)) {
            info.setIsUsed(false);
            this.getBizInterface().update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            this.btnCancelCancel.setEnabled(true);
            this.btnCancel.setEnabled(false);
        }
        this.refresh(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            return;
        }
        UserGroupInfo info = this.getSelectInfo();
        if (info.isIsUsed()) {
            this.btnCancelCancel.setEnabled(false);
            this.btnCancel.setEnabled(true);
        } else {
            this.btnCancelCancel.setEnabled(true);
            this.btnCancel.setEnabled(false);
        }
        super.tblMain_tableClicked(e);
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            return;
        }
        UserGroupInfo info = this.getSelectInfo();
        if (info.isIsUsed()) {
            this.btnCancelCancel.setEnabled(false);
            this.btnCancel.setEnabled(true);
        } else {
            this.btnCancelCancel.setEnabled(true);
            this.btnCancel.setEnabled(false);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        UserGroupInfo info = this.getSelectInfo();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            info.setIsUsed(true);
            this.getBizInterface().update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            this.btnCancelCancel.setEnabled(false);
            this.btnCancel.setEnabled(true);
        }
        this.refresh(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        Boolean isUsed;
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        if ((isUsed = (Boolean)row.getCell("isUsed").getValue()) != null && isUsed.booleanValue()) {
            MsgBox.showInfo((String)Constant.isUsedCanNotRemove);
            SysUtil.abort();
        } else {
            super.actionRemove_actionPerformed(e);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        Boolean isUsed;
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (row == null) {
            MsgBox.showInfo((String)Constant.ChooseRow);
            SysUtil.abort();
        }
        if ((isUsed = (Boolean)row.getCell("isUsed").getValue()) != null && isUsed.booleanValue()) {
            MsgBox.showInfo((String)Constant.isUsedCanNotModify);
            SysUtil.abort();
        } else {
            super.actionEdit_actionPerformed(e);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return UserGroupFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return UserGroupEditUI.class.getName();
    }
}

