/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws;

import com.kingdee.eas.framework.bireport.bimanager.ws.TimeInfo;
import java.math.BigDecimal;

public class CellValueBean {
    public String fieldName;
    public String type;
    public Object value;

    public String toString() {
        if (this.type == "0") {
            return this.fieldName;
        }
        return this.value.toString();
    }

    public String toSaveStr() {
        if (this.fieldName == null && this.value == null) {
            return "";
        }
        if (this.type == "0") {
            return "Field:" + this.fieldName;
        }
        if (this.value instanceof TimeInfo) {
            return "" + this.type + ";" + ((TimeInfo)this.value).toSaveString();
        }
        return "" + this.type + ";" + this.value.toString();
    }

    public static CellValueBean parseBean(String str) {
        if ("".equals(str) || str == null || str.trim().length() == 0) {
            return null;
        }
        if (str.startsWith("Field:")) {
            CellValueBean bean = new CellValueBean("0", str);
            bean.fieldName = str.substring(6);
            return bean;
        }
        String[] split = str.split(";");
        if (split.length == 1) {
            return new CellValueBean(split[0], "");
        }
        return new CellValueBean(split[0], split[1]);
    }

    public CellValueBean(String type, String v) {
        this.type = type;
        if (type == "0") {
            this.fieldName = v;
        } else {
            this.value = this.getObject(v);
        }
    }

    public Object toValue() {
        if ("DateTime".endsWith(this.type)) {
            TimeInfo tiemInfo = (TimeInfo)this.value;
            return tiemInfo.timeInfo2Date();
        }
        return this.value;
    }

    private Object getObject(String str) {
        if ("STRING".endsWith(this.type)) {
            return str;
        }
        if ("DateTime".endsWith(this.type)) {
            return TimeInfo.stringToTimeInfo(str);
        }
        if ("INTEGER".endsWith(this.type)) {
            if (str == null || str.trim().length() == 0) {
                str = "0";
            }
            return new Integer(str);
        }
        if ("BigDecimal".endsWith(this.type)) {
            if (str == null || str.trim().length() == 0) {
                str = "0";
            }
            return new BigDecimal(str);
        }
        return null;
    }
}

