/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.bireport.bimanager.TableTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.basedata.ITableIndex;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableIndexFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.BaseDataAcquisitionTempletInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.FactDataTempletInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.AbstractWsExtractSchemeInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsDBInstanceInfo;
import java.io.Serializable;

public class WsExtractSchemeInfo
extends AbstractWsExtractSchemeInfo
implements Serializable {
    private String storeTable;
    private String[] pkFields;
    private String[] pkTypes;

    public WsExtractSchemeInfo() {
    }

    protected WsExtractSchemeInfo(String pkField) {
        super(pkField);
    }

    public String getODSStoreTable(Context ctx) throws Exception {
        if (this.storeTable != null) {
            return this.storeTable;
        }
        if (ctx != null) {
            ITableIndex iTableIndex = TableIndexFactory.getLocalInstance(ctx);
            if (this.getId() == null) {
                throw new NullPointerException("\u65b9\u6848ID\u4e3a\u7a7a\uff01");
            }
            String schemeID = this.getId().toString();
            this.storeTable = iTableIndex.getTableNameById(schemeID, TableTypeEnum.WSODSTable);
        } else {
            ITableIndex iTableIndex = TableIndexFactory.getRemoteInstance();
            if (this.getId() == null) {
                throw new NullPointerException("\u65b9\u6848ID\u4e3a\u7a7a\uff01");
            }
            String schemeID = this.getId().toString();
            this.storeTable = iTableIndex.getTableNameById(schemeID, TableTypeEnum.WSODSTable);
        }
        return this.storeTable;
    }

    public int batchCompanySize() {
        if (!this.isIsBatch()) {
            return 1;
        }
        return this.getCompanyDBMapping().getEntry().size();
    }

    public String getCompanyID(int index) {
        CompanyOrgUnitInfo company = this.getCompanyDBMapping().getEntry().get(index).getCompany();
        if (company == null) {
            return null;
        }
        return company.getId().toString();
    }

    public String getDBInstance(int index) {
        WsDBInstanceInfo dbInstance = this.getCompanyDBMapping().getEntry().get(index).getDbInstance();
        if (dbInstance == null) {
            return null;
        }
        return dbInstance.getId().toString();
    }

    public void parseStr() {
        if (this.pkFields == null) {
            String kfieldNames = this.getPKfieldNames();
            String[] split = kfieldNames.split(";");
            if (split == null || split.length == 0) {
                this.pkFields = new String[0];
                this.pkTypes = new String[0];
            } else {
                this.pkFields = new String[split.length];
                this.pkTypes = new String[split.length];
                for (int i = 0; i < split.length; ++i) {
                    String[] split2 = split[i].split(",");
                    this.pkFields[i] = split2[0];
                    this.pkTypes[i] = split2[1];
                }
            }
        }
    }

    public int pkSize() {
        this.parseStr();
        return this.pkFields.length;
    }

    public boolean isDatePK() {
        if (!this.isDefinePK()) {
            return false;
        }
        this.parseStr();
        for (int i = 0; i < this.pkTypes.length; ++i) {
            String string = this.pkTypes[i];
            if (!"DateTime".equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isDefinePK() {
        String kfieldNames = this.getPKfieldNames();
        return kfieldNames != null && kfieldNames.trim().length() != 0;
    }

    public String getPKType(int index) {
        return this.pkTypes[index];
    }

    public String getPKFied(int index) {
        return this.pkFields[index];
    }

    public int getModelType() {
        String modelID = this.getModelID();
        if (modelID == null || modelID.trim().length() == 0) {
            return 0;
        }
        BOSUuid uuid = BOSUuid.read((String)modelID);
        if (uuid.getType().toString().equals(new FactDataTempletInfo().getBOSType().toString())) {
            return 1;
        }
        if (uuid.getType().toString().equals(new BaseDataAcquisitionTempletInfo().getBOSType().toString())) {
            return -1;
        }
        return 0;
    }
}

