/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.EntityInfoCollection;
import com.kingdee.eas.framework.bireport.bimanager.util.UIHelper;
import com.kingdee.eas.framework.bireport.bimanager.util.client.F7MultiListUISelector;
import com.kingdee.eas.framework.bireport.bimanager.ws.WSCompanyDBMappingEntryCollection;
import com.kingdee.eas.framework.bireport.bimanager.ws.WSCompanyDBMappingEntryInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WSCompanyDBMappingFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.WSCompanyDBMappingGroupInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WSCompanyDBMappingInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsDBInstanceInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.client.AbstractWSCompanyDBMappingEditUI;
import com.kingdee.eas.framework.bireport.bimanager.ws.client.WsDBInstanceListUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WSCompanyDBMappingEditUI
extends AbstractWSCompanyDBMappingEditUI {
    private static final String resourceFileName = "com.kingdee.eas.framework.bireport.bimanager.WS.client.WSClientResource";

    @Override
    public void onLoad() throws Exception {
        this.tbl.checkParsed();
        super.onLoad();
        this.initControl();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            UIHelper.initCompanyTree(this.tbl);
            this.fillDataToTable();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void storeFields() {
        try {
            super.storeFields();
            for (int i = 0; i < this.tbl.getRowCount(); ++i) {
                this.addEntryInfo(i);
            }
            Iterator iter = this.editData.getEntry().iterator();
            while (iter.hasNext()) {
                WSCompanyDBMappingEntryInfo entryInfo = (WSCompanyDBMappingEntryInfo)iter.next();
                if (entryInfo.getDbInstance() != null) continue;
                iter.remove();
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void addEntryInfo(int rowIndex) {
        WSCompanyDBMappingEntryCollection cols = this.editData.getEntry();
        Object value = this.tbl.getRow(rowIndex).getCell("id").getValue();
        for (int i = 0; i < cols.size(); ++i) {
            WSCompanyDBMappingEntryInfo entryInfo = cols.get(i);
            if (!entryInfo.getCompany().getId().toString().equals(value.toString())) continue;
            Object dbID = this.tbl.getRow(rowIndex).getCell("dbInstance").getValue();
            if (!(dbID instanceof EntityInfoCollection)) {
                entryInfo.setDbInstance(null);
                return;
            }
            EntityInfoCollection infoCols = (EntityInfoCollection)dbID;
            entryInfo.setExtendedProperty("isSetdbInstance", "true");
            entryInfo.setDbInstance((WsDBInstanceInfo)infoCols.getObject(0));
            for (int j = 1; j < infoCols.size(); ++j) {
                boolean flag = false;
                for (int k = 0; k < cols.size(); ++k) {
                    WSCompanyDBMappingEntryInfo info = cols.get(k);
                    if (!info.getCompany().getId().toString().equals(value.toString()) || info.getExtendedProperty("isSetdbInstance") != null) continue;
                    info.setCompany((CompanyOrgUnitInfo)this.tbl.getRow(rowIndex).getCell("company").getValue());
                    info.setDbInstance((WsDBInstanceInfo)infoCols.getObject(j));
                    info.setExtendedProperty("isSetdbInstance", "true");
                    flag = true;
                }
                if (flag) continue;
                WSCompanyDBMappingEntryInfo info = new WSCompanyDBMappingEntryInfo();
                info.setCompany((CompanyOrgUnitInfo)this.tbl.getRow(rowIndex).getCell("company").getValue());
                info.setDbInstance((WsDBInstanceInfo)infoCols.getObject(j));
                cols.add(info);
            }
            return;
        }
        Object dbID = this.tbl.getRow(rowIndex).getCell("dbInstance").getValue();
        if (!(dbID instanceof EntityInfoCollection)) {
            return;
        }
        EntityInfoCollection infoCols = (EntityInfoCollection)dbID;
        for (int j = 0; j < infoCols.size(); ++j) {
            WSCompanyDBMappingEntryInfo info = new WSCompanyDBMappingEntryInfo();
            info.setCompany((CompanyOrgUnitInfo)this.tbl.getRow(rowIndex).getCell("company").getValue());
            info.setDbInstance((WsDBInstanceInfo)infoCols.getObject(j));
            cols.add(info);
        }
    }

    private void fillDataToTable() {
        WSCompanyDBMappingEntryCollection cols = this.editData.getEntry();
        for (int i = 0; i < cols.size(); ++i) {
            WSCompanyDBMappingEntryInfo entryInfo = cols.get(i);
            IRow row = this.getRow(entryInfo);
            if (row == null) continue;
            System.out.println(row.getCell("number").getValue());
            try {
                EntityInfoCollection info;
                Object value = row.getCell("dbInstance").getValue();
                if (value instanceof EntityInfoCollection) {
                    info = (EntityInfoCollection)value;
                    info.addObject(entryInfo.getDbInstance());
                    row.getCell("dbInstance").setValue((Object)info);
                    continue;
                }
                info = new EntityInfoCollection(null);
                info.addObject(entryInfo.getDbInstance());
                row.getCell("dbInstance").setValue((Object)info);
                continue;
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private IRow getRow(WSCompanyDBMappingEntryInfo info) {
        if (info == null || info.getCompany() == null) {
            return null;
        }
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            Object value = row.getCell("id").getValue();
            if (!info.getCompany().getId().toString().equals(value.toString())) continue;
            return row;
        }
        return null;
    }

    private void initControl() {
        KDBizPromptBox companyF7 = new KDBizPromptBox();
        companyF7.setQueryInfo("com.kingdee.eas.framework.bireport.bimanager.WS.app.WSCompanyDBMappingQuery");
        companyF7.setVisible(true);
        companyF7.setEditable(false);
        companyF7.setDisplayFormat("$name$");
        companyF7.setEditFormat("$name$");
        companyF7.setSelector((KDPromptSelector)new CompanyF7());
        KDTDefaultCellEditor companyEdit = new KDTDefaultCellEditor((IKDEditor)companyF7);
        this.tbl.getColumn("company").setEditor((ICellEditor)companyEdit);
        KDBizPromptBox prmtdbInstance = new KDBizPromptBox();
        UIContext uiMap = new UIContext((Object)this);
        uiMap.put((Object)"isEnabledMultiSelection", (Object)"true");
        try {
            F7MultiListUISelector.setListToPrmtF7(prmtdbInstance, (ListUI)new WsDBInstanceListUI());
        }
        catch (Exception exception) {
            // empty catch block
        }
        KDTDefaultCellEditor dbInstanceEdit = new KDTDefaultCellEditor((IKDEditor)prmtdbInstance);
        this.tbl.getColumn("dbInstance").setEditor((ICellEditor)dbInstanceEdit);
        this.tbl.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (UIHelper.isSame(e.getOldValue(), e.getValue())) {
                    return;
                }
                int rowIndex = e.getRowIndex();
                int colIndex = e.getColIndex();
                String columnKey = WSCompanyDBMappingEditUI.this.tbl.getColumnKey(colIndex);
                if ("dbInstance".equals(columnKey)) {
                    Object value = WSCompanyDBMappingEditUI.this.tbl.getRow(rowIndex).getCell("dbInstance").getValue();
                    if (value instanceof EntityInfoCollection) {
                        EntityInfoCollection info = new EntityInfoCollection(value);
                        WSCompanyDBMappingEditUI.this.tbl.getRow(rowIndex).getCell("dbInstance").setValue((Object)info);
                    } else if (value instanceof List) {
                        List list = (List)value;
                        EntityInfoCollection info = new EntityInfoCollection(list);
                        WSCompanyDBMappingEditUI.this.tbl.getRow(rowIndex).getCell("dbInstance").setValue((Object)info);
                    }
                }
            }
        });
        this.tbl.getColumn("company").getStyleAttributes().setLocked(true);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int i;
        super.verifyInput(e);
        String number = this.txtNumber.getText();
        if (StringUtils.isEmpty((String)number)) {
            this.txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"numberIsNotNull"));
            SysUtil.abort();
        } else {
            char[] chs = number.trim().toCharArray();
            Pattern p = Pattern.compile("[a-zA-Z_0-9]");
            for (i = 0; i < chs.length; ++i) {
                Matcher m = p.matcher(Character.toString(chs[i]));
                if (m.matches()) continue;
                this.txtNumber.requestFocus(true);
                MsgBox.showInfo((String)EASResource.getString((String)resourceFileName, (String)"onlyCharOANum"));
                SysUtil.abort();
            }
        }
        Object objName = this.txtName.getDefaultLangItemData();
        if (objName == null || StringUtils.isEmpty((String)objName.toString())) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"nameIsNotNull"));
            SysUtil.abort();
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            Object value = row.getCell("dbInstance").getValue();
            if (!(value instanceof IObjectValue)) continue;
            String cellID = ((IObjectValue)value).get("id").toString();
            if (map.containsKey(cellID)) {
                MsgBox.showInfo((String)("\u7b2c" + ((Integer)map.get(cellID) + 1) + "\u884c\u4e0e\u7b2c" + (i + 1) + "\u884c\u6570\u636e\u4e2d\u5fc3\u4e00\u81f4!"));
                SysUtil.abort();
            }
            map.put(cellID, new Integer(i));
        }
    }

    @Override
    protected IObjectValue createNewData() {
        WSCompanyDBMappingInfo info = new WSCompanyDBMappingInfo();
        Object objGroup = this.getUIContext().get("groupInfo");
        if (objGroup instanceof WSCompanyDBMappingGroupInfo) {
            info.setGroup((WSCompanyDBMappingGroupInfo)objGroup);
        }
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return WSCompanyDBMappingFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add("*");
        selectors.add("entry.*");
        selectors.add("entry.dbInstance.id");
        selectors.add("entry.dbInstance.name");
        selectors.add("entry.dbInstance.number");
        return selectors;
    }
}

