/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsDispatchSchemeEntryCollection;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsDispatchSchemeEntryFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsDispatchSchemeEntryInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsDispatchSchemeFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsDispatchSchemeInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsExtractSchemeFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsExtractSchemeInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.client.AbstractWSDispatchLogViewUI;
import com.kingdee.eas.framework.bireport.bimanager.ws.log.WsScheduleLogFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.log.WsSchemeLogCollection;
import com.kingdee.eas.framework.bireport.bimanager.ws.log.WsSchemeLogEntryCollection;
import com.kingdee.eas.framework.bireport.bimanager.ws.log.WsSchemeLogEntryFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.log.WsSchemeLogFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.log.WsSchemeLogInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.MessageDialog;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class WSDispatchLogViewUI
extends AbstractWSDispatchLogViewUI {
    private static final Logger logger = CoreUIObject.getLogger(WSDispatchLogViewUI.class);
    String dispatchID = null;
    volatile int i = 0;

    public void onLoad() throws Exception {
        Object obj = this.getUIContext().get("dispatchID");
        if (obj != null) {
            this.dispatchID = obj.toString();
            this.initControl(this.dispatchID);
        }
        this.txtLogContent.setEditable(false);
        super.onLoad();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void initControl(String dispatchID) throws Exception {
        this.kDContainer1.setEnableActive(false);
        this.kDContainer2.setEnableActive(false);
        this.kDContainer3.setEnableActive(false);
        this.kDContainer4.setEnableActive(false);
        ItemAction[] actions = new ItemAction[]{this.actionAddNew, this.actionView, this.actionEdit, this.actionPrint, this.actionPrintPreview, this.actionLocate, this.actionImportData, this.actionAttachment, this.actionExportData, this.actionToExcel, this.actionStartWorkFlow, this.actionPublishReport, this.actionCancel, this.actionCancelCancel, this.actionQueryScheme};
        for (int i = 0; i < actions.length; ++i) {
            actions[i].setVisible(false);
        }
        this.tblExecute.checkParsed();
        this.tblMain.checkParsed();
        this.tblExecute.getSelectManager().setSelectMode(2);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblExecute.getStyleAttributes().setLocked(true);
        this.tblMain.getStyleAttributes().setLocked(true);
        WsDispatchSchemeInfo disManInfo = WsDispatchSchemeFactory.getRemoteInstance().getWsDispatchSchemeInfo((IObjectPK)new ObjectStringPK(dispatchID));
        if (disManInfo != null) {
            this.txtNumber.setText(disManInfo.getNumber());
            this.txtName.setText(disManInfo.getName());
            this.chkIsRun.setSelected(disManInfo.isIsExecute());
            this.initSchemeList(dispatchID);
        }
        this.tblMain.getColumn("startTime").getStyleAttributes().setNumberFormat("hh:mm:ss");
        this.tblMain.getColumn("endTime").getStyleAttributes().setNumberFormat("hh:mm:ss");
        this.tblExecute.getMergeManager().setMergeMode(3);
    }

    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        this.actionRemove_actionPerformed(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("dispatchSchemeID", (Object)this.dispatchID));
        return f;
    }

    protected void btnquery_actionPerformed(ActionEvent e) throws Exception {
        this.actionQuery_actionPerformed(e);
    }

    public void initSchemeList(String dispatchID) throws Exception {
        WsDispatchSchemeEntryCollection entryColl = WsDispatchSchemeEntryFactory.getRemoteInstance().getWsDispatchSchemeEntryCollection(" where parent.id = '" + dispatchID + "' ");
        ArrayList<WsExtractSchemeInfo> schemeList = new ArrayList<WsExtractSchemeInfo>();
        for (int i = 0; i < entryColl.size(); ++i) {
            WsDispatchSchemeEntryInfo info = entryColl.get(i);
            WsExtractSchemeInfo schemeInfo = WsExtractSchemeFactory.getRemoteInstance().getWsExtractSchemeInfo((IObjectPK)new ObjectStringPK(info.getWsScheme().getId().toString()));
            schemeList.add(schemeInfo);
        }
        this.kdSchemeList.setListData(schemeList.toArray());
    }

    public void initListener() {
        super.initListener();
        this.kdSchemeList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    int selectedRow = KDTableUtil.getSelectedRow((KDTable)WSDispatchLogViewUI.this.tblMain);
                    if (selectedRow < 0) {
                        return;
                    }
                    Object value = WSDispatchLogViewUI.this.tblMain.getRow(selectedRow).getCell("id").getValue();
                    Object obj = WSDispatchLogViewUI.this.kdSchemeList.getSelectedValue();
                    String scheduleLogID = null;
                    if (obj instanceof WsExtractSchemeInfo) {
                        WsExtractSchemeInfo info = (WsExtractSchemeInfo)obj;
                        if (info.get(value.toString()) instanceof WsSchemeLogCollection) {
                            WsSchemeLogCollection collection = (WsSchemeLogCollection)((Object)info.get(value.toString()));
                            WSDispatchLogViewUI.this.initTblExecute(collection);
                            if (collection.size() > 0) {
                                try {
                                    WSDispatchLogViewUI.this.txtLogContent.setText(new String(collection.get(0).getLogEASContext(), "UTF-8"));
                                }
                                catch (UnsupportedEncodingException e1) {
                                    WSDispatchLogViewUI.this.handUIException(e1);
                                }
                            }
                            return;
                        }
                        scheduleLogID = info.getId().toString();
                        try {
                            EntityViewInfo view = new EntityViewInfo();
                            FilterInfo f = new FilterInfo();
                            f.getFilterItems().add(new FilterItemInfo("wsScheduleLogID", value));
                            f.getFilterItems().add(new FilterItemInfo("wsSchemeID", (Object)scheduleLogID));
                            view.setFilter(f);
                            WsSchemeLogCollection collection = WsSchemeLogFactory.getRemoteInstance().getCollection(view);
                            info.put(value.toString(), (Object)collection);
                            WSDispatchLogViewUI.this.initTblExecute(collection);
                            if (collection.size() > 0) {
                                WSDispatchLogViewUI.this.txtLogContent.setText(new String(collection.get(0).getLogEASContext(), "UTF-8"));
                            }
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            logger.error((Object)"error", (Throwable)e1);
                        }
                    }
                }
            }
        });
        this.tblExecute.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int row = KDTableUtil.getSelectedRow((KDTable)WSDispatchLogViewUI.this.tblExecute);
                Object value = WSDispatchLogViewUI.this.tblExecute.getRow(row).getCell("logEngine").getValue();
                if (value == null) {
                    WSDispatchLogViewUI.this.txtLogContent.setText("");
                } else {
                    WSDispatchLogViewUI.this.txtLogContent.setText(value.toString());
                }
            }
        });
        this.tblExecute.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                ++WSDispatchLogViewUI.this.i;
                if (WSDispatchLogViewUI.this.i % 2 == 0) {
                    return;
                }
                if (e.getClickCount() == 2 && e.getType() == 1) {
                    int selectedRow = KDTableUtil.getSelectedRow((KDTable)WSDispatchLogViewUI.this.tblExecute);
                    if (selectedRow < 0) {
                        return;
                    }
                    Object object = WSDispatchLogViewUI.this.tblExecute.getRow(selectedRow).getCell("logException").getValue();
                    String exception = object == null ? "\u65e0\u5f02\u5e38!" : object.toString();
                    MessageDialog.showSQL(exception, "\u5f02\u5e38\u663e\u793a", (Component)((Object)WSDispatchLogViewUI.this));
                    return;
                }
            }
        });
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            int selectedRow = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
            if (selectedRow < 0) {
                return;
            }
            Object object = this.tblMain.getRow(selectedRow).getCell("logException").getValue();
            String exception = object == null ? "\u65e0\u5f02\u5e38!" : object.toString();
            MessageDialog.showSQL(exception, "\u5f02\u5e38\u663e\u793a", (Component)((Object)this));
            return;
        }
        this.txtLogContent.setText(null);
        int selectedRow = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (selectedRow >= 0) {
            Object value = this.tblMain.getRow(selectedRow).getCell("logInfo").getValue();
            this.txtLogContent.setText(value == null ? "" : value.toString());
        }
    }

    public void initTblExecute(WsSchemeLogCollection collection) {
        this.tblExecute.removeRows();
        this.txtLogContent.setText(null);
        if (collection == null) {
            return;
        }
        if (collection.size() == 0) {
            return;
        }
        WsSchemeLogInfo info = collection.get(0);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("parentID", (Object)new Long(info.getId())));
        view.setFilter(f);
        try {
            WsSchemeLogEntryCollection entryCollection = WsSchemeLogEntryFactory.getRemoteInstance().getCollection(view);
            for (int i = 0; i < entryCollection.size(); ++i) {
                IRow row = this.tblExecute.addRow();
                row.getCell("id").setValue((Object)entryCollection.get(i).getId().toString());
                row.getCell("startTime").setValue((Object)entryCollection.get(i).getStartTime());
                row.getCell("endTime").setValue((Object)entryCollection.get(i).getEndTime());
                try {
                    row.getCell("logEngine").setValue((Object)new String(entryCollection.get(i).getLogEngine(), "UTF-8"));
                    if (entryCollection.get(i).getLogException() != null) {
                        row.getCell("logException").setValue((Object)new String(entryCollection.get(i).getLogException(), "UTF-8"));
                    }
                    row.getCell("result").setValue((Object)entryCollection.get(i).getResult().getAlias());
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
    }

    protected void tblMain_doRequestRowSetForHasQueryPK(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSetForHasQueryPK(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rows == null || rows.length <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u884c");
            return;
        }
        if (0 == MsgBox.showConfirm2((Component)((Object)this), (String)"\u662f\u5426\u786e\u8ba4\u5220\u9664?")) {
            HashSet<Object> set = new HashSet<Object>();
            for (int i = 0; i < rows.length; ++i) {
                Object value = this.tblMain.getRow(rows[i]).getCell("id").getValue();
                set.add(value);
            }
            FilterInfo f = new FilterInfo();
            f.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            WsScheduleLogFactory.getRemoteInstance().delete(f);
        }
        this.actionRefresh_actionPerformed(e);
    }

    protected String getEditUIName() {
        return null;
    }
}

