/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.ws.WSEngineInvokeFacadeFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsServiceManagerFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsServiceManagerGroupInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsServiceManagerInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.client.AbstractWsServiceManagerEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WsServiceManagerEditUI
extends AbstractWsServiceManagerEditUI {
    private static final Logger logger = CoreUIObject.getLogger(WsServiceManagerEditUI.class);
    private static final String resourceFileName = "com.kingdee.eas.framework.bireport.bimanager.ws.client.WsClientResource";

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.txtNumber.setRequired(true);
        this.txtName.setRequired(true);
        this.txtUrl.setRequired(true);
        this.txtUser.setRequired(true);
        this.btnTestConn.setIcon(EASResource.getIcon((String)"imgTbtn_chooseout"));
        this.actionTestConn.setVisible(true);
        this.actionTestConn.setEnabled(true);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String url;
        super.verifyInput(e);
        String number = this.txtNumber.getText();
        if (StringUtils.isEmpty((String)number)) {
            this.txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"numberIsNotNull"));
            SysUtil.abort();
        } else {
            char[] chs = number.trim().toCharArray();
            Pattern p = Pattern.compile("[a-zA-Z_0-9]");
            for (int i = 0; i < chs.length; ++i) {
                Matcher m = p.matcher(Character.toString(chs[i]));
                if (m.matches()) continue;
                this.txtNumber.requestFocus(true);
                MsgBox.showInfo((String)EASResource.getString((String)resourceFileName, (String)"onlyCharOANum"));
                SysUtil.abort();
            }
        }
        Object objName = this.txtName.getDefaultLangItemData();
        if (objName == null || StringUtils.isEmpty((String)objName.toString())) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"nameIsNotNull"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)(url = this.txtUrl.getText()))) {
            this.txtUrl.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"URLNotNull"));
            SysUtil.abort();
        }
    }

    @Override
    protected IObjectValue createNewData() {
        WsServiceManagerInfo info = new WsServiceManagerInfo();
        Object objGroup = this.getUIContext().get("groupInfo");
        if (objGroup instanceof WsServiceManagerGroupInfo) {
            info.setGroup((WsServiceManagerGroupInfo)objGroup);
        }
        return info;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        return sic;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return WsServiceManagerFactory.getRemoteInstance();
    }

    @Override
    public void actionTestConn_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        WSEngineInvokeFacadeFactory.getRemoteInstance().getDBList(this.txtUrl.getText(), this.txtUser.getText(), this.txtPsw.getText());
        MsgBox.showInfo((Component)((Object)this), (String)"Web Service \u63d0\u4f9b\u8005\u8bbe\u7f6e\u6210\u529f");
    }
}

