/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.engine;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.CallBackHandler;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.PageDataStoreHandler;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.RequestHandler;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.ResponseHandler;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.Task;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.WebServiceLogger;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.domain.ret.ExceptionResult;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.domain.ret.Result;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.PriorityBlockingQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;

public class TaskManager {
    private static Logger logger = Logger.getLogger(TaskManager.class);
    private PriorityBlockingQueue requestQueue = new PriorityBlockingQueue();
    private PriorityBlockingQueue responseQueue = new PriorityBlockingQueue();
    private Map cbMap = new ConcurrentReaderHashMap();
    private final Object requestStartEvent = new Object();
    private final Object responseEndEvent = new Object();
    private final Object terminalEvent = new Object();
    private volatile boolean terminal = false;
    private volatile boolean running = false;
    private volatile boolean doTerminal = false;
    private ExecutorService requestExecutor;
    private ExecutorService responseExecutor;
    private RequestHandler requestHandler;
    private ResponseHandler responseHandler;
    private PageDataStoreHandler pageDataStoreHandler;

    public TaskManager() {
        this(10, 5);
    }

    public TaskManager(int requestPoolSize, int responsePoolSize) {
        this.requestExecutor = Executors.newFixedThreadPool((int)requestPoolSize);
        this.responseExecutor = Executors.newFixedThreadPool((int)responsePoolSize);
    }

    public PageDataStoreHandler getPageDataStoreHandler() {
        return this.pageDataStoreHandler;
    }

    public void setPageDataStoreHandler(PageDataStoreHandler pageDataStoreHandler) {
        this.pageDataStoreHandler = pageDataStoreHandler;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    public ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public void setResponseHandler(ResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminal() {
        this.doTerminal = true;
        Object object = this.requestStartEvent;
        synchronized (object) {
            this.requestStartEvent.notifyAll();
        }
        while (!this.terminal) {
            try {
                object = this.terminalEvent;
                synchronized (object) {
                    this.terminalEvent.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void addTask(Task task) {
        this.addTask(task, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Task task, CallBackHandler cb) {
        this.requestQueue.add((Object)task);
        if (cb != null) {
            this.cbMap.put(task, cb);
        }
        Object object = this.requestStartEvent;
        synchronized (object) {
            this.requestStartEvent.notifyAll();
        }
    }

    public void cancelTask(Task task) {
        this.requestQueue.remove((Object)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task waitForResponseTask(long sessionId, long taskId, long requestId, long timeout) {
        long ts = System.currentTimeMillis();
        Task task = null;
        do {
            if ((task = this.receiveResponseTask(sessionId, taskId, requestId)) != null) continue;
            if (timeout > 0L && System.currentTimeMillis() - ts >= timeout) break;
            Object object = this.responseEndEvent;
            synchronized (object) {
                try {
                    this.responseEndEvent.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (task == null && !this.terminal);
        return task;
    }

    private Task receiveResponseTask(long sessionId, long taskId, long requestId) {
        for (Task task : this.responseQueue) {
            if (task.getRequestId() != requestId || task.getTaskId() != taskId || task.getSessionId() != sessionId) continue;
            this.responseQueue.remove((Object)task);
            return task;
        }
        return null;
    }

    public void startServer() {
        logger.info((Object)"\u542f\u52a8\u4efb\u52a1\u5904\u7406\u5668.");
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TaskManager.this.running = true;
                while (!TaskManager.this.terminal) {
                    Object object;
                    while (TaskManager.this.requestQueue.size() > 0) {
                        Task task = (Task)TaskManager.this.requestQueue.poll();
                        TaskManager.this.dealWithTask(task);
                    }
                    try {
                        object = TaskManager.this.requestStartEvent;
                        synchronized (object) {
                            TaskManager.this.requestStartEvent.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!TaskManager.this.doTerminal) continue;
                    logger.info((Object)"\u505c\u6b62\u4efb\u52a1\u5904\u7406\u5668...");
                    TaskManager.this.requestExecutor.shutdown();
                    TaskManager.this.responseExecutor.shutdown();
                    TaskManager.this.cbMap.clear();
                    TaskManager.this.requestQueue.clear();
                    TaskManager.this.responseQueue.clear();
                    TaskManager.this.terminal = true;
                    object = TaskManager.this.responseEndEvent;
                    synchronized (object) {
                        TaskManager.this.responseEndEvent.notifyAll();
                    }
                    object = TaskManager.this.terminalEvent;
                    synchronized (object) {
                        TaskManager.this.terminalEvent.notifyAll();
                    }
                    logger.info((Object)"\u4efb\u52a1\u5904\u7406\u5668\u5df2\u505c\u6b62\u3002");
                    break;
                }
                TaskManager.this.running = false;
            }
        }.start();
        while (!this.running) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void dealResponse(final Task task) {
        this.responseExecutor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WebServiceLogger.logTask(task, "\u5904\u7406\u5e94\u7b54\u3002");
                if (TaskManager.this.responseHandler.process(task)) {
                    CallBackHandler cb = (CallBackHandler)TaskManager.this.cbMap.get(task);
                    if (cb != null) {
                        Object data;
                        Result ret = task.getResult();
                        Object object = data = ret == null ? null : ret.getData();
                        if (data instanceof Exception) {
                            cb.error(task, (Exception)data);
                        } else {
                            cb.success(task, data);
                        }
                        TaskManager.this.cbMap.remove(cb);
                    }
                    TaskManager.this.responseQueue.add((Object)task);
                    Object object = TaskManager.this.responseEndEvent;
                    synchronized (object) {
                        TaskManager.this.responseEndEvent.notifyAll();
                    }
                }
            }
        });
    }

    private void dealWithTask(final Task task) {
        WebServiceLogger.logTask(task, "\u63d0\u4ea4\u4efb\u52a1\u3002");
        this.requestExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    WebServiceLogger.logTask(task, "\u5904\u7406\u8bf7\u6c42\u3002");
                    Result ret = TaskManager.this.requestHandler.process(task);
                    task.setResult(ret);
                }
                catch (AxisFault e) {
                    Exception ex = new Exception("[" + task.getMethod().getName() + "]" + e.getMessage());
                    ex.setStackTrace(e.getStackTrace());
                    task.setResult(new ExceptionResult(ex));
                }
                catch (Exception e) {
                    if (e instanceof InvocationTargetException) {
                        Throwable t = ((InvocationTargetException)e).getTargetException();
                        e = t instanceof Exception ? (Exception)t : new Exception(t);
                    }
                    task.setResult(new ExceptionResult(e));
                }
                TaskManager.this.dealResponse(task);
            }
        });
    }
}

