/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.schedule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.framework.bireport.bimanager.InvokeResultEnum;
import com.kingdee.eas.framework.bireport.bimanager.util.DBConnectionTypeInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsExtractSchemeInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.CallBackHandler;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.Task;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.domain.WSPageData;
import com.kingdee.eas.framework.bireport.bimanager.ws.log.WsSchemeLogEntryFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.log.WsSchemeLogEntryInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.schedule.WSDispatchCallBackImpl;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.ConnectODsMapProvider;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.DBTableStructHelper;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.InsertDatas;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.JDBCODSTemplate;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WebServiceCallBackHandler
implements CallBackHandler {
    private WsExtractSchemeInfo scheme;
    private Context ctx;
    private WSDispatchCallBackImpl callBack;
    private long parentID;
    private java.util.Date startTime;
    private InvokeResultEnum item;
    private Object lockForHandle;
    private String fUrgeCompanyID;
    private String fwsfactDataID;
    private Map conns;
    Date now = new Date(new java.util.Date().getTime());

    public WebServiceCallBackHandler(Context ctx, WsExtractSchemeInfo wsScheme, WSDispatchCallBackImpl callback, java.util.Date date, long id, String wsfactDataID, Map conns) {
        this.ctx = ctx;
        this.scheme = wsScheme;
        this.callBack = callback;
        this.startTime = date;
        this.parentID = id;
        this.lockForHandle = this.callBack.lockForHandle;
        this.fwsfactDataID = wsfactDataID;
        callback.clearException();
        callback.enginelog = new StringBuffer();
        this.fUrgeCompanyID = this.scheme.getCompany() == null ? null : this.scheme.getCompany().getId().toString();
        this.conns = conns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void error(Task task, Exception e) {
        this.item = InvokeResultEnum.FAIL;
        this.callBack.addException(e);
        this.saveLogEntry();
        Object object = this.lockForHandle;
        synchronized (object) {
            this.lockForHandle.notify();
        }
    }

    public void saveLogEntry() {
        WsSchemeLogEntryInfo info = new WsSchemeLogEntryInfo();
        info.setStartTime(new Timestamp(this.startTime.getTime()));
        info.setEndTime(new Timestamp(new java.util.Date().getTime()));
        info.setParentID(this.parentID);
        try {
            info.setLogEngine(this.callBack.enginelog.toString().getBytes("UTF-8"));
            info.setLogException(this.callBack.getException().getMessage().getBytes("UTF-8"));
            info.setResult(this.item);
            WsSchemeLogEntryFactory.getLocalInstance(this.ctx).addnew(info);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void success(Task task, Object data) {
        if (!(data instanceof Iterator)) {
            return;
        }
        Iterator iter = (Iterator)data;
        if (!iter.hasNext()) {
            return;
        }
        boolean isFirst = true;
        String schemeID = this.scheme.getBIProjectScheme().getId().toString();
        String odsTblName = null;
        try {
            odsTblName = this.scheme.getODSStoreTable(this.ctx);
            this.scheme.setExtendedProperty("odsStoreTable", odsTblName);
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        ConnectODsMapProvider provider = new ConnectODsMapProvider(this.ctx, this.conns, schemeID);
        List alterTableSqls = new LinkedList();
        boolean datePK = this.scheme.isDatePK();
        Map<String, Object> dateMap = null;
        if (datePK) {
            Object obj = this.scheme.get("dateTimePkInfoMap");
            if (obj == null) {
                dateMap = new HashMap();
                this.scheme.put("dateTimePkInfoMap", dateMap);
            } else {
                dateMap = (Map)obj;
            }
            int pkSize = this.scheme.pkSize();
            for (int i = 0; i < pkSize; ++i) {
                String type = this.scheme.getPKType(i);
                if (!"DateTime".equalsIgnoreCase(type)) continue;
                dateMap.put(this.scheme.getPKFied(i).toUpperCase(), null);
            }
        }
        if (dateMap == null) {
            dateMap = new HashMap();
        }
        String insertSQL = null;
        while (iter.hasNext()) {
            WSPageData pageData = (WSPageData)iter.next();
            if (!pageData.next()) {
                this.callBack.logInfo("\u672a\u62bd\u53d6\u5230\u6570\u636e");
                continue;
            }
            try {
                if (isFirst) {
                    DBConnectionTypeInfo info = new DBConnectionTypeInfo();
                    info.conn = provider.getConnection();
                    info.type = provider.getDBType();
                    Map columnKey_typ = DBTableStructHelper.getTableColumnKey_Type(info, odsTblName);
                    alterTableSqls = DBTableStructHelper.alterTableSql(pageData, odsTblName, columnKey_typ);
                    insertSQL = InsertDatas.getInsertSql(pageData, odsTblName);
                    try {
                        JDBCODSTemplate.executeBatch(provider.getConnection(), alterTableSqls);
                    }
                    catch (Exception e1) {
                        this.error(task, e1);
                        return;
                    }
                }
                isFirst = false;
                LinkedList sqlParams = new LinkedList();
                InsertDatas.getSqlParams(pageData, this.now, this.fUrgeCompanyID, this.fwsfactDataID, sqlParams, dateMap);
                try {
                    JDBCODSTemplate.executeBatch(provider.getConnection(), insertSQL, sqlParams);
                }
                catch (Exception e) {
                    String sql = "delete " + odsTblName + " where FwsfactDataID='" + this.fwsfactDataID + "'";
                    JDBCODSTemplate.execute(provider.getConnection(), sql, null);
                    this.error(task, e);
                    return;
                }
            }
            catch (Exception e) {
                this.error(task, e);
                return;
            }
        }
        this.callBack.logInfo("\u62bd\u53d6\u65b9\u6848\u6267\u884c\u6210\u529f!");
        this.item = InvokeResultEnum.SUCCESS;
        this.saveLogEntry();
        Object object = this.lockForHandle;
        synchronized (object) {
            this.lockForHandle.notify();
        }
    }
}

