/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.IResultSetHandle;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;

public abstract class JDBCEASTemplate {
    public static Object executeQuery(Context ctx, String sql, SqlParams sp, IResultSetHandle handle) throws Exception {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(sql);
            if (sp != null) {
                sp.putToStatement(statement);
            }
            rs = statement.executeQuery();
            Object object = handle.handle(rs);
            return object;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RptRowSet executeQuery(Context ctx, String sql, SqlParams sp) throws Exception {
        try (Connection conn = null;){
            conn = EJBFactory.getConnection((Context)ctx);
            RptRowSet rptRowSet = DBUtil.executeQuery((String)sql, (Connection)conn);
            return rptRowSet;
        }
    }

    public static boolean hasResultSet(Context ctx, String sql, SqlParams sp) throws Exception {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(sql);
            if (sp != null) {
                sp.putToStatement(statement);
            }
            rs = statement.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(Context ctx, String sql, SqlParams sp) throws Exception {
        Connection conn = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(sql);
            if (sp != null) {
                sp.putToStatement((PreparedStatement)statement);
            }
            boolean bl = statement.execute();
            return bl;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeBatch(Context ctx, List sqls) throws Exception {
        if (sqls == null || sqls.size() == 0) {
            return;
        }
        Connection conn = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            int index = 1;
            int n = sqls.size();
            for (int i = 0; i < n; ++i) {
                statement.addBatch(sqls.get(i).toString());
                if (i != n - 1 && ++index % 1000 != 0) continue;
                statement.executeBatch();
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void executeBatch(Context ctx, String sql, List sqlParams) throws Exception {
        if (sqlParams == null || sqlParams.size() == 0) {
            return;
        }
        Connection conn = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(sql);
            int index = 1;
            int n = sqlParams.size();
            for (int i = 0; i < n; ++i) {
                ++index;
                Object object = sqlParams.get(i);
                if (!(object instanceof SqlParams)) continue;
                SqlParams sp = (SqlParams)object;
                sp.putToStatement((PreparedStatement)statement);
                statement.addBatch();
                if (i != n - 1 && index % 1000 != 0) continue;
                statement.executeBatch();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }
}

