/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.util;

import com.kingdee.eas.framework.bireport.bimanager.util.DebugForHL;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.IConnectionProvider;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.IResultSetHandle;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;

public abstract class JDBCTemplate {
    public static Object executeQuery(IConnectionProvider provider, String sql, SqlParams sp, IResultSetHandle handle) throws Exception {
        DebugForHL.info("jdbcTemplate executeQuery sql=" + sql);
        Connection conn = provider.getConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.prepareStatement(sql);
            if (sp != null) {
                sp.putToStatement(statement);
            }
            rs = statement.executeQuery();
            Object object = handle.handle(rs);
            return object;
        }
        catch (Exception e) {
            DebugForHL.info("jdbcTemplate executeQuery e=" + e.getMessage());
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RptRowSet executeQuery(IConnectionProvider provider, String sql, SqlParams sp) throws Exception {
        DebugForHL.info("jdbcTemplate executeQuery sql=" + sql);
        try {
            RptRowSet rptRowSet = DBUtil.executeQuery((String)sql, (Connection)provider.getConnection());
            return rptRowSet;
        }
        finally {
            provider.close();
        }
    }

    public static boolean hasResultSet(IConnectionProvider provider, String sql, SqlParams sp) throws Exception {
        DebugForHL.info("jdbcTemplate hasResultSet sql=" + sql);
        Connection conn = provider.getConnection();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.prepareStatement(sql);
            if (sp != null) {
                sp.putToStatement(statement);
            }
            rs = statement.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
        catch (Exception e) {
            DebugForHL.info("jdbcTemplate execute  hasResultSet sql=" + e.getMessage());
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(IConnectionProvider provider, String sql, SqlParams sp) throws Exception {
        DebugForHL.info("jdbcTemplate execute sql=" + sql);
        Connection conn = provider.getConnection();
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(sql);
            if (sp != null) {
                sp.putToStatement(statement);
            }
            boolean bl = statement.execute();
            return bl;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeBatch(IConnectionProvider provider, List sqls) throws Exception {
        if (sqls == null || sqls.size() == 0) {
            return;
        }
        Connection conn = provider.getConnection();
        Statement statement = null;
        try {
            statement = conn.createStatement();
            int index = 1;
            int n = sqls.size();
            for (int i = 0; i < n; ++i) {
                DebugForHL.info("\u66f4\u65b0\u8868\u7ed3\u6784" + sqls.get(i));
                statement.addBatch(sqls.get(i).toString());
                if (i != n - 1 && ++index % 1000 != 0) continue;
                statement.executeBatch();
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            provider.close();
        }
    }

    public static void executeBatch(IConnectionProvider provider, String sql, List sqlParams) throws Exception {
        if (sqlParams == null || sqlParams.size() == 0) {
            return;
        }
        Connection conn = provider.getConnection();
        Statement statement = null;
        try {
            DebugForHL.info("\u6279\u91cf\u63d2\u5165" + sql);
            DebugForHL.info("\u6279\u91cf\u63d2\u5165\u6761\u76ee" + sqlParams.size());
            statement = conn.prepareStatement(sql);
            int index = 1;
            int n = sqlParams.size();
            for (int i = 0; i < n; ++i) {
                ++index;
                Object object = sqlParams.get(i);
                if (!(object instanceof SqlParams)) continue;
                SqlParams sp = (SqlParams)object;
                sp.putToStatement((PreparedStatement)statement);
                statement.addBatch();
                if (i != n - 1 && index % 1000 != 0) continue;
                statement.executeBatch();
            }
        }
        catch (Exception e) {
            DebugForHL.info("\u6279\u91cf\u63d2\u5165\u6267\u884c\u9519\u8bef." + e.getMessage());
            throw e;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            provider.close();
        }
    }
}

