/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bim.rpt.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.AbstractMetaDataCtrl;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.mdquery.MDQueryInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.report.BIMRptCompress;
import com.kingdee.bos.metadata.report.BIMRptQueryStorage;
import com.kingdee.bos.metadata.report.BIMRptStorage;
import com.kingdee.bos.metadata.report.ReportInfo;
import com.kingdee.bos.metadata.report.TemplateCollection;
import com.kingdee.bos.metadata.report.TemplateInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.bim.rpt.IBIMReportService;
import com.kingdee.eas.bim.rpt.client.util.BIMReportServiceFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Blob;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.help.UnsupportedOperationException;
import org.apache.log4j.Logger;
import org.jdom.JDOMException;

public class BIMCommonReportUtil {
    public static final String BIM_RPT_DIR = "bimrpt";
    public static final String POSTFIX_PROPERTIES = ".properties";
    public static final String POSTFIX_QUERY = ".query";
    public static final String POSTFIX_REPORT = ".report";
    public static final String POSTFIX_KDF = ".kdf";
    public static final String POSTFIX_KDT = ".kdt";
    public static final String POSTFIX_KMD = ".kmd";
    public static final String POSTFIX_MDQUERY = ".mdquery";
    public static final int REPORT_TYPE_COMMON = 0;
    public static final int REPORT_TYPE_MD = 1;
    public static final String BIM_COMMON_RPT_PATH = "BIMCommonRptPath";
    public static final String BIM_COMMON_RPT_PK = "BIMCommonRptPK";
    public static final String BIM_MAIN_QUERY = "BIMMainQuery";
    public static final String BIM_SEL_ENTITY_INFO = "BIMSelEntityInfo";
    public static final String BIM_MAIN_QUERY_PK = "BIMMainQueryPK";
    public static final String BIM_REPORT_INFO = "BIMReportInfo";
    public static final String BIM_REPORT_ORG_TYPE = "OrgType";
    public static final String PERMISSION_ONLOAD = "actionOnLoad";
    public static final String PERMISSION_PRINTPREVIEW = "actionPrintPreview";
    public static final String PERMISSION_PRINT = "actionPrint";
    public static final String PERMISSION_FORM_PRINTPREVIEW = "actionFormPrintPreview";
    public static final String PERMISSION_FORM_PRINT = "actionFormPrint";
    public static final String PERMISSION_FORM_SET = "actionFormSet";
    public static final String CTRL_UNIT = "com.kingdee.eas.basedata.org.app.CtrlUnit";
    public static final String QUERY_TYPE_JOIN = "0";
    public static final String QUERY_TYPE_UNION = "1";
    private static Logger logger = Logger.getLogger(BIMCommonReportUtil.class);

    private BIMCommonReportUtil() {
    }

    public static IRowSet getReport(String reportPK) throws BOSException {
        IBIMReportService service = BIMReportServiceFactory.getRemoteInstance();
        return service.getReport(reportPK);
    }

    public static IRowSet getQuery(String reportPK) throws BOSException {
        IBIMReportService service = BIMReportServiceFactory.getRemoteInstance();
        return service.getQuery(reportPK);
    }

    public static IRowSet getTemplates(String reportPK) throws BOSException {
        IBIMReportService service = BIMReportServiceFactory.getRemoteInstance();
        return service.getTemplates(reportPK);
    }

    public static IRowSet getAllTimeStamp(String reportPK) throws BOSException {
        IBIMReportService service = BIMReportServiceFactory.getRemoteInstance();
        return service.getAllTimeStamp(reportPK);
    }

    public static IRowSet getQueryPKs(String reportPK) throws BOSException {
        IBIMReportService service = BIMReportServiceFactory.getRemoteInstance();
        return service.getQueryPKs(reportPK);
    }

    public static void saveKMDTemplates(String reportPK, HashMap kmdTpl) throws BOSException {
        IBIMReportService service = BIMReportServiceFactory.getRemoteInstance();
        service.saveKMDTemplates(reportPK, kmdTpl);
    }

    public static void saveReport(String reportPK, byte[] report, byte[] query) throws BOSException {
        IBIMReportService service = BIMReportServiceFactory.getRemoteInstance();
        service.setReport(reportPK, report, query);
    }

    public static void injectServerQuery(String reportPK) throws BOSException {
        IBIMReportService service = BIMReportServiceFactory.getRemoteInstance();
        service.loadQuery(reportPK);
    }

    public static void injectServerMDQuery(String reportPK) throws BOSException {
        IBIMReportService service = BIMReportServiceFactory.getRemoteInstance();
        service.loadMDQuery(reportPK);
    }

    public static void initMetaDataLoader() {
        String metaDataPath = MetaDataLoaderFactory.getClientMetaDataPath();
        logger.debug((Object)("\u5ba2\u6237\u7aef\u5143\u6570\u636e\u76ee\u5f55\uff1a" + metaDataPath));
        if (metaDataPath == null) {
            metaDataPath = UIConfig.getMetaDataDir();
        }
        if (metaDataPath == null) {
            logger.warn((Object)"Client metadatapath null!");
        } else {
            File metaDataFile = new File(metaDataPath);
            if (metaDataFile.exists()) {
                logger.debug((Object)("Client metadatapath : " + metaDataPath));
                MetaDataLoaderFactory.setClientMetaDataPath((String)metaDataPath);
            } else {
                logger.warn((Object)("Can't find metadata : " + metaDataPath));
            }
        }
    }

    public static Context getBOSContext() {
        String clientMetaDataPath = MetaDataLoaderFactory.getClientMetaDataPath();
        Context bosCtx = new Context();
        bosCtx.put((Object)"METADATAPATH", (Object)clientMetaDataPath);
        return bosCtx;
    }

    public static ReportInfo injectClientReportInfo(String dirRoot, String reportPK) throws BOSException, FileNotFoundException {
        AbstractMetaDataCtrl objCtrl = (AbstractMetaDataCtrl)BOSObjectFactory.createBOSObject((Context)BIMCommonReportUtil.getBOSContext(), (BOSObjectType)MetaDataTypeList.REPORT);
        FileInputStream is = new FileInputStream(dirRoot + "/" + BIMCommonReportUtil.formatPKString(reportPK) + POSTFIX_REPORT);
        IObjectValue obj = objCtrl.load((InputStream)is);
        return (ReportInfo)obj;
    }

    public static MDQueryInfo injectClientMDQuery(String dirRoot, ReportInfo rptInfo) throws BOSException, FileNotFoundException {
        String mdQueryPK = rptInfo.getQueryPK();
        AbstractMetaDataCtrl objCtrl = (AbstractMetaDataCtrl)BOSObjectFactory.createBOSObject((Context)BIMCommonReportUtil.getBOSContext(), (BOSObjectType)MetaDataTypeList.MDQUERY);
        FileInputStream is = new FileInputStream(dirRoot + "/" + BIMCommonReportUtil.formatPKString(mdQueryPK) + POSTFIX_MDQUERY);
        IObjectValue obj = objCtrl.load((InputStream)is);
        return (MDQueryInfo)obj;
    }

    public static QueryInfo injectClientQuery(String dirRoot, String queryPK, String queryType) throws Exception {
        logger.debug((Object)("\u6ce8\u5165\u524d\u5143\u6570\u636ePK:" + queryPK));
        AbstractMetaDataCtrl objCtrl = (AbstractMetaDataCtrl)BOSObjectFactory.createBOSObject((Context)BIMCommonReportUtil.getBOSContext(), (BOSObjectType)MetaDataTypeList.BASEQUERY);
        String fileName = dirRoot + "/" + BIMCommonReportUtil.formatPKString(queryPK) + POSTFIX_QUERY;
        FileInputStream is = new FileInputStream(fileName);
        if (objCtrl == null) {
            throw new NullPointerException("MetaDataCtrl is null, inject client query failed!");
        }
        IObjectValue obj = objCtrl.load((InputStream)is);
        logger.debug((Object)("\u6ce8\u5165\u540e\u5143\u6570\u636ePK:" + ((QueryInfo)obj).getFullName()));
        ((InputStream)is).close();
        return (QueryInfo)obj;
    }

    public static ArrayList injectAllClientQuery(String dirRoot, String reportPK) throws Exception {
        ArrayList<QueryInfo> list = new ArrayList<QueryInfo>();
        IRowSet rsQuery = BIMCommonReportUtil.getQueryPKs(reportPK);
        rsQuery.absolute(1);
        String queryPKs = rsQuery.getString("FQueryPKs");
        if (queryPKs == null || queryPKs.trim().equals("")) {
            return list;
        }
        String[] arrPKs = StringUtils.split((String)queryPKs, (String)",");
        QueryInfo query = null;
        int n = arrPKs.length;
        for (int i = 0; i < n; ++i) {
            if (arrPKs[i].trim().length() == 0) continue;
            String[] items = StringUtils.split((String)arrPKs[i], (String)"|");
            query = BIMCommonReportUtil.injectClientQuery(dirRoot, items[0], items[1]);
            list.add(query);
        }
        return list;
    }

    public static ReportInfo syncLocalMetadata(String reportPK, String dirRoot, int rptType) throws Exception {
        IRowSet rsTime = BIMCommonReportUtil.getAllTimeStamp(reportPK);
        if (rsTime.size() == 0) {
            throw new NullPointerException();
        }
        rsTime.absolute(1);
        Timestamp rptTime = rsTime.getTimestamp("FTimeStamp");
        Timestamp queryTime = rsTime.getTimestamp("FQTimeStamp");
        File file = new File(dirRoot + "/" + BIMCommonReportUtil.getPKDir(reportPK));
        if (!file.exists()) {
            file.mkdirs();
        }
        ReportInfo rptInfo = null;
        file = new File(dirRoot + "/" + BIMCommonReportUtil.formatPKString(reportPK) + POSTFIX_REPORT);
        if (!file.exists()) {
            Blob blob;
            IRowSet rsRpt = BIMCommonReportUtil.getReport(reportPK);
            rsRpt.absolute(1);
            byte[] contentData = null;
            byte[] queryData = null;
            Object content = rsRpt.getObject("FContent");
            Object query = rsRpt.getObject("FQuery");
            if (content instanceof Blob) {
                blob = (Blob)content;
                contentData = blob.getBytes(1L, (int)blob.length());
            } else if (content instanceof byte[]) {
                contentData = (byte[])content;
            } else {
                throw new UnsupportedOperationException("Not support this db type!");
            }
            if (query instanceof Blob) {
                blob = (Blob)query;
                queryData = blob.getBytes(1L, (int)blob.length());
            } else if (query instanceof byte[]) {
                queryData = (byte[])query;
            } else {
                throw new UnsupportedOperationException("Not support this db type!");
            }
            BIMCommonReportUtil.saveTemplateFiles(dirRoot, contentData);
            BIMCommonReportUtil.saveQueryFiles(dirRoot, queryData);
            try {
                rptInfo = BIMCommonReportUtil.injectClientReportInfo(dirRoot, reportPK);
                BIMCommonReportUtil.createRptProperties(dirRoot, reportPK, rptTime.getTime(), queryTime.getTime(), rptInfo, rptType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Blob blob;
            FileInputStream stream = new FileInputStream(dirRoot + "/" + BIMCommonReportUtil.formatPKString(reportPK) + POSTFIX_PROPERTIES);
            Properties p = new Properties();
            p.load(stream);
            if (!p.getProperty("reportTime").equals(String.valueOf(rptTime.getTime()))) {
                IRowSet rsTpls = BIMCommonReportUtil.getTemplates(reportPK);
                rsTpls.absolute(1);
                Object content = rsTpls.getObject("FContent");
                byte[] contentData = null;
                if (content instanceof Blob) {
                    blob = (Blob)content;
                    contentData = blob.getBytes(1L, (int)blob.length());
                } else if (content instanceof byte[]) {
                    contentData = (byte[])content;
                } else {
                    throw new UnsupportedOperationException("Not support this db type!");
                }
                BIMCommonReportUtil.saveTemplateFiles(dirRoot, contentData);
                try {
                    rptInfo = BIMCommonReportUtil.injectClientReportInfo(dirRoot, reportPK);
                    BIMCommonReportUtil.createRptProperties(dirRoot, reportPK, rptTime.getTime(), queryTime.getTime(), rptInfo, rptType);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!p.getProperty("queryTime").equals(String.valueOf(queryTime.getTime()))) {
                IRowSet rsQuery = BIMCommonReportUtil.getQuery(reportPK);
                rsQuery.absolute(1);
                Object query = rsQuery.getObject("FQuery");
                byte[] queryData = null;
                if (query instanceof Blob) {
                    blob = (Blob)query;
                    queryData = blob.getBytes(1L, (int)blob.length());
                } else if (query instanceof byte[]) {
                    queryData = (byte[])query;
                } else {
                    throw new UnsupportedOperationException("Not support this db type!");
                }
                BIMCommonReportUtil.saveQueryFiles(dirRoot, queryData);
            }
            ((InputStream)stream).close();
        }
        rsTime.close();
        if (rptInfo == null) {
            rptInfo = BIMCommonReportUtil.injectClientReportInfo(dirRoot, reportPK);
        }
        return rptInfo;
    }

    public static void saveTemplateFiles(String dirRoot, byte[] templates) {
        BIMRptStorage rptObj = BIMRptCompress.upZipReport((byte[])templates);
        HashMap manifest = rptObj.getManifest();
        HashMap formTemplates = rptObj.getFormTemplates();
        HashMap tableTemplate = rptObj.getTableTemplate();
        HashMap mdQueryTemplate = rptObj.getMDQueryTemplate();
        HashMap kmdTemplates = rptObj.getKMDTemplates();
        try {
            BIMCommonReportUtil.createFile(dirRoot, manifest, POSTFIX_REPORT);
            BIMCommonReportUtil.createFile(dirRoot, formTemplates, POSTFIX_KDF);
            BIMCommonReportUtil.createFile(dirRoot, tableTemplate, POSTFIX_KDT);
            BIMCommonReportUtil.createFile(dirRoot, mdQueryTemplate, POSTFIX_MDQUERY);
            BIMCommonReportUtil.createFile(dirRoot, kmdTemplates, POSTFIX_KMD);
            logger.debug((Object)"\u62a5\u8868\u6587\u4ef6\u5df2\u540c\u6b65\u672c\u5730\u5b8c\u6bd5\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        rptObj = null;
        manifest = null;
        formTemplates = null;
        tableTemplate = null;
    }

    public static void saveQueryFiles(String dirRoot, byte[] queries) {
        BIMRptQueryStorage queryObj = BIMRptCompress.upZipQuery((byte[])queries);
        HashMap query = queryObj.getQuery();
        try {
            BIMCommonReportUtil.createFile(dirRoot, query, POSTFIX_QUERY);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        queryObj = null;
        query = null;
    }

    public static void createFile(String dirRoot, HashMap item, String postfix) throws IOException {
        if (item == null) {
            return;
        }
        Set keySet = item.keySet();
        Object[] keys = keySet.toArray();
        logger.debug((Object)"\u6b63\u5728\u521b\u5efa\u672c\u5730\u6587\u4ef6...");
        for (Object key : keys) {
            byte[] content = (byte[])item.get(key);
            String fileName = dirRoot + "/" + BIMCommonReportUtil.formatPKString(key.toString()) + postfix;
            File file = new File(dirRoot + "/" + BIMCommonReportUtil.getPKDir(key.toString()));
            if (!file.exists()) {
                file.mkdirs();
            }
            FileOutputStream fout = new FileOutputStream(fileName);
            fout.write(content);
            fout.close();
            logger.debug((Object)(fileName + "\u5df2\u7ecf\u521b\u5efa\u6210\u529f\uff01"));
        }
    }

    private static void createRptProperties(String dirRoot, String reportPK, long rptTime, long queryTime, ReportInfo rptInfo, int rptType) throws JDOMException, IOException {
        String fileName = dirRoot + "/" + BIMCommonReportUtil.formatPKString(reportPK) + POSTFIX_PROPERTIES;
        String userConfig = "";
        File file = new File(fileName);
        boolean flag = false;
        if (file.exists()) {
            flag = true;
            userConfig = BIMCommonReportUtil.getUserConfig(fileName);
        }
        FileOutputStream fout = new FileOutputStream(fileName);
        PrintStream out = new PrintStream(fout);
        out.println("reportTime=" + rptTime);
        out.println("queryTime=" + queryTime);
        if (flag) {
            out.println(userConfig);
        } else {
            SysContext ctx = SysContext.getSysContext();
            String userName = ctx.getCurrentUserInfo().getName();
            out.print(userName);
            out.print(".default=");
            String defaultTpl = rptType == 0 ? BIMCommonReportUtil.getDefaultFormTemplate(dirRoot, reportPK, rptInfo) : "";
            out.println(defaultTpl);
        }
        out.close();
        fout.close();
    }

    private static String getUserConfig(String filePath) {
        StringBuffer sb = new StringBuffer();
        try {
            RandomAccessFile file = new RandomAccessFile(filePath, "r");
            long filePointer = 0L;
            long length = file.length();
            while (filePointer < length) {
                String s = file.readLine();
                if (s.indexOf("reportTime=") == -1 && s.indexOf("queryTime=") == -1) {
                    sb.append(s).append("\n");
                }
                filePointer = file.getFilePointer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString().trim();
    }

    public static String getDefaultFormTemplate(String dirRoot, String reportPK, ReportInfo rptInfo) throws JDOMException, IOException {
        TemplateCollection templates = rptInfo.getFormTemplates();
        String formName = "";
        int n = templates.size();
        for (int i = 0; i < n; ++i) {
            TemplateInfo template = templates.get(i);
            if (!template.isDefault()) continue;
            formName = template.getName();
            break;
        }
        if (formName == "" && templates.size() > 0) {
            formName = templates.get(0).getName();
        }
        return formName;
    }

    public static String getUserDefaultFormTemplate(String dirRoot, String reportPK) {
        String propertiesFile = dirRoot + "/" + BIMCommonReportUtil.formatPKString(reportPK) + POSTFIX_PROPERTIES;
        Properties p = new Properties();
        try {
            FileInputStream stream = new FileInputStream(propertiesFile);
            p.load(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        String userName = SysContext.getSysContext().getCurrentUserInfo().getName();
        String key = userName + ".default";
        return p.getProperty(key);
    }

    public static String setDefaultFormTemplate(String dirRoot, String reportPK, String templateName, ReportInfo rptInfo) throws JDOMException, IOException {
        String retValue;
        String propertiesFile = dirRoot + "/" + BIMCommonReportUtil.formatPKString(reportPK) + POSTFIX_PROPERTIES;
        FileInputStream stream = new FileInputStream(propertiesFile);
        Properties p = new Properties();
        p.load(stream);
        String userName = SysContext.getSysContext().getCurrentUserInfo().getName();
        String key = userName + ".default";
        String keyValue = p.getProperty(key);
        if (keyValue == null || keyValue.equals("")) {
            String defaultForm = BIMCommonReportUtil.getDefaultFormTemplate(dirRoot, reportPK, rptInfo);
            if (templateName != null) {
                defaultForm = templateName;
            }
            p.remove(key);
            p.put(key, defaultForm);
            p.store(new FileOutputStream(propertiesFile), "");
            retValue = defaultForm;
        } else if (templateName != null) {
            p.setProperty(key, templateName);
            p.store(new FileOutputStream(propertiesFile), "");
            retValue = templateName;
        } else {
            TemplateCollection templates = rptInfo.getFormTemplates();
            boolean flag = false;
            int n = templates.size();
            for (int i = 0; i < n; ++i) {
                TemplateInfo template = templates.get(i);
                if (!template.getName().equalsIgnoreCase(keyValue)) continue;
                flag = true;
                break;
            }
            if (flag) {
                retValue = keyValue;
            } else {
                retValue = BIMCommonReportUtil.getDefaultFormTemplate(dirRoot, reportPK, rptInfo);
                p.setProperty(key, retValue);
                p.store(new FileOutputStream(propertiesFile), "");
            }
        }
        ((InputStream)stream).close();
        return retValue;
    }

    public static String createRootDir() {
        String clientPath = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.io.tmpdir");
            }
        });
        clientPath = StringUtils.replace((String)clientPath, (String)"\\", (String)"/");
        String[] items = StringUtils.split((String)clientPath, (String)"/");
        StringBuffer sb = new StringBuffer();
        int n = items.length - 1;
        for (int i = 0; i < n; ++i) {
            sb.append(items[i]);
            sb.append("/");
        }
        String rootDir = sb.toString() + BIM_RPT_DIR;
        File file = new File(rootDir);
        file.mkdirs();
        return rootDir;
    }

    public static String formatPKString(String pk) {
        return StringUtils.replace((String)pk, (String)".", (String)"/");
    }

    public static String getPKDir(String pk) {
        String[] items = StringUtils.split((String)pk, (String)".");
        StringBuffer sb = new StringBuffer();
        int n = items.length - 1;
        for (int i = 0; i < n; ++i) {
            sb.append(items[i]);
            sb.append("/");
        }
        return sb.toString();
    }

    public static void checkFuncPermission(OrgType orgType, String reportPK, String actionName) throws EASBizException, BOSException {
        String funcName = reportPK + "." + actionName;
        IPermItem iPermItem = PermItemFactory.getRemoteInstance();
        if (iPermItem.getPermissionItemInfo(funcName) == null) {
            return;
        }
        try {
            IObjectPK userPK = BIMCommonReportUtil.getUserPK();
            IObjectPK orgPK = BIMCommonReportUtil.getOrgPK(orgType);
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            iPermission.checkFunctionPermission(userPK, orgPK, funcName);
        }
        catch (Exception e) {
            MsgBox.showError((String)"\u60a8\u76ee\u524d\u5c1a\u65e0\u6743\u9650\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u4e0e\u7cfb\u7edf\u7ba1\u7406\u5458\u8054\u7cfb\uff01", (String)e.getMessage());
            SysUtil.abort((Throwable)e);
        }
    }

    public static IObjectPK getUserPK() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        return new ObjectUuidPK(userInfo.getId());
    }

    public static IObjectPK getOrgPK(OrgType orgType) {
        OrgUnitInfo orgInfo = SysContext.getSysContext().getCurrentOrgUnit(orgType);
        return orgInfo == null ? null : new ObjectUuidPK(orgInfo.getId());
    }

    public static boolean isMainSubObject(QueryInfo queryInfo, SubObjectInfo subObj) throws BOSException {
        if (subObj == null) {
            return false;
        }
        SubObjectInfo mainObj = queryInfo.getMainObject();
        if (queryInfo instanceof JoinQueryInfo) {
            JoinCollection joins = ((JoinQueryInfo)queryInfo).getJoins();
            int n = joins.size();
            for (int i = 0; i < n; ++i) {
                JoinInfo join = joins.get(i);
                SubObjectInfo leftObj = join.getLeftObject();
                SubObjectInfo rightObj = join.getRightObject();
                if (rightObj == null || !rightObj.getName().equals(subObj.getName()) || leftObj == null || !leftObj.getName().equals(mainObj.getName())) continue;
                return true;
            }
        } else if (queryInfo instanceof UnionQueryInfo) {
            return true;
        }
        return false;
    }

    public static boolean checkQueryCU(QueryInfo queryInfo) {
        SubObjectCollection subObjs = queryInfo.getSubObjects();
        logger.debug((Object)("\u5b50\u5bf9\u8c61\u4e2a\u6570:" + subObjs.size()));
        int n = subObjs.size();
        for (int i = 0; i < n; ++i) {
            EntityObjectInfo entity;
            String entityName;
            SubObjectInfo subObj = subObjs.get(i);
            if (!(subObj instanceof SubEntityInfo) || !(entityName = (entity = ((SubEntityInfo)subObj).getEntityRef()).getFullName()).equalsIgnoreCase(CTRL_UNIT)) continue;
            try {
                if (!BIMCommonReportUtil.isMainSubObject(queryInfo, subObj)) continue;
                return true;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static EntityViewInfo createSelRowFilter(KDTable table, String pkFieldKey, String pkFieldName) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        int size = table.getSelectManager().size();
        String mask = "";
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock sb = table.getSelectManager().get(i);
                int begin = sb.getTop();
                int end = sb.getBottom();
                for (int j = begin; j <= end; ++j) {
                    IRow row = table.getRow(j);
                    ICell cell = row.getCell(pkFieldKey);
                    if (cell == null) continue;
                    FilterItemInfo fiInfo = new FilterItemInfo(pkFieldName, cell.getValue(), CompareType.EQUALS);
                    fic.add(fiInfo);
                }
                if ("" != mask) {
                    mask = mask + " OR ";
                }
                mask = mask + "#" + String.valueOf(i);
            }
        }
        if ("" != mask) {
            filter.setMaskString(mask);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return evi;
    }
}

