/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.work.basedata.thread;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.csinterface.agent.service.work.basedata.BillDataStatus;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.DataRow;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.StructuredDataModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.FlatDataModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.IBufferedDataProvider;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.db.BufferedBillDataProvider;
import com.kingdee.eas.csinterface.agent.service.work.basedata.snapshot.ChangefulBillData;
import com.kingdee.eas.csinterface.agent.service.work.basedata.thread.BaseDataSynSender;
import com.kingdee.eas.csinterface.agent.service.work.basedata.thread.DiskBufferedQueue;
import com.kingdee.eas.csinterface.agent.service.work.basedata.util.DataModelUtil;
import com.kingdee.eas.csinterface.agent.servlet.processor.BaseDataServlet;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.basedataSynByWsservice.BaseDataSynSenderByWSService;
import com.kingdee.eas.csinterface.basedatasyn.app.newsync.factory.BaseDataPlanFactory;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataSynCheckUtil;
import com.kingdee.eas.csinterface.basedatasyn.app.util.EIPConfiguration;
import com.kingdee.eas.csinterface.basedatasyn.app.util.GetChangedDataUtil;
import com.kingdee.eas.csinterface.cache.util.CacheType;
import com.kingdee.eas.csinterface.monitor.app.BaseDataDownMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class BaseDataRunner {
    private static Logger logger = Logger.getLogger(BaseDataRunner.class);
    static int MAX_THREADS_FOR_SEND_PER_BILLDATA;
    static int TRANSMIT_BILL_COUNT;
    static int QUEUE_FILE_SIZE;
    static int QUEUE_RAM_COUNT;
    public BaseDataSynTableInfo baseDataSynInfo;
    public StructuredDataModel dataModel;
    public IBufferedDataProvider bufferDataProvider;
    private Map<String, String> resultMap = new HashMap<String, String>();
    List<String> haveAckTransmitInfos = new ArrayList<String>();
    List<String> toAckTransmitSequenceNumbers = new ArrayList<String>();
    ConcurrentHashMap<String, ConcurrentHashMap<Integer, List<Object>>> sendThreadsWaitAckIDs = new ConcurrentHashMap();
    Set<String> sendingTransmitSequenceNumber = new HashSet<String>();
    AtomicBoolean hasProviderException = new AtomicBoolean(false);
    AtomicBoolean shouldAbortSend = new AtomicBoolean(false);
    AtomicInteger sendThreadCount = new AtomicInteger();
    AtomicBoolean noBillDataForSend = new AtomicBoolean(false);
    public DiskBufferedQueue<DataRow> bufferedQueue;
    private List<Thread> sendThreads = new ArrayList<Thread>();
    AtomicInteger sendBytesCounter = new AtomicInteger(0);
    AtomicInteger chunkedCounter = new AtomicInteger(0);
    List<Object> haveIgnoreHeadPk = new ArrayList<Object>();
    private Context ctx;
    int pageNum;
    int pageSize;
    String fid;
    String srcWhere;
    String relateSQL;
    boolean isMainTable;
    String transmitSerialNumber;
    int transmitChunkedNumber;
    String type;
    String connectionId;
    public FlatDataModel flatDataModel;
    private int EACH_COUNT = 5000;
    public static Map<String, Integer> clearAllInvalidData;
    public static int threshold;

    public Map<String, String> getResultMap() {
        return this.resultMap;
    }

    public BaseDataRunner(BaseDataSynTableInfo baseDataSynInfo, Context ctx, int pageNum, int pageSize, boolean filterChangeful) throws Exception {
        this.baseDataSynInfo = baseDataSynInfo;
        this.dataModel = DataModelUtil.convert(baseDataSynInfo, ctx, filterChangeful);
        this.ctx = ctx;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
    }

    public BaseDataRunner(BaseDataSynTableInfo baseDataSynInfo, Context ctx, int pageNum, int pageSize, boolean filterChangeful, String fid, String srcWhere, String relateSQL, boolean isMainTable, String connId) throws Exception {
        this.baseDataSynInfo = baseDataSynInfo;
        this.dataModel = DataModelUtil.convert(baseDataSynInfo, ctx, filterChangeful);
        this.ctx = ctx;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.fid = fid;
        this.srcWhere = srcWhere;
        this.relateSQL = relateSQL;
        this.isMainTable = isMainTable;
        this.transmitSerialNumber = this.transmitSerialNumber;
        this.connectionId = connId;
        this.flatDataModel = this.flatDataModel;
    }

    public BaseDataRunner(BaseDataSynTableInfo baseDataSynInfo, Context ctx, int pageNum, int pageSize, boolean filterChangeful, String fid, String srcWhere, String relateSQL, boolean isMainTable, String connId, FlatDataModel flatDataModel) throws Exception {
        this.baseDataSynInfo = baseDataSynInfo;
        this.dataModel = BaseDataPlanFactory.convert((BaseDataSynTableInfo)baseDataSynInfo, (boolean)filterChangeful, (Context)ctx, (CacheType)CacheType.SYNCOLUMN);
        this.ctx = ctx;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.fid = fid;
        this.srcWhere = srcWhere;
        this.relateSQL = relateSQL;
        this.isMainTable = isMainTable;
        this.transmitSerialNumber = this.transmitSerialNumber;
        this.connectionId = connId;
        this.flatDataModel = flatDataModel;
    }

    public BaseDataRunner(BaseDataSynTableInfo baseDataSynInfo, Context ctx, int pageNum, int pageSize, boolean filterChangeful, String fid, String srcWhere, String relateSQL, boolean isMainTable, String transmitSerialNumber, String connectionId) throws Exception {
        this.baseDataSynInfo = baseDataSynInfo;
        this.dataModel = BaseDataPlanFactory.convert((BaseDataSynTableInfo)baseDataSynInfo, (boolean)filterChangeful, (Context)ctx, (CacheType)CacheType.SYNCOLUMN);
        this.ctx = ctx;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.fid = fid;
        this.srcWhere = srcWhere;
        this.relateSQL = relateSQL;
        this.isMainTable = isMainTable;
        this.transmitSerialNumber = transmitSerialNumber;
        this.connectionId = connectionId;
    }

    public BaseDataRunner(BaseDataSynTableInfo baseDataSynInfo, Context ctx, boolean filterChangeful, String fid, String transmitSerialNumber, int transmitChunkedNumber, String type) throws Exception {
        this.baseDataSynInfo = baseDataSynInfo;
        this.dataModel = DataModelUtil.convert(baseDataSynInfo, ctx, filterChangeful);
        this.ctx = ctx;
        this.fid = fid;
        this.transmitSerialNumber = transmitSerialNumber;
        this.transmitChunkedNumber = transmitChunkedNumber;
        this.type = type;
    }

    public BaseDataRunner(BaseDataSynTableInfo baseDataSynInfo, Context ctx, boolean filterChangeful, String fid, String transmitSerialNumber, int transmitChunkedNumber, String type, FlatDataModel flatDataModel) throws Exception {
        this.baseDataSynInfo = baseDataSynInfo;
        this.dataModel = DataModelUtil.convert(baseDataSynInfo, ctx, filterChangeful);
        this.ctx = ctx;
        this.fid = fid;
        this.transmitSerialNumber = transmitSerialNumber;
        this.transmitChunkedNumber = transmitChunkedNumber;
        this.type = type;
        this.flatDataModel = flatDataModel;
    }

    public BaseDataRunner(BaseDataSynTableInfo baseDataSynInfo, Context ctx, boolean filterChangeful, String fid, String transmitSerialNumber, int transmitChunkedNumber, boolean isMainTable) throws Exception {
        this.baseDataSynInfo = baseDataSynInfo;
        this.dataModel = DataModelUtil.convert(baseDataSynInfo, ctx, filterChangeful);
        this.ctx = ctx;
        this.fid = fid;
        this.transmitSerialNumber = transmitSerialNumber;
        this.pageNum = transmitChunkedNumber;
        this.transmitChunkedNumber = transmitChunkedNumber;
        this.isMainTable = isMainTable;
    }

    public BaseDataRunner(BaseDataSynTableInfo baseDataSynInfo, Context ctx, boolean filterChangeful, String fid, boolean isMainTable) throws Exception {
        this.baseDataSynInfo = baseDataSynInfo;
        this.dataModel = DataModelUtil.convert(baseDataSynInfo, ctx, filterChangeful);
        this.ctx = ctx;
        this.fid = fid;
        this.transmitSerialNumber = "-1";
        this.pageNum = -1;
        this.transmitChunkedNumber = -1;
        this.isMainTable = isMainTable;
    }

    public Context getContext() {
        return this.ctx;
    }

    private static File getCacheDir(String userId) {
        String agentConfigPath = System.getProperty("agent_config");
        String configRoot = StringUtils.isEmpty((String)agentConfigPath) ? "." + File.separatorChar + "config" : agentConfigPath;
        return new File(new File(configRoot).getParentFile(), "cache" + File.separatorChar + userId);
    }

    synchronized void registerSendThread() {
        this.sendThreads.add(Thread.currentThread());
    }

    synchronized void unregisterSendThread() {
        this.sendThreads.remove(Thread.currentThread());
    }

    private synchronized void interruptSendThreads() {
        for (Thread sendThread : this.sendThreads) {
            sendThread.interrupt();
        }
    }

    public void startRun() {
        try {
            this.startRunBillData();
        }
        catch (Exception e) {
            logger.error((Object)("exception occurred when running bill data thread : " + e.getMessage()), (Throwable)e);
        }
        logger.debug((Object)("thread of bill data '" + this.baseDataSynInfo.getTableName() + "' finished!"));
    }

    public void startRunBase() {
        try {
            this.startRunDataBase();
        }
        catch (Exception e) {
            logger.error((Object)("exception occurred when running bill data thread : " + e.getMessage()), (Throwable)e);
        }
        logger.debug((Object)("thread of base data '" + this.baseDataSynInfo.getTableName() + "' finished!"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRunDataBase() throws Exception {
        logger.info((Object)("running base data ,tableName : " + this.baseDataSynInfo.getTableName()));
        long startTime = System.currentTimeMillis();
        DiskBufferedQueue<DataRow> bufferedQueue = null;
        try {
            EipUserInfo eipUserInfo = BaseDataServlet.getEipUser(this.ctx);
            bufferedQueue = new DiskBufferedQueue<DataRow>(BaseDataRunner.getCacheDir(eipUserInfo.getId().toString()), this.baseDataSynInfo.getTableName(), (long)QUEUE_FILE_SIZE * 1024L * 1024L);
            this.bufferedQueue = bufferedQueue;
            this.bufferDataProvider = new BufferedBillDataProvider(this.dataModel, bufferedQueue, eipUserInfo.getId().toString(), this.fid, this.transmitSerialNumber, this.transmitChunkedNumber);
            this.bufferDataProvider.open(this.ctx);
            while (!bufferedQueue.isFinishWrite() && !this.hasProviderException.get()) {
                if (this.shouldAbortSend.get()) {
                    break;
                }
                if (!bufferedQueue.isFinishWrite()) {
                    long t = System.currentTimeMillis();
                    this.doRunbaseData();
                    t = System.currentTimeMillis() - t;
                    if (t >= 500L) continue;
                    Thread.sleep(500L);
                    continue;
                }
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bufferedQueue != null) {
                bufferedQueue.close();
            }
            try {
                if (this.bufferDataProvider != null) {
                    this.bufferDataProvider.close();
                }
            }
            catch (Exception exception) {}
            long l = System.currentTimeMillis() - startTime;
        }
    }

    public void startRunBaseWSServiceUpdate() throws Exception {
        try {
            this.startRunDataBaseWSServiceUpdate();
        }
        catch (Exception e) {
            logger.error((Object)("exception occurred when running bill data thread : " + e.getMessage()), (Throwable)e);
            throw e;
        }
        logger.debug((Object)("thread of base data '" + this.baseDataSynInfo.getTableName() + "' finished!"));
    }

    private void startRunDataBaseWSServiceUpdate() throws Exception {
        logger.info((Object)("running base data ,tableName : " + this.baseDataSynInfo.getTableName()));
        Object stmt = null;
        Object resultSet = null;
        this.bufferDataProvider = new BufferedBillDataProvider(this.dataModel, 0, Integer.MAX_VALUE, this.connectionId, this.fid, this.baseDataSynInfo.getSrcWhere(), this.baseDataSynInfo.getRelateSQL(), this.baseDataSynInfo.isMainTable(), false, "update");
        try {
            this.bufferDataProvider.open(this.ctx);
            this.doRunChangeBillDataWSService(this.baseDataSynInfo.isMainTable());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.bufferDataProvider.close();
        }
    }

    private void doRunChangeBillDataWSService(boolean isMainTable) throws Exception {
        try {
            FlatDataModel flatDataModel;
            StructuredDataModel.TableModel[] tableModels = this.dataModel.getTables();
            int columnCount = tableModels[1].columns.length;
            String[] sortedChangefulFields = null;
            sortedChangefulFields = isMainTable ? ChangefulBillData.getSortedChangefulFields4BaseData(this.dataModel) : ChangefulBillData.getSortedChangefulFields(this.dataModel);
            this.flatDataModel = flatDataModel = this.bufferDataProvider.execChangeSQL(this.baseDataSynInfo, this.connectionId, this.fid, false);
            BaseDataSynSenderByWSService dataSender = null;
            dataSender = new BaseDataSynSenderByWSService(this, this.resultMap, this.connectionId);
            if (flatDataModel.getDeleteIds().size() > 0) {
                long beginDeleteTime = System.currentTimeMillis();
                dataSender.initUpdateDataWSServiceDelete(flatDataModel);
                long endDeleteTime = System.currentTimeMillis();
                ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getRecordBaseDataLog().recordTableExecInfo("\u6267\u884c\u5220\u9664\u8017\u65f6\uff1a" + (endDeleteTime - beginDeleteTime) + "ms \r");
            }
            if (flatDataModel.getUpdateIds().size() > 0) {
                this.bufferDataProvider.getSendDataRows().clear();
                this.bufferDataProvider.initUpdateDataJDBCUpdate(sortedChangefulFields, sortedChangefulFields.length);
                dataSender.sendUpdateWSService();
            }
            if (flatDataModel.getAddIds().size() > 0) {
                this.bufferDataProvider.initUpdateDataJDBCInsert(sortedChangefulFields, sortedChangefulFields.length);
                dataSender.sendWSService();
            }
        }
        catch (Exception e) {
            this.hasProviderException.set(true);
            logger.error((Object)e);
            throw e;
        }
        finally {
            try {
                this.bufferDataProvider.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.bufferDataProvider.getSendDataRows().clear();
        }
    }

    public void startRunBaseJDBCAdd() throws Exception {
        try {
            this.startRunDataBaseJDBCAdd();
        }
        catch (Exception e) {
            logger.error((Object)("exception occurred when running bill data thread : " + e.getMessage()), (Throwable)e);
            throw e;
        }
        logger.debug((Object)("thread of base data '" + this.baseDataSynInfo.getTableName() + "' finished!"));
    }

    public void startRunBaseJDBCUpdate() throws Exception {
        try {
            this.startRunDataBaseJDBCUpdate();
        }
        catch (Exception e) {
            logger.error((Object)("exception occurred when running bill data thread : " + e.getMessage()), (Throwable)e);
            throw e;
        }
        logger.debug((Object)("thread of base data '" + this.baseDataSynInfo.getTableName() + "' finished!"));
    }

    public void startRunBaseJDBCDelete() {
        logger.debug((Object)("thread of base data '" + this.baseDataSynInfo.getTableName() + "' finished!"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRunDataBaseJDBCAdd() throws Exception {
        logger.info((Object)("running base data ,tableName : " + this.baseDataSynInfo.getTableName()));
        String ksql = this.initQuerySqlAdd(this.baseDataSynInfo.getTableName(), this.connectionId);
        Object conn = null;
        Object stmt = null;
        Object resultSet = null;
        this.bufferDataProvider = new BufferedBillDataProvider(this.dataModel, this.connectionId, this.fid, ksql);
        try {
            this.bufferDataProvider.open(this.ctx);
            this.doRunbaseDataJDBC();
        }
        finally {
            this.bufferDataProvider.close();
        }
    }

    private void startRunDataBaseJDBCUpdate() throws Exception {
        logger.info((Object)("running base data ,tableName : " + this.baseDataSynInfo.getTableName()));
        Object conn = null;
        Object stmt = null;
        Object resultSet = null;
        this.bufferDataProvider = new BufferedBillDataProvider(this.dataModel, 0, Integer.MAX_VALUE, this.connectionId, this.fid, this.baseDataSynInfo.getSrcWhere(), this.baseDataSynInfo.getRelateSQL(), this.baseDataSynInfo.isMainTable(), false, "update");
        try {
            this.bufferDataProvider.open(this.ctx);
            this.doRunChangeBillDataJDBC(this.baseDataSynInfo.isMainTable());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.bufferDataProvider.close();
        }
    }

    public void startRunChange() {
        try {
            this.startRunBillDataChange();
        }
        catch (Exception e) {
            logger.error((Object)("exception occurred when running bill data thread : " + e.getMessage()), (Throwable)e);
        }
        logger.debug((Object)("thread of bill data '" + this.baseDataSynInfo.getTableName() + "' finished!"));
    }

    public void startRunChangeJDBC() {
        try {
            this.startRunBillDataUpdateJDBC();
        }
        catch (Exception e) {
            logger.error((Object)("exception occurred when running bill data thread : " + e.getMessage()), (Throwable)e);
        }
        logger.debug((Object)("thread of bill data '" + this.baseDataSynInfo.getTableName() + "' finished!"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRunBillData() throws Exception {
        logger.info((Object)("running base data ,tableName : " + this.baseDataSynInfo.getTableName()));
        long startTime = System.currentTimeMillis();
        DiskBufferedQueue<DataRow> bufferedQueue = null;
        try {
            UserInfo userInfo = null;
            for (Object obj : this.ctx.getUserDefineFieldKeySet()) {
                if (!(this.ctx.get(obj) instanceof UserInfo)) continue;
                userInfo = (UserInfo)this.ctx.get(obj);
                break;
            }
            EipUserInfo eipUserInfo = BaseDataServlet.getEipUser(this.ctx);
            bufferedQueue = new DiskBufferedQueue<DataRow>(BaseDataRunner.getCacheDir(eipUserInfo.getId().toString()), this.baseDataSynInfo.getTableName(), (long)QUEUE_FILE_SIZE * 1024L * 1024L);
            this.bufferedQueue = bufferedQueue;
            this.bufferDataProvider = new BufferedBillDataProvider(this.dataModel, bufferedQueue, this.pageNum, this.pageSize, eipUserInfo.getId().toString(), this.fid, this.srcWhere, this.relateSQL, false, this.transmitSerialNumber, this.ctx, false);
            this.bufferDataProvider.open(this.ctx);
            while (!bufferedQueue.isFinishWrite() && !this.hasProviderException.get()) {
                if (this.shouldAbortSend.get()) {
                    break;
                }
                if (!bufferedQueue.isFinishWrite()) {
                    long t = System.currentTimeMillis();
                    this.doRunBillData();
                    t = System.currentTimeMillis() - t;
                    if (t >= 500L) continue;
                    Thread.sleep(500L);
                    continue;
                }
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bufferedQueue != null) {
                bufferedQueue.close();
            }
            try {
                if (this.bufferDataProvider != null) {
                    this.bufferDataProvider.close();
                }
            }
            catch (Exception exception) {}
            long l = System.currentTimeMillis() - startTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRunBillDataChange() throws Exception {
        logger.info((Object)("running base data update ,tableName : " + this.baseDataSynInfo.getTableName()));
        long startTime = System.currentTimeMillis();
        DiskBufferedQueue<DataRow> bufferedQueue = null;
        try {
            EipUserInfo eipUserInfo = BaseDataServlet.getEipUser(this.ctx);
            bufferedQueue = new DiskBufferedQueue<DataRow>(BaseDataRunner.getCacheDir(eipUserInfo.getId().toString()), this.baseDataSynInfo.getTableName(), (long)QUEUE_FILE_SIZE * 1024L * 1024L);
            this.bufferedQueue = bufferedQueue;
            this.bufferDataProvider = new BufferedBillDataProvider(this.dataModel, bufferedQueue, eipUserInfo.getId().toString(), this.fid, this.pageSize, this.pageNum, this.ctx);
            this.bufferDataProvider.open(this.ctx);
            while (!bufferedQueue.isFinishWrite() && !this.hasProviderException.get()) {
                if (this.shouldAbortSend.get()) {
                    break;
                }
                if (!bufferedQueue.isFinishWrite()) {
                    long t = System.currentTimeMillis();
                    this.doRunChangeBillData(this.baseDataSynInfo.isMainTable());
                    t = System.currentTimeMillis() - t;
                    if (t >= 500L) continue;
                    Thread.sleep(500L);
                    continue;
                }
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bufferedQueue != null) {
                bufferedQueue.close();
            }
            try {
                if (this.bufferDataProvider != null) {
                    this.bufferDataProvider.close();
                }
            }
            catch (Exception exception) {}
            long l = System.currentTimeMillis() - startTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRunBillDataUpdateJDBC() throws Exception {
        logger.info((Object)("running base data update ,tableName : " + this.baseDataSynInfo.getTableName()));
        long startTime = System.currentTimeMillis();
        DiskBufferedQueue<DataRow> bufferedQueue = null;
        try {
            EipUserInfo eipUserInfo = BaseDataServlet.getEipUser(this.ctx);
            bufferedQueue = new DiskBufferedQueue<DataRow>(BaseDataRunner.getCacheDir(eipUserInfo.getId().toString()), this.baseDataSynInfo.getTableName(), (long)QUEUE_FILE_SIZE * 1024L * 1024L);
            this.bufferedQueue = bufferedQueue;
            this.bufferDataProvider = new BufferedBillDataProvider(this.dataModel, bufferedQueue, eipUserInfo.getId().toString(), this.fid, this.pageSize, this.pageNum, this.ctx);
            this.bufferDataProvider.open(this.ctx);
            while (!bufferedQueue.isFinishWrite() && !this.hasProviderException.get()) {
                if (this.shouldAbortSend.get()) {
                    break;
                }
                if (!bufferedQueue.isFinishWrite()) {
                    long t = System.currentTimeMillis();
                    this.doRunChangeBillData(this.baseDataSynInfo.isMainTable());
                    t = System.currentTimeMillis() - t;
                    if (t >= 500L) continue;
                    Thread.sleep(500L);
                    continue;
                }
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bufferedQueue != null) {
                bufferedQueue.close();
            }
            try {
                if (this.bufferDataProvider != null) {
                    this.bufferDataProvider.close();
                }
            }
            catch (Exception exception) {}
            long l = System.currentTimeMillis() - startTime;
        }
    }

    private void doRunbaseData() throws Exception {
        try {
            this.bufferDataProvider.fillBufferBase(this.isMainTable);
        }
        catch (Exception e) {
            this.hasProviderException.set(true);
            logger.error((Object)e);
            throw e;
        }
    }

    private void doRunbaseDataJDBC() throws Exception {
        try {
            this.bufferDataProvider.fillBufferBaseJDBC(this.isMainTable);
        }
        catch (Exception e) {
            this.hasProviderException.set(true);
            logger.error((Object)e);
            throw e;
        }
    }

    private void doRunBillData() throws Exception {
        try {
            this.bufferDataProvider.fillBuffer(this.isMainTable);
        }
        catch (Exception e) {
            this.hasProviderException.set(true);
            logger.error((Object)e);
            throw e;
        }
    }

    private void doRunChangeBillData(boolean isMainTable) throws Exception {
        try {
            this.readChangeBillData(isMainTable);
        }
        catch (Exception e) {
            this.hasProviderException.set(true);
            logger.error((Object)e);
            throw e;
        }
    }

    private void readChangeBillData(boolean isMainTable) throws Exception {
        this.bufferDataProvider.fillChangeBuffer(this.transmitSerialNumber, this.transmitChunkedNumber, this.type, isMainTable);
    }

    private void doRunChangeBillDataJDBC(boolean isMainTable) throws Exception {
        try {
            List<String> addIds;
            List<String> updateIds;
            FlatDataModel dataModel;
            int endIndex;
            int beginIndex;
            int count;
            StructuredDataModel.TableModel[] tableModels = this.dataModel.getTables();
            int columnCount = tableModels[1].columns.length;
            String[] sortedChangefulFields = null;
            sortedChangefulFields = isMainTable ? ChangefulBillData.getSortedChangefulFields4BaseData(this.dataModel) : ChangefulBillData.getSortedChangefulFields(this.dataModel);
            String tableName = this.baseDataSynInfo.getTableName();
            FlatDataModel flatDataModel = null;
            if (!isMainTable && EIPConfiguration.Instance().isBigDataEntryTable(tableName)) {
                flatDataModel = GetChangedDataUtil.execChangeSQL((Context)this.ctx, (BaseDataSynTableInfo)this.baseDataSynInfo, (StructuredDataModel)this.dataModel, (String)this.connectionId, null, (boolean)false, (String)this.fid);
                this.bufferDataProvider.setFlatDataModel(flatDataModel);
            } else {
                flatDataModel = this.bufferDataProvider.execChangeSQL(this.baseDataSynInfo, this.connectionId, this.fid, false);
            }
            this.flatDataModel = flatDataModel;
            BaseDataSynSender dataSender = null;
            dataSender = new BaseDataSynSender(this, this.resultMap, this.connectionId);
            List<String> deleteIdsList = flatDataModel.getDeleteIds();
            if (deleteIdsList.size() > 0) {
                long beginDeleteTime = System.currentTimeMillis();
                count = (deleteIdsList.size() - 1) / this.EACH_COUNT + 1;
                beginIndex = 0;
                endIndex = 0;
                for (int i = 0; i < count; ++i) {
                    beginIndex = i * this.EACH_COUNT;
                    endIndex = (i + 1) * this.EACH_COUNT > deleteIdsList.size() ? deleteIdsList.size() : (i + 1) * this.EACH_COUNT;
                    List<String> subList = deleteIdsList.subList(beginIndex, endIndex);
                    dataModel = this.bufferDataProvider.getFlatDataModel();
                    dataModel.setDeleteIds(subList);
                    this.bufferDataProvider.initUpdateDataJDBCDelete();
                }
                long endDeleteTime = System.currentTimeMillis();
                ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getRecordBaseDataLog().recordTableExecInfo("\u6267\u884c\u5220\u9664\u8017\u65f6\uff1a" + (endDeleteTime - beginDeleteTime) + "ms \r");
            }
            if ((updateIds = flatDataModel.getUpdateIds()).size() > 0) {
                int count2 = (updateIds.size() - 1) / this.EACH_COUNT + 1;
                int beginIndex2 = 0;
                int endIndex2 = 0;
                for (int i = 0; i < count2; ++i) {
                    beginIndex2 = i * this.EACH_COUNT;
                    endIndex2 = (i + 1) * this.EACH_COUNT > updateIds.size() ? updateIds.size() : (i + 1) * this.EACH_COUNT;
                    List<String> subList = updateIds.subList(beginIndex2, endIndex2);
                    FlatDataModel dataModel2 = this.bufferDataProvider.getFlatDataModel();
                    dataModel2.setUpdateIds(subList);
                    this.bufferDataProvider.getSendDataRows().clear();
                    this.bufferDataProvider.initUpdateDataJDBCUpdate(sortedChangefulFields, sortedChangefulFields.length);
                    dataSender.sendUpdateJDBC();
                }
            }
            if ((addIds = flatDataModel.getAddIds()).size() > 0) {
                BaseDataSynCheckUtil.addBeforeSQLCheckNew((Context)this.ctx, (BaseDataSynTableInfo)this.baseDataSynInfo, null, addIds, (String)this.connectionId, (String)this.baseDataSynInfo.getBeforeSQL());
                if (!addIds.isEmpty()) {
                    count = (addIds.size() - 1) / this.EACH_COUNT + 1;
                    beginIndex = 0;
                    endIndex = 0;
                    for (int i = 0; i < count; ++i) {
                        beginIndex = i * this.EACH_COUNT;
                        endIndex = (i + 1) * this.EACH_COUNT > addIds.size() ? addIds.size() : (i + 1) * this.EACH_COUNT;
                        List<String> subList = addIds.subList(beginIndex, endIndex);
                        dataModel = this.bufferDataProvider.getFlatDataModel();
                        dataModel.setAddIds(subList);
                        this.bufferDataProvider.getSendDataRows().clear();
                        this.bufferDataProvider.initUpdateDataJDBCInsert(sortedChangefulFields, sortedChangefulFields.length);
                        dataSender.sendJDBC();
                    }
                }
            }
        }
        catch (Exception e) {
            this.hasProviderException.set(true);
            logger.error((Object)e);
            throw e;
        }
        finally {
            try {
                this.bufferDataProvider.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.bufferDataProvider.getSendDataRows().clear();
        }
    }

    private void readChangeBillDataJDBC(boolean isMainTable) throws Exception {
        this.bufferDataProvider.fillChangeBufferJDBC(this.transmitSerialNumber, this.transmitChunkedNumber, this.type, isMainTable);
    }

    public String initQuerySql(String tableName, String agentId) throws Exception {
        this.bufferDataProvider = new BufferedBillDataProvider(this.dataModel, this.bufferedQueue, this.pageNum, this.pageSize, agentId, this.fid, this.srcWhere, this.relateSQL, false, this.transmitSerialNumber, this.ctx, false);
        this.bufferDataProvider.open(this.ctx);
        return this.bufferDataProvider.getQueryString(tableName);
    }

    public String initQuerySqlAddID(String tableName, String connId) throws Exception {
        this.bufferDataProvider = new BufferedBillDataProvider(this.dataModel, this.bufferedQueue, this.pageNum, this.pageSize, connId, this.fid, this.srcWhere, this.relateSQL, false, this.transmitSerialNumber, this.ctx, true);
        return this.bufferDataProvider.getQueryString(tableName);
    }

    public String initQuerySqlAdd(String tableName, String connId) throws Exception {
        this.bufferDataProvider = new BufferedBillDataProvider(this.dataModel, this.bufferedQueue, this.pageNum, this.pageSize, connId, this.fid, this.srcWhere, this.relateSQL, false, this.transmitSerialNumber, this.ctx, false);
        return this.bufferDataProvider.getQueryString(tableName);
    }

    public FlatDataModel getFlatDataModel(String tableName, String connId, FlatDataModel flatDataModel) throws Exception {
        this.bufferDataProvider = new BufferedBillDataProvider(this.dataModel, this.bufferedQueue, this.pageNum, this.pageSize, connId, this.fid, this.srcWhere, this.relateSQL, false, "update", flatDataModel, this.ctx);
        this.flatDataModel = flatDataModel;
        return flatDataModel;
    }

    public String initTransQuerySql(String tableName, String agentId) throws Exception {
        this.bufferDataProvider = new BufferedBillDataProvider(this.dataModel, this.bufferedQueue, this.pageNum, this.pageSize, agentId, this.fid, this.srcWhere, this.relateSQL, false, this.transmitSerialNumber, this.ctx, false);
        this.bufferDataProvider.open(this.ctx);
        return this.bufferDataProvider.getQueryString(tableName);
    }

    public String initQuerySql4Change(String tableName, String agentId, boolean isMainTable, boolean isOrganization, String type) throws Exception {
        this.bufferDataProvider = new BufferedBillDataProvider(this.dataModel, this.bufferedQueue, this.pageNum, this.pageSize, agentId, this.fid, this.srcWhere, this.relateSQL, isMainTable, isOrganization, type);
        this.bufferDataProvider.open(this.ctx);
        return this.bufferDataProvider.getQueryString4Change(tableName);
    }

    public String initQuerySql4ChangeJDBC(String tableName, String connId, boolean isMainTable, boolean isOrganization, String type) throws Exception {
        this.bufferDataProvider = new BufferedBillDataProvider(this.dataModel, this.bufferedQueue, this.pageNum, this.pageSize, connId, this.fid, this.srcWhere, this.relateSQL, isMainTable, isOrganization, type);
        return this.bufferDataProvider.getQueryString4Change(tableName);
    }

    public String initQuerySql4ChangeJDBC(String tableName, String connId, boolean isTree, String type, FlatDataModel flatDataModel) throws Exception {
        this.bufferDataProvider = new BufferedBillDataProvider(this.dataModel, this.bufferedQueue, this.pageNum, this.pageSize, connId, this.fid, this.srcWhere, this.relateSQL, isTree, type, flatDataModel, this.ctx);
        this.bufferDataProvider.open(this.ctx);
        return this.bufferDataProvider.getQueryString4Change(tableName);
    }

    public StructuredDataModel getDataModel(String agentId, boolean isOrganization, String type) throws Exception {
        this.bufferDataProvider = new BufferedBillDataProvider(this.dataModel, this.bufferedQueue, this.pageNum, this.pageSize, agentId, this.fid, this.srcWhere, this.relateSQL, this.isMainTable, isOrganization, type);
        this.bufferDataProvider.open(this.ctx);
        return this.bufferDataProvider.getDataModel();
    }

    private void processIgnoreHeadPK(String transmitSerialNumber, Object ignoreHeadPK) throws Exception {
        if (null == ignoreHeadPK) {
            logger.info((Object)"BillDataRunner\u3002processIgnoreHeadPK\uff1a\u9700\u8981\u5220\u9664\u88ab\u8fc7\u6ee4\u7684\u5355\u636e=[null]");
            return;
        }
        logger.info((Object)("BillDataRunner\u3002processIgnoreHeadPK\uff1a\u9700\u8981\u5220\u9664\u88ab\u8fc7\u6ee4\u7684\u5355\u636e=[" + ignoreHeadPK.toString() + "]"));
        String headPKStr = ignoreHeadPK.toString();
        String[] headpks = StringUtils.split((String)headPKStr, (String)",");
        if (null == headpks || headpks.length == 0) {
            return;
        }
        ArrayList<Object> idList = new ArrayList<Object>();
        for (int i = 0; i < headpks.length; ++i) {
            if (StringUtils.isEmpty((String)headpks[i])) continue;
            idList.add(headpks[i]);
        }
        this.bufferDataProvider.feedback(idList, transmitSerialNumber, BillDataStatus.ack);
        logger.info((Object)("delete PKtable \u3010\u9700\u8981\u5220\u9664\u3011:transmitSerialNumber=" + transmitSerialNumber + ",headPK=" + ((Object)idList).toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStatusBack() throws Exception {
        if (this.sendThreadsWaitAckIDs.size() > 0) {
            Set transmitSerNumbers = this.sendThreadsWaitAckIDs.keySet();
            for (String transmitSerNumber : transmitSerNumbers) {
                ConcurrentHashMap<Integer, List<Object>> chunkedWaitAckIDs = this.sendThreadsWaitAckIDs.get(transmitSerNumber);
                Set chunkedToAckIDs = chunkedWaitAckIDs.keySet();
                for (Integer chunkedNumber : chunkedToAckIDs) {
                    this.bufferDataProvider.feedback(chunkedWaitAckIDs.get(chunkedNumber), transmitSerNumber, chunkedNumber, BillDataStatus.waitAck);
                    chunkedWaitAckIDs.remove(chunkedNumber);
                }
                Set<String> set = this.sendingTransmitSequenceNumber;
                synchronized (set) {
                    if (!this.sendingTransmitSequenceNumber.contains(transmitSerNumber)) {
                        this.sendThreadsWaitAckIDs.remove(transmitSerNumber);
                    }
                }
            }
        }
        List<Object> list = this.haveIgnoreHeadPk;
        synchronized (list) {
            logger.info((Object)("BillDataRunner.writeStatusBack:\u9700\u8981\u5220\u9664\u88ab\u8fc7\u6ee4\u7684\u5355\u636e=" + this.haveIgnoreHeadPk.toString()));
            if (this.haveIgnoreHeadPk.size() > 0) {
                this.bufferDataProvider.feedback(this.haveIgnoreHeadPk, "", BillDataStatus.ack);
                this.haveIgnoreHeadPk.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void deleteInvalidRecord(Context ctx, String tableName, String agentId) throws Exception {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = SQLUtil.getKSQLConnection(ctx);
            statement = connection.prepareStatement("delete from " + tableName + " where status in ( -1 , " + BillDataStatus.waitAck.getValue() + "," + BillDataStatus.read.getValue() + ") and agentId = '" + agentId + "' ");
            statement.executeUpdate();
            SQLUtil.cleanup(statement, connection);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("\u672a\u80fd\u6b63\u5e38\u7684\u6e05\u7406\u5f02\u5e38\u589e\u91cf\u8868\u6570\u636e\uff0c\u5b9a\u4f4d\uff1a\u8868\u540d\uff1a" + tableName + ",Agent:" + agentId));
        }
        finally {
            SQLUtil.cleanup(statement, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void deleteInvalidRecord(Context ctx, String tableName, String agentId, List<String> idList) throws Exception {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = SQLUtil.getKSQLConnection(ctx);
            statement = connection.prepareStatement("delete from " + tableName + " where status in ( -1 , " + BillDataStatus.waitAck.getValue() + "," + BillDataStatus.read.getValue() + ") and agentId = '" + agentId + "'  and headpk in ( " + com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converList2String(idList, ",", "'") + ")");
            statement.executeUpdate();
            SQLUtil.cleanup(statement, connection);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("\u672a\u80fd\u6b63\u5e38\u7684\u6e05\u7406\u5f02\u5e38\u589e\u91cf\u8868\u6570\u636e\uff0c\u5b9a\u4f4d\uff1a\u8868\u540d\uff1a" + tableName + ",Agent:" + agentId));
        }
        finally {
            SQLUtil.cleanup(statement, connection);
        }
    }

    public void clear() {
        if (this.bufferDataProvider != null) {
            this.bufferDataProvider.clear();
        }
    }

    public static synchronized boolean isClearAllInvalidRecord(String tableName) {
        boolean result = true;
        if (null == clearAllInvalidData.get(tableName)) {
            clearAllInvalidData.put(tableName, 0);
        } else {
            int execNum = clearAllInvalidData.get(tableName);
            if (++execNum < threshold) {
                result = false;
            } else {
                execNum = 0;
            }
            clearAllInvalidData.put(tableName, execNum);
        }
        return result;
    }

    static {
        TRANSMIT_BILL_COUNT = 50;
        QUEUE_FILE_SIZE = 200;
        QUEUE_RAM_COUNT = 3000;
        clearAllInvalidData = new HashMap<String, Integer>();
        threshold = 8;
    }
}

