/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.async.standardImpl.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.rabbitmq.support.EASMQPublish;
import com.kingdee.eas.csinterface.async.app.task.handler.impl.AbstractApiUserHandle;
import com.kingdee.eas.csinterface.openapi.FeedBackServiceInfo;
import com.kingdee.eas.csinterface.openapi.OpenAPIDispatcherInfo;
import com.kingdee.eas.csinterface.openapi.app.feedback.util.IERPUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.rabbitmq.rabbit.RabbitPublishInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataBasedAssignImpl
extends AbstractApiUserHandle {
    private static final Logger logger = Logger.getLogger(DataBasedAssignImpl.class);

    public String initData(Context ctx, JSONObject originalData, ICoreBase instance, OpenAPIDispatcherInfo adaptorService) throws Exception {
        FeedBackServiceInfo FeedBackServiceInfo2 = adaptorService.getFeedbackService();
        RabbitPublishInfo publisher = FeedBackServiceInfo2.getQueue();
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        JSONObject extData = IERPUtil.getIERPExtend((Context)ctx, (OpenAPIDispatcherInfo)adaptorService);
        String taskId = originalData.getString("taskId");
        int partNum = originalData.getIntValue("maxnumber");
        JSONObject all = new JSONObject();
        JSONArray allArr = new JSONArray();
        String querySQL = "select t1.FID, t1.FDATABASEDID, t1.FASSIGNCUID, t1.FSTATUS from T_BD_DATABASEDASSIGN t1 where t1.FBOSOBJECTTYPE = 'BF0C040E'";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            rs = statement.executeQuery(querySQL);
            while (rs.next()) {
                JSONObject relaObj = new JSONObject();
                relaObj.put("eipsrcid", (Object)rs.getString("FID"));
                relaObj.put("fid", (Object)rs.getString("FID"));
                relaObj.put("databasedid", (Object)rs.getString("FDATABASEDID"));
                relaObj.put("assigncuid", (Object)rs.getString("FASSIGNCUID"));
                relaObj.put("status", (Object)rs.getString("FSTATUS"));
                allArr.add((Object)relaObj);
            }
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("sql is:" + querySQL), (Throwable)exc);
                throw new BOSException("Sql execute exception : " + querySQL, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        int total = allArr.size();
        logger.error((Object)"---------------------\u5f00\u59cb\u63a8\u9001\u5ba2\u6237\u5173\u7cfb\u6570\u636e---------------------");
        for (int pishu = 0; pishu <= total / partNum; ++pishu) {
            int index;
            JSONArray arr = new JSONArray();
            for (int i = 0; i < partNum && (index = pishu * partNum + i) != total; ++i) {
                logger.error((Object)("---------------------\u7b2c" + pishu + "\u6279\uff0c\u7b2c" + index + "\u884c\u6570\u636e---------------------"));
                arr.add(allArr.get(index));
            }
            logger.error((Object)("---------------------\u7b2c" + pishu + "\u6279\u603b\u5171" + arr.size() + "\u4e2a---------------------"));
            int count = arr.size();
            this.pushData(ctx, publisher, extData, taskId, total, all, arr, count, pishu);
        }
        return null;
    }

    private void pushData(Context ctx, RabbitPublishInfo publisher, JSONObject extData, String taskId, int total, JSONObject all, JSONArray arr, int count, int pishu) throws Exception {
        all.put("taskId", (Object)taskId);
        all.put("total", (Object)total);
        all.put("data", (Object)arr);
        all.put("action", (Object)"init");
        all.put("count", (Object)count);
        all.put("pishu", (Object)pishu);
        all.putAll((Map)extData);
        EASMQPublish.publish((Context)ctx, (String)publisher.getId().toString(), (String)all.toJSONString());
    }
}

