/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.basedatasyn.TableStructureFactory;
import com.kingdee.eas.csinterface.basedatasyn.client.AbstractTableStructureListUI;
import com.kingdee.eas.csinterface.basedatasyn.client.TableNameEditUI;
import com.kingdee.eas.csinterface.basedatasyn.client.TableStructureShowUI;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.syncdatabase.client.util.OptionalPromptDataSourceType;
import com.kingdee.eas.csinterface.util.DataTypeConverter;
import com.kingdee.eas.csinterface.util.ILongTimeTask2;
import com.kingdee.eas.csinterface.util.LongTimeDialog2;
import com.kingdee.eas.csinterface.util.MyKDTableUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.util.UITools2;
import com.kingdee.eas.csinterface.utils.IKSQLFacade;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class TableStructureListUI
extends AbstractTableStructureListUI {
    private static final Logger logger = CoreUIObject.getLogger(TableStructureListUI.class);

    public TableStructureListUI() throws Exception {
        this.comDsType = OptionalPromptDataSourceType.initDataSourceType(new Object[]{DataSourceType.jdbc, DataSourceType.agent, DataSourceType.remoteService}, this.dataBinder);
        this.comDsType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableStructureListUI.this.dsTypeChanged();
            }
        });
    }

    private void dsTypeChanged() {
        DataSourceType dsType = (DataSourceType)((Object)this.comDsType.getSelectedItem());
        if (dsType == null) {
            return;
        }
        if (DataSourceType.jdbc.equals((Object)dsType)) {
            this.prmtAgent.setValue(null);
            this.prmtAgent.setEditable(false);
            this.prmtAgent.setEnabled(false);
            this.prmpservice.setValue(null);
            this.prmpservice.setEditable(false);
            this.prmpservice.setEnabled(false);
            this.prmtConn.setEditable(true);
            this.prmtConn.setEnabled(true);
        } else if (DataSourceType.agent.equals((Object)dsType)) {
            this.prmtConn.setValue(null);
            this.prmtConn.setEditable(false);
            this.prmtConn.setEnabled(false);
            this.prmpservice.setValue(null);
            this.prmpservice.setEditable(false);
            this.prmpservice.setEnabled(false);
            this.prmtAgent.setEditable(true);
            this.prmtAgent.setEnabled(true);
        } else if (DataSourceType.remoteService.equals((Object)dsType)) {
            this.prmtConn.setValue(null);
            this.prmtConn.setEditable(false);
            this.prmtConn.setEnabled(false);
            this.prmtAgent.setValue(null);
            this.prmtAgent.setEditable(false);
            this.prmtAgent.setEnabled(false);
            this.prmpservice.setEditable(true);
            this.prmpservice.setEnabled(true);
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8d44\u6e90\u7c7b\u522b'" + dsType.getAlias() + "'");
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRefresh.setEnabled(true);
        this.btnRemove.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnPrint.setVisible(false);
        this.prmtConn.setEditable(false);
        this.btnUpdateTable.setEnabled(false);
        this.btnObtain.setEnabled(false);
        this.dsTypeChanged();
    }

    protected String getEditUIName() {
        return TableStructureShowUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TableStructureFactory.getRemoteInstance();
    }

    @Override
    protected void prmtConn_dataChange(DataChangeEvent e) throws Exception {
        FilterInfo filter;
        if (this.prmtConn.getData() == null && this.prmtAgent.getData() == null && this.prmpservice.getData() == null) {
            this.btnUpdateTable.setEnabled(false);
            this.btnObtain.setEnabled(false);
        } else {
            this.btnUpdateTable.setEnabled(true);
            this.btnObtain.setEnabled(true);
        }
        this.mainQuery = null;
        this.initMainQuery();
        CommonQueryDialog dialog = this.getDialog();
        if (dialog != null && (filter = dialog.getCommonFilter()) != null) {
            this.mainQuery.getFilter().mergeFilter(filter, "and");
        }
        super.refresh(null);
    }

    @Override
    protected void prmtAgent_dataChange(DataChangeEvent e) throws Exception {
        FilterInfo filter;
        if (this.prmtConn.getData() == null && this.prmtAgent.getData() == null && this.prmpservice.getData() == null) {
            this.btnUpdateTable.setEnabled(false);
            this.btnObtain.setEnabled(false);
        } else {
            this.btnUpdateTable.setEnabled(true);
            this.btnObtain.setEnabled(true);
        }
        this.mainQuery = null;
        this.initMainQuery();
        CommonQueryDialog dialog = this.getDialog();
        if (dialog != null && (filter = dialog.getCommonFilter()) != null) {
            this.mainQuery.getFilter().mergeFilter(filter, "and");
        }
        super.refresh(null);
    }

    @Override
    protected void prmpservice_dataChange(DataChangeEvent e) throws Exception {
        FilterInfo filter;
        if (this.prmpservice.getData() == null && this.prmtAgent.getData() == null && this.prmtConn.getData() == null) {
            this.btnUpdateTable.setEnabled(false);
            this.btnObtain.setEnabled(false);
        } else {
            this.btnUpdateTable.setEnabled(true);
            this.btnObtain.setEnabled(true);
        }
        this.mainQuery = null;
        this.initMainQuery();
        CommonQueryDialog dialog = this.getDialog();
        if (dialog != null && (filter = dialog.getCommonFilter()) != null) {
            this.mainQuery.getFilter().mergeFilter(filter, "and");
        }
        super.refresh(null);
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        EipUserInfo user;
        ConnectionInfo conn = (ConnectionInfo)this.prmtConn.getData();
        if (conn != null) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("IP", (Object)conn.getIP(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("port", (Object)conn.getPort(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("instance", (Object)conn.getInstance(), CompareType.EQUALS));
            try {
                ev.getFilter().mergeFilter(filterInfo, "and");
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        if ((user = (EipUserInfo)this.prmtAgent.getData()) != null) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("IP", (Object)user.getDBIP(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("port", (Object)user.getDBPort(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("instance", (Object)user.getDbName(), CompareType.EQUALS));
            try {
                ev.getFilter().mergeFilter(filterInfo, "and");
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        super.beforeExcutQuery(ev);
    }

    @Override
    public void actionUpdateTable_actionPerformed(ActionEvent e) throws Exception {
        DataSourceType dsType = (DataSourceType)((Object)this.comDsType.getSelectedItem());
        if (DataSourceType.jdbc.equals((Object)dsType)) {
            ArrayList ids;
            final ConnectionInfo conn = (ConnectionInfo)this.prmtConn.getData();
            if (conn == null) {
                MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u7cfb\u7edf\u6570\u636e\u5e93\u8fde\u63a5");
                SysUtil.abort();
            }
            if ((ids = this.getSelectedIdValues()) == null || ids.isEmpty()) {
                MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u66f4\u65b0\u7684\u6570\u636e\u884c");
                SysUtil.abort();
            }
            final LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u5904\u7406\u66f4\u65b0\u4e2d", "\u8bf7\u7a0d\u540e");
            dialog.setLongTimeTask(new ILongTimeTask2(){
                private Exception exception;
                String excMsg = "";
                StringBuilder error = new StringBuilder();

                @Override
                public Object exec() throws Exception {
                    try {
                        int sum = ids.size();
                        for (int i = 0; i < sum; ++i) {
                            dialog.updateMsg("\u6b63\u5728\u6267\u884c\u66f4\u65b0(" + (i + 1) + "/" + sum + ")  \u8868:" + TableStructureListUI.this.getTableByID((String)ids.get(i)));
                            try {
                                TableStructureFactory.getRemoteInstance().updateColumnsByInfo((String)ids.get(i), conn);
                                continue;
                            }
                            catch (Exception e) {
                                this.error.append("\u8868" + TableStructureListUI.this.getTableByID((String)ids.get(i)) + "\u66f4\u65b0\u5931\u8d25:" + e.getMessage());
                            }
                        }
                        return "success";
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.exception = e;
                        return this.excMsg;
                    }
                }

                @Override
                public void afterExec(Object result) throws Exception {
                    if (!StringUtils.isEmpty((String)this.error.toString())) {
                        Exception ca = new Exception(this.error.toString());
                        MsgBox.showDetailAndOK((Component)((Object)TableStructureListUI.this), (String)"\u90e8\u5206\u5931\u8d25", (String)ThrowableHelper.toString((Throwable)ca), (int)1);
                    } else {
                        MsgBox.showInfo((String)"\u6267\u884c\u6210\u529f");
                    }
                }
            });
            dialog.show();
        } else if (DataSourceType.agent.equals((Object)dsType)) {
            int[] selectedRow;
            EipUserInfo agent = (EipUserInfo)this.prmtAgent.getData();
            if (agent == null) {
                MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u5ba2\u6237\u7aef\u4ee3\u7406");
                SysUtil.abort();
            }
            if ((selectedRow = MyKDTableUtil.getSelectedRows(this.tblMain)) == null || selectedRow.length <= 0) {
                MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u66f4\u65b0\u7684\u6570\u636e\u884c");
                SysUtil.abort();
            }
            HashSet<String> tableNames = new HashSet<String>();
            for (int i = 0; i < selectedRow.length; ++i) {
                tableNames.add((String)MyKDTableUtil.getTableCellValue(this.tblMain, selectedRow[i], "tableName"));
            }
            DBType destDBType = DBType.getEnum(agent.getDBType());
            DataTypeConverter converter = DataTypeConverter.getConverter(destDBType);
            String sql = converter.getColumnDefinedSql("?");
            IKSQLFacade ksqlFacade = (IKSQLFacade)RpcProxy.wrapRequired(IKSQLFacade.class, (String)"com.kingdee.eas.csinterface.utils.KSQLFacade");
            String msg = ksqlFacade.obtainTableAssignToAgent(agent, sql, tableNames);
            if (!StringUtils.isEmpty((String)msg)) {
                MsgBox.showWarning((String)msg);
            } else {
                MsgBox.showInfo((String)("\u4efb\u52a1\u5df2\u6210\u529f\u5206\u914d\u7ed9\u5ba2\u6237\u4ee3\u7406'" + agent.getNumber() + "'"));
            }
        } else if (DataSourceType.remoteService.equals((Object)dsType)) {
            ArrayList ids;
            final WSServiceInfo service = (WSServiceInfo)this.prmpservice.getData();
            if (service == null) {
                MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u8fdc\u7a0b\u670d\u52a1");
                SysUtil.abort();
            }
            if ((ids = this.getSelectedIdValues()) == null || ids.isEmpty()) {
                MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u66f4\u65b0\u7684\u6570\u636e\u884c");
                SysUtil.abort();
            }
            final LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u5904\u7406\u66f4\u65b0\u4e2d", "\u8bf7\u7a0d\u540e");
            dialog.setLongTimeTask(new ILongTimeTask2(){
                private Exception exception;
                String excMsg = "";
                StringBuilder error = new StringBuilder();

                @Override
                public Object exec() throws Exception {
                    try {
                        int sum = ids.size();
                        for (int i = 0; i < sum; ++i) {
                            dialog.updateMsg("\u6b63\u5728\u6267\u884c\u66f4\u65b0(" + (i + 1) + "/" + sum + ")  \u8868:" + TableStructureListUI.this.getTableByID((String)ids.get(i)));
                            try {
                                TableStructureFactory.getRemoteInstance().updateColumnsByInfo((String)ids.get(i), service);
                                continue;
                            }
                            catch (Exception e) {
                                this.error.append("\u8868" + TableStructureListUI.this.getTableByID((String)ids.get(i)) + "\u66f4\u65b0\u5931\u8d25:" + e.getMessage());
                            }
                        }
                        return "success";
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.exception = e;
                        return this.excMsg;
                    }
                }

                @Override
                public void afterExec(Object result) throws Exception {
                    if (!StringUtils.isEmpty((String)this.error.toString())) {
                        Exception ca = new Exception(this.error.toString());
                        MsgBox.showDetailAndOK((Component)((Object)TableStructureListUI.this), (String)"\u90e8\u5206\u5931\u8d25", (String)ThrowableHelper.toString((Throwable)ca), (int)1);
                    } else {
                        MsgBox.showInfo((String)"\u6267\u884c\u6210\u529f");
                    }
                }
            });
            dialog.show();
        }
    }

    @Override
    public void actionObtain_actionPerformed(ActionEvent e) throws Exception {
        DataSourceType dsType = (DataSourceType)((Object)this.comDsType.getSelectedItem());
        if (dsType == null) {
            MsgBox.showInfo((String)"\u4e0d\u652f\u6301\u7684\u8d44\u6e90\u7c7b\u578b");
            SysUtil.abort();
        }
        if (DataSourceType.jdbc.equals((Object)dsType) && this.prmtConn.getData() == null) {
            MsgBox.showInfo((String)"\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            SysUtil.abort();
        } else if (DataSourceType.agent.equals((Object)dsType) && this.prmtAgent.getData() == null) {
            MsgBox.showInfo((String)"\u5ba2\u6237\u7aef\u4ee3\u7406\u4e0d\u80fd\u4e3a\u7a7a");
            SysUtil.abort();
        }
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        uiContext.put("Owner", (Object)this);
        uiContext.put("dsType", (Object)dsType);
        uiContext.put("conn", this.prmtConn.getData());
        uiContext.put("agent", this.prmtAgent.getData());
        IUIWindow uiWindow = uiFactory.create(TableNameEditUI.class.getName(), uiContext, this.dataObjects, OprtState.ADDNEW);
        uiWindow.show();
    }

    public String getTableByID(String id) {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            String idTmp = (String)this.tblMain.getRow(i).getCell("id").getValue();
            if (!id.equals(idTmp)) continue;
            String tableName = (String)this.tblMain.getRow(i).getCell("tableName").getValue();
            return tableName;
        }
        return null;
    }

    private void initMainQuery() {
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
            this.setDataObject((IObjectValue)this.mainQuery);
        }
        try {
            this.mainQuery = this.getEntityViewInfo(this.mainQuery);
        }
        catch (BOSException ex) {
            this.handleException((Exception)((Object)ex));
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }
}

