/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.ISQLFacade;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.csinterface.util.DataTypeConverter;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.Map;
import org.apache.log4j.Logger;

public class BaseDataSynHelper {
    private static final Logger logger = Logger.getLogger(BaseDataSynHelper.class);

    public static void initPlanTableDefine(KDTable kDTable, Map<String, IRowSet> tableDefine) throws BOSException, EASBizException {
        final KDTable threadTable = kDTable;
        final Map<String, IRowSet> threadDef = tableDefine;
        Thread loadTable = new Thread(new Runnable(){

            @Override
            public void run() {
                DataTypeConverter converter = new DataTypeConverter();
                int tableCount = threadTable.getRowCount();
                for (int i = 0; i < tableCount; ++i) {
                    IRow row = threadTable.getRow(i);
                    String tableName = BaseDataSynHelper.trimObject(row.getCell("tableName").getValue());
                    if (StringUtils.isEmpty((String)tableName)) continue;
                    String ksql = converter.getColumnDefinedSql(tableName);
                    try {
                        ISQLFacade sqlFacader = SQLFacadeFactory.getRemoteInstance();
                        IRowSet rowset = sqlFacader.getRowset(ksql);
                        threadDef.put(tableName, rowset);
                        continue;
                    }
                    catch (BOSException e) {
                        logger.error((Object)e);
                        continue;
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e);
                    }
                }
            }
        });
        tableDefine.clear();
        tableDefine.putAll(threadDef);
    }

    public static String trimObject(Object obj) {
        return obj == null ? "" : obj.toString();
    }
}

