/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.client.util;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.DatePickerRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.util.ColumnInfo;
import com.kingdee.eas.csinterface.util.DataTypeConverter;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class CellRenderUtil {
    private static DatePickerRender dateRender = new DateRender();

    public static void initCellRenderByType(DBType destDBType, ICell cell, ColumnInfo columnInfo, boolean newRow) {
        SQLType sqlType = SQLType.getEnum((String)columnInfo.getDATA_TYPE());
        if (sqlType == null) {
            DataTypeConverter convert = DataTypeConverter.getConverter(destDBType);
            try {
                sqlType = convert.convert(columnInfo.getDATA_TYPE());
            }
            catch (Exception e) {
                KDTextField txtField = new KDTextField();
                txtField.setEnabled(true);
                KDTDefaultCellEditor defaultEdit = new KDTDefaultCellEditor((JTextField)txtField);
                cell.setEditor((ICellEditor)defaultEdit);
            }
        }
        if (sqlType == null) {
            return;
        }
        int length = 0;
        try {
            length = Integer.valueOf(columnInfo.getDEFAULT_LENGTH());
            if (StringUtils.isEmpty((String)columnInfo.getDEFAULT_LENGTH())) {
                length = Integer.valueOf(columnInfo.getDATA_LENGTH());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int precision = 0;
        try {
            precision = Integer.valueOf(columnInfo.getDATA_PRECISION());
        }
        catch (Exception txtField) {
            // empty catch block
        }
        int scale = 0;
        try {
            scale = Integer.valueOf(columnInfo.getDATA_SCALE());
        }
        catch (Exception defaultEdit) {
            // empty catch block
        }
        boolean nullable = true;
        if ("N".equalsIgnoreCase(columnInfo.getNULLABLE()) || "0".equalsIgnoreCase(columnInfo.getNULLABLE())) {
            nullable = false;
        }
        if (SQLType.INT.equals((Object)sqlType)) {
            KDFormattedTextField txtField = new KDFormattedTextField();
            txtField.setDataType(0);
            txtField.setPrecision(precision);
            txtField.setRequired(!nullable && newRow);
            txtField.setSupportedEmpty(true);
            txtField.setForeground(new Color(0, 0, 0));
            KDTDefaultCellEditor defaultEdit = new KDTDefaultCellEditor((JTextField)txtField);
            cell.setEditor((ICellEditor)defaultEdit);
        } else if (SQLType.NUMERIC.equals((Object)sqlType)) {
            KDFormattedTextField txtField = new KDFormattedTextField();
            txtField.setPrecision(precision);
            txtField.setRequired(!nullable && newRow);
            txtField.setSupportedEmpty(true);
            txtField.setForeground(new Color(0, 0, 0));
            KDTDefaultCellEditor defaultEdit = new KDTDefaultCellEditor((JTextField)txtField);
            cell.setEditor((ICellEditor)defaultEdit);
        } else if (SQLType.CHAR.equals((Object)sqlType) || SQLType.VARCHAR.equals((Object)sqlType)) {
            KDTextField txtField = new KDTextField();
            txtField.setEnabled(true);
            txtField.setMaxLength(length);
            txtField.setRequired(!nullable && newRow);
            KDTDefaultCellEditor defaultEdit = new KDTDefaultCellEditor((JTextField)txtField);
            cell.setEditor((ICellEditor)defaultEdit);
        } else if (SQLType.NCHAR.equals((Object)sqlType) || SQLType.NVARCHAR.equals((Object)sqlType)) {
            if (DBType.SQLServer.equals((Object)destDBType)) {
                length /= 2;
            } else if (DBType.Oracle.equals((Object)destDBType)) {
                length /= 3;
            }
            KDTextField txtField = new KDTextField();
            txtField.setEnabled(true);
            txtField.setMaxLength(length);
            txtField.setRequired(!nullable && newRow);
            KDTDefaultCellEditor defaultEdit = new KDTDefaultCellEditor((JTextField)txtField);
            cell.setEditor((ICellEditor)defaultEdit);
        } else if (SQLType.DATETIME.equals((Object)sqlType)) {
            CellRenderUtil.initDateEditor(cell);
        } else if (SQLType.BINARY.equals((Object)sqlType) || SQLType.VARBINARY.equals((Object)sqlType)) {
            KDFormattedTextField txtField = new KDFormattedTextField();
            txtField.setDataType(6);
            txtField.setPrecision(precision);
            txtField.setRequired(!nullable && newRow);
            txtField.setSupportedEmpty(true);
            txtField.setForeground(new Color(0, 0, 0));
            KDTDefaultCellEditor defaultEdit = new KDTDefaultCellEditor((JTextField)txtField);
            cell.setEditor((ICellEditor)defaultEdit);
        } else if (SQLType.BLOB.equals((Object)sqlType) || SQLType.CLOB.equals((Object)sqlType) || SQLType.NCLOB.equals((Object)sqlType)) {
            KDTextField txtField = new KDTextField();
            txtField.setEnabled(true);
            txtField.setRequired(!nullable && newRow);
            KDTDefaultCellEditor defaultEdit = new KDTDefaultCellEditor((JTextField)txtField);
            cell.setEditor((ICellEditor)defaultEdit);
        } else {
            cell.setEditor(null);
        }
        if (!nullable && newRow) {
            cell.getStyleAttributes().setBackground(UIManager.getColor("TextField.requiredBackground"));
        }
    }

    public static void initDateEditor(ICell cell) {
        System.setProperty("NoDate", "false");
        KDDatePicker kdtEntrys_dateValue_DatePicker = new KDDatePicker();
        kdtEntrys_dateValue_DatePicker.setEditable(false);
        kdtEntrys_dateValue_DatePicker.setName("kdtEntrys_dateValue_DatePicker");
        kdtEntrys_dateValue_DatePicker.setVisible(true);
        kdtEntrys_dateValue_DatePicker.setEditable(true);
        kdtEntrys_dateValue_DatePicker.setTimeEnabled(true);
        kdtEntrys_dateValue_DatePicker.setDatePattern("yyyy-MM-dd HH:mm:ss.SSS");
        KDTDefaultCellEditor kdtEntrys_dateValue_CellEditor = new KDTDefaultCellEditor(kdtEntrys_dateValue_DatePicker);
        cell.setRenderer((IBasicRender)dateRender);
        cell.getFormattedStyleAttributes().setNumberFormat("yyyy-MM-dd HH:mm:ss.SSS");
        cell.setEditor((ICellEditor)kdtEntrys_dateValue_CellEditor);
    }

    private static class DateRender
    extends DatePickerRender {
        private DateRender() {
        }

        protected String getText(Object obj) {
            if (obj instanceof Date) {
                return DateTimeUtils.format((Date)((Date)obj), (String)"yyyy-MM-dd HH:mm:ss.SSS");
            }
            if (obj instanceof String) {
                SimpleDateFormat sdf = new SimpleDateFormat("E MMM dd HH:mm:ss z yyyy", Locale.US);
                Date date = null;
                try {
                    date = sdf.parse((String)obj);
                }
                catch (ParseException e) {
                    return super.getText(obj);
                }
                return DateTimeUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss.SSS");
            }
            return super.getText(obj);
        }
    }
}

