/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.model;

import com.kingdee.eas.csinterface.biz.data.PKTableData;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PKTable {
    private static final Logger logger = Logger.getLogger(PKTable.class);
    private String tableName;
    private String pkTableName;
    private ConnectionInfo conn;
    private List<PKTableData> pkTableDatas = new ArrayList<PKTableData>();

    public static PKTable getPKTable(String tableName, ConnectionInfo conn) {
        return new PKTable(tableName, conn);
    }

    public PKTable() {
    }

    public PKTable(String tableName, ConnectionInfo conn) {
        this.tableName = tableName;
        this.conn = conn;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getPkTableName() {
        if (this.pkTableName == null && this.tableName != null) {
            String name = this.tableName.substring(this.tableName.lastIndexOf(95) + 1);
            String fullName = "T_EIP_BZ_" + name;
            if (fullName.equalsIgnoreCase(this.tableName)) {
                fullName = "T_EIP_BZT_" + name;
            }
            if (fullName.length() > 30) {
                fullName = fullName.substring(0, 30);
            }
            this.pkTableName = fullName;
        }
        return this.pkTableName;
    }

    public void setPkTableName(String pkTableName) {
        this.pkTableName = pkTableName;
    }

    public ConnectionInfo getConnection() {
        return this.conn;
    }

    public void setConnid(ConnectionInfo conn) {
        this.conn = conn;
    }

    public String getCreateSql() {
        StringBuilder sb = new StringBuilder("create table " + this.getPkTableName());
        sb.append(" (");
        sb.append(" headpk varchar(44)");
        sb.append(", changeTime datetime");
        sb.append(", hashCode varchar(64)");
        sb.append(", agentId varchar(64)");
        sb.append(", status int");
        sb.append(", changeStatus int default 0");
        sb.append(", createTime datetime");
        sb.append(", mainpk varchar(80)");
        sb.append(")");
        return sb.toString();
    }

    public String getNotIn() {
        StringBuilder sb = new StringBuilder(" not exists(select 1 from ").append(this.getPkTableName()).append(" p").append(" where ").append("t1.${keyField}").append(" = p.headpk").append(" AND p.agentId = '").append(this.conn.getId()).append("'").append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate() {
        String sql = PKTableData.toUpdateSql(this.getPkTableName());
        Connection connection = null;
        PreparedStatement stat = null;
        try {
            connection = KSQLUtil.getConnection(this.conn);
            stat = connection.prepareStatement(sql);
            for (PKTableData pkTableData : this.pkTableDatas) {
                pkTableData.addBatchUpdate(stat);
            }
            stat.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"\u3010EIP\u3011\u66f4\u65b0\u589e\u91cf\u8868\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stat, (Connection)connection);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)stat, (Connection)connection);
        }
        SQLUtils.cleanup((Statement)stat, (Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDelete() {
        String sql = PKTableData.toDeleteSql(this.getPkTableName());
        Connection connection = null;
        PreparedStatement stat = null;
        try {
            connection = KSQLUtil.getConnection(this.conn);
            stat = connection.prepareStatement(sql);
            for (PKTableData pkTableData : this.pkTableDatas) {
                pkTableData.addBatchDelete(stat);
            }
            stat.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"\u3010EIP\u3011\u66f4\u65b0\u589e\u91cf\u8868\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stat, (Connection)connection);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)stat, (Connection)connection);
        }
        SQLUtils.cleanup((Statement)stat, (Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInsert() {
        String sql = PKTableData.toInsertSql(this.getPkTableName());
        Connection connection = null;
        PreparedStatement stat = null;
        try {
            connection = KSQLUtil.getConnection(this.conn);
            stat = connection.prepareStatement(sql);
            for (PKTableData pkTableData : this.pkTableDatas) {
                pkTableData.addBatchInsert(stat);
            }
            stat.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)"\u3010EIP\u3011\u63d2\u5165\u589e\u91cf\u8868\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stat, (Connection)connection);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)stat, (Connection)connection);
        }
        SQLUtils.cleanup((Statement)stat, (Connection)connection);
    }

    public String getAllViewName() {
        return this.tableName + "_ALL";
    }

    public String getCreateAllViewSql() {
        StringBuilder sb = new StringBuilder("create table " + this.getAllViewName());
        sb.append(" (");
        sb.append(" headpk varchar(44)");
        sb.append(")");
        return sb.toString();
    }

    public void addTableData(PKTableData tableData) {
        this.pkTableDatas.add(tableData);
    }

    public int size() {
        return this.pkTableDatas.size();
    }
}

