/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.converter.core;

import com.kingdee.eas.csinterface.converter.core.Converter;
import com.kingdee.eas.csinterface.converter.core.ConverterLookup;
import com.kingdee.eas.csinterface.converter.core.ConverterRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultConverterLookup
implements ConverterLookup,
ConverterRegistry {
    private List<Converter> converterList = new ArrayList<Converter>();
    private transient Map typeToConverterMap = Collections.synchronizedMap(new HashMap());

    @Override
    public Converter lookupConverterForType(Class type) {
        Converter cachedConverter = (Converter)this.typeToConverterMap.get(type);
        if (cachedConverter != null) {
            return cachedConverter;
        }
        for (Converter converter : this.converterList) {
            if (!converter.canConvert(type)) continue;
            this.typeToConverterMap.put(type, converter);
            return converter;
        }
        return null;
    }

    @Override
    public void registerConverter(Converter converter) {
        if (null != converter) {
            this.converterList.add(converter);
            Iterator iterator = this.typeToConverterMap.keySet().iterator();
            while (iterator.hasNext()) {
                Class type = (Class)iterator.next();
                if (!converter.canConvert(type)) continue;
                iterator.remove();
            }
        }
    }
}

