/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.data.provider.db;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.billmapping.BillMappingHelper;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.DataColumn;
import com.kingdee.eas.csinterface.data.DataExtractor;
import com.kingdee.eas.csinterface.data.model.DataRow;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.data.model.StructuredTableData;
import com.kingdee.eas.csinterface.data.provider.FlatData;
import com.kingdee.eas.csinterface.data.provider.IDataProvider;
import com.kingdee.eas.csinterface.data.snapshot.ChangefulBillData;
import com.kingdee.eas.csinterface.monitor.app.FeedBackManager;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MiddleBillDataProvider
implements IDataProvider {
    private static final Logger logger = Logger.getLogger(MiddleBillDataProvider.class);
    public static final int MAX_FETCH_SIZE = 100000;
    public static int DEFAULT_FETCH_SIZE = 1000;
    private Connection connection;
    private PreparedStatement readingStatement;
    private PreparedStatement writePkBackStatment;
    private StructuredDataModel dataModel;
    private DataColumn[] flatDataColumns;
    private String pkTableName;
    private String srcViewName;
    private String srcWhere;
    private int pageSize;
    private StringBuffer queryString;
    private int realPageSize;
    private int headpkIndex;
    private String[] sortedChangefulFields;
    private boolean isOracle;

    public int setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return pageSize;
    }

    public MiddleBillDataProvider(StructuredDataModel dataModel) {
        this.dataModel = dataModel;
        this.srcWhere = StringUtils.trim((String)((String)this.dataModel.getProperty("srcWhere")));
        this.srcViewName = (String)this.dataModel.getProperty("srcViewName");
        this.pkTableName = (String)this.dataModel.getProperty("pkTableName");
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        ArrayList<DataColumn> flatDataColumns = new ArrayList<DataColumn>();
        for (int i = 0; i < tableModels.length; ++i) {
            for (int j = 0; j < tableModels[i].columns.length; ++j) {
                DataColumn column = new DataColumn(tableModels[i].columns[j].name, tableModels[i].columns[j].alias);
                flatDataColumns.add(column);
            }
        }
        this.flatDataColumns = flatDataColumns.toArray(new DataColumn[0]);
        this.sortedChangefulFields = ChangefulBillData.getSortedChangefulFields(dataModel);
        this.isOracle = ((ConnectionInfo)this.dataModel.getProperty("srcDBConn")).getDBType().equals((Object)DBType.Oracle);
    }

    @Override
    public void open() throws DIPException {
        try {
            ConnectionInfo connectionInfo = (ConnectionInfo)this.dataModel.getProperty("srcDBConn");
            this.connection = KSQLUtil.getConnection(connectionInfo);
            this.connection.setAutoCommit(true);
        }
        catch (Exception e) {
            throw new DIPException("\u6253\u5f00\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25:" + e.getMessage(), e);
        }
        try {
            ChangefulBillData.addHashCodeColumnIfNeed(this.connection, this.pkTableName);
            ChangefulBillData.addCreateTimeColumnIfNeed(this.connection, this.pkTableName);
        }
        catch (SQLException e) {
            throw new DIPException(e.getMessage(), e);
        }
    }

    @Override
    public Connection getConnection() throws DIPException {
        return this.connection;
    }

    @Override
    public FlatData fetchData(Map param) throws DIPException {
        List subPks;
        if (this.pageSize <= 0) {
            try {
                Object pageSize = param.get("pageSize");
                this.pageSize = pageSize == null ? DEFAULT_FETCH_SIZE : Integer.parseInt(pageSize.toString());
                this.pageSize = this.pageSize > DEFAULT_FETCH_SIZE ? DEFAULT_FETCH_SIZE : this.pageSize;
            }
            catch (Exception e) {
                this.pageSize = DEFAULT_FETCH_SIZE;
            }
        }
        String filterString = null;
        if (param != null && (subPks = (List)param.get("SUB_PKS")) != null) {
            filterString = StringUtils.arrayToString((Object[])subPks.toArray(), (String)",");
        }
        boolean isBillGetSrcData = true;
        if (param.containsKey("isBillGetSrcData")) {
            isBillGetSrcData = (Boolean)param.get("isBillGetSrcData");
        }
        if (isBillGetSrcData) {
            return this.fetchDataByMiddleData(param, filterString);
        }
        return this.fetchDataBySrcData(param, filterString);
    }

    public FlatData fetchDataBySrcData(Map param, String filterString) throws DIPException {
        FlatData flatData;
        Long time1 = null;
        Long time2 = null;
        ResultSet rs = null;
        StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
        int columnCount = tableModels[0].columns.length + tableModels[1].columns.length;
        Object headpkVal = null;
        FlatData flatData2 = new FlatData(this.flatDataColumns);
        try {
            Long starttime1 = System.currentTimeMillis();
            List headpkList = (List)param.get("heapkList");
            if (headpkList != null) {
                this.initQueryString(filterString);
            } else {
                this.initGetSrcDataQueryString(param);
            }
            try {
                this.readingStatement = this.connection.prepareStatement(this.queryString.toString(), 1003, 1007);
            }
            catch (SQLException e) {
                logger.error((Object)("\u83b7\u53d6\u6e90\u7cfb\u7edf\u6570\u636e\u65f6\u6267\u884cSQL\u51fa\u9519\uff1a" + e.getMessage() + "\uff0cSQL:" + this.queryString.toString()));
                throw new DIPException("create readingStatement error", e);
            }
            try {
                rs = this.readingStatement.executeQuery();
                logger.debug((Object)("XG_\u67e5\u8be2sql\uff1a\n" + this.queryString.toString()));
            }
            catch (SQLException e) {
                logger.error((Object)("::::\u6e90\u7cfb\u7edf\u6570\u636e\u83b7\u53d6\u5f02\u5e38\uff0c\u67e5\u8be2SQL\uff1a" + this.queryString));
                throw new DIPException("\u8bfb\u53d6\u6570\u636e\u5f02\u5e38,\u89c6\u56fe\u4e2d\u7f3a\u5c11\u4e1a\u52a1\u5355\u636e\u6620\u5c04\u6240\u914d\u7f6e\u7684\u5b57\u6bb5: " + e.getMessage() + (StringUtils.isEmpty((String)filterString) ? "" : "\uff0c\u7528\u6237\u5b9a\u5236\u67e5\u8be2\u6761\u4ef6\u4e3a\uff1a\u201c" + filterString + "\u201d"), e);
            }
            Long starttime2 = System.currentTimeMillis();
            time1 = starttime2 - starttime1;
            Long starttime3 = System.currentTimeMillis();
            while (rs.next()) {
                headpkVal = rs.getObject(this.headpkIndex);
                if (headpkVal == null) {
                    throw new DIPException("headpk column value is null!");
                }
                FlatData.FlatDataRow flatDataRow = flatData2.createFlatDataRow();
                flatData2.addDataRow(flatDataRow);
                for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                    Object obj = rs.getObject(columnIndex);
                    if (obj instanceof BigDecimal) {
                        obj = ((BigDecimal)obj).toPlainString();
                    }
                    flatDataRow.set(columnIndex - 1, obj);
                }
            }
            Long starttime4 = System.currentTimeMillis();
            time2 = starttime4 - starttime3;
            flatData = flatData2;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("::::\u6e90\u7cfb\u7edf\u6570\u636e\u83b7\u53d6\u5f02\u5e38\u67e5\u8be2SQL\uff1a" + this.queryString));
                throw new DIPException("\u8bfb\u53d6\u6570\u636e\u5f02\u5e38: " + e.getMessage() + (StringUtils.isEmpty((String)filterString) ? "" : "\uff0c\u7528\u6237\u5b9a\u5236\u67e5\u8be2\u6761\u4ef6\u4e3a\uff1a\u201c" + filterString + "\u201d"), e);
            }
            catch (Throwable throwable) {
                logger.error((Object)("\u6e90\u7cfb\u7edf\u6570\u636e\u83b7\u53d6\u8017\u65f6(ms)\uff1a" + time1 + " \u6570\u636e\u8f6c\u6362\u8017\u65f6\uff1a" + time2));
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        logger.error((Object)("\u6e90\u7cfb\u7edf\u6570\u636e\u83b7\u53d6\u8017\u65f6(ms)\uff1a" + time1 + " \u6570\u636e\u8f6c\u6362\u8017\u65f6\uff1a" + time2));
        SQLUtils.cleanup((ResultSet)rs);
        return flatData;
    }

    private void initGetSrcDataQueryString(Map param) {
        int i;
        StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        StructuredDataModel.TableModel entry = tableModels[1];
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select distinct ");
        String headPkName = null;
        String entryPkName = null;
        int colNum = 0;
        for (i = 0; i < header.columns.length; ++i) {
            if (colNum > 0) {
                sqlBuf.append(", ");
            }
            if (header.columns[i].isPk) {
                headPkName = header.columns[i].name;
                this.headpkIndex = i + 1;
            }
            sqlBuf.append("v1.").append(header.columns[i].name);
            ++colNum;
        }
        for (i = 0; i < entry.columns.length; ++i) {
            if (colNum > 0) {
                sqlBuf.append(", ");
            }
            if (entry.columns[i].isPk) {
                entryPkName = entry.columns[i].name;
            }
            sqlBuf.append("v1.").append(entry.columns[i].name);
        }
        sqlBuf.append(" from ").append(this.srcViewName).append(" as v1");
        sqlBuf.append(" where v1.").append(headPkName).append(" in (");
        StringBuilder findPKsSql = (StringBuilder)param.get("findPKsSql");
        int newPageSize = (Integer)param.get("newPageSize");
        if (DBType.MySql == param.get("DBTYPE")) {
            findPKsSql.insert(0, "select tt.headpk from (");
            findPKsSql.append(" limit " + newPageSize + ") tt");
        } else {
            int index = findPKsSql.indexOf("select") + 6;
            findPKsSql.insert(index, " top " + newPageSize + " ");
        }
        sqlBuf.append((CharSequence)findPKsSql);
        sqlBuf.append(") order by v1.").append(headPkName).append(", v1.").append(entryPkName).append(" asc");
        this.queryString = sqlBuf;
        logger.error((Object)("in\u4e2d\u7684sql\u8bed\u53e5:" + sqlBuf));
    }

    private void initMidBillDataQueryString(Map param) {
        int i;
        StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        StructuredDataModel.TableModel entry = tableModels[1];
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select distinct ");
        String headPkName = null;
        String entryPkName = null;
        int colNum = 0;
        for (i = 0; i < header.columns.length; ++i) {
            if (colNum > 0) {
                sqlBuf.append(", ");
            }
            if (header.columns[i].isPk) {
                headPkName = header.columns[i].name;
                this.headpkIndex = i + 1;
            }
            sqlBuf.append("v1.").append(header.columns[i].name);
            ++colNum;
        }
        for (i = 0; i < entry.columns.length; ++i) {
            if (colNum > 0) {
                sqlBuf.append(", ");
            }
            if (entry.columns[i].isPk) {
                entryPkName = entry.columns[i].name;
            }
            sqlBuf.append("v1.").append(entry.columns[i].name);
        }
        sqlBuf.append(" from ").append(this.srcViewName).append(" v1 ");
        sqlBuf.append(" where v1.").append(headPkName).append(" in (");
        i = (Integer)param.get("i");
        int pageSize = (Integer)param.get("pageSize");
        String tempTableName = (String)param.get("tempTableName");
        DBType dbType = (DBType)((Object)param.get("DBTYPE"));
        sqlBuf.append(this.initQueryStringFromTempTable(i, pageSize, tempTableName));
        sqlBuf.append(") order by v1.").append(headPkName).append(", v1.").append(entryPkName).append(" asc");
        this.queryString = sqlBuf;
    }

    private String initQueryStringFromTempTable(int i, int pageSize, String tempTableName) {
        String sql = "";
        sql = DataExtractor.isNewType ? "select headpk from " + tempTableName + " where batchNo = " + i : "select top " + pageSize + " headpk from " + tempTableName + " order by headpk ";
        return sql;
    }

    public FlatData fetchDataByMiddleData(Map param, String filterString) throws DIPException {
        FlatData flatData;
        Long time1 = null;
        Long time2 = null;
        ResultSet rs = null;
        StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
        int columnCount = tableModels[0].columns.length + tableModels[1].columns.length;
        Object headpkVal = null;
        Object lastHeadpkVal = null;
        ChangefulBillData changefulBillData = null;
        FlatData flatData2 = new FlatData(this.flatDataColumns);
        try {
            Long starttime1 = System.currentTimeMillis();
            this.initMidBillDataQueryString(param);
            try {
                this.readingStatement = this.connection.prepareStatement(this.queryString.toString(), 1003, 1007);
            }
            catch (SQLException e) {
                logger.error((Object)("\u751f\u6210\u4e2d\u95f4\u5355\u6570\u636e\u65f6\u6267\u884cSQL\u51fa\u9519\uff1a" + e.getMessage() + "\uff0cSQL:" + this.queryString.toString()));
                throw new DIPException("create readingStatement error", e);
            }
            try {
                rs = this.readingStatement.executeQuery();
            }
            catch (SQLException e) {
                logger.error((Object)("::::\u751f\u6210\u4e2d\u95f4\u5355\u6570\u636e\u65f6\u6267\u884c\u67e5\u8be2\u5f02\u5e38SQL\uff1a" + this.queryString));
                throw new DIPException("\u751f\u6210\u4e2d\u95f4\u5355\uff0c\u8bfb\u53d6\u6570\u636e\u5f02\u5e38,\u89c6\u56fe\u4e2d\u7f3a\u5c11\u4e1a\u52a1\u5355\u636e\u6620\u5c04\u6240\u914d\u7f6e\u7684\u5b57\u6bb5: " + e.getMessage() + (StringUtils.isEmpty((String)filterString) ? "" : "\uff0c\u7528\u6237\u5b9a\u5236\u67e5\u8be2\u6761\u4ef6\u4e3a\uff1a\u201c" + filterString + "\u201d"), e);
            }
            Long starttime2 = System.currentTimeMillis();
            time1 = starttime2 - starttime1;
            Long starttime3 = System.currentTimeMillis();
            boolean isFeedBack = (Boolean)this.dataModel.getProperty("feedBackEnable");
            ArrayList<Object> headpkList = new ArrayList<Object>();
            while (rs.next()) {
                headpkVal = rs.getObject(this.headpkIndex);
                if (isFeedBack) {
                    headpkList.add(headpkVal);
                }
                if (headpkVal == null) {
                    throw new NullPointerException("headpk column value is null!");
                }
                int columnIndex = 1;
                if (!headpkVal.equals(lastHeadpkVal)) {
                    if (changefulBillData != null) {
                        changefulBillData.snapshot();
                        flatData2.putBillDataHashCode(lastHeadpkVal, changefulBillData.getNewHashCode());
                    }
                    lastHeadpkVal = headpkVal;
                    if (this.sortedChangefulFields != null && this.sortedChangefulFields.length != 0) {
                        changefulBillData = new ChangefulBillData(this.sortedChangefulFields, this.isOracle, false);
                    }
                }
                if (changefulBillData != null) {
                    changefulBillData.appendFieldBytesByMiddleBill(rs);
                }
                FlatData.FlatDataRow flatDataRow = flatData2.createFlatDataRow();
                flatData2.addDataRow(flatDataRow);
                while (columnIndex <= columnCount) {
                    Object obj = rs.getObject(columnIndex);
                    if (obj instanceof BigDecimal) {
                        obj = ((BigDecimal)obj).toPlainString();
                    }
                    flatDataRow.set(columnIndex - 1, obj);
                    ++columnIndex;
                }
            }
            if (changefulBillData != null) {
                changefulBillData.snapshot();
                flatData2.putBillDataHashCode(headpkVal, changefulBillData.getNewHashCode());
            }
            Long starttime4 = System.currentTimeMillis();
            time2 = starttime4 - starttime3;
            param.put("SUB_PKS", headpkList);
            flatData = flatData2;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("::::\u751f\u6210\u4e2d\u95f4\u5355\u8fc7\u7a0b\u83b7\u53d6\u6570\u636e\u5f02\u5e38SQL\uff1a" + this.queryString));
                throw new DIPException("\u8bfb\u53d6\u6570\u636e\u5f02\u5e38: " + e.getMessage() + (StringUtils.isEmpty((String)filterString) ? "" : "\uff0c\u7528\u6237\u5b9a\u5236\u67e5\u8be2\u6761\u4ef6\u4e3a\uff1a\u201c" + filterString + "\u201d"), e);
            }
            catch (Throwable throwable) {
                logger.error((Object)("\u751f\u6210\u4e2d\u95f4\u5355\u6570\u636e\u83b7\u53d6\u8017\u65f6(ms)\uff1a" + time1 + " \u6570\u636e\u8f6c\u6362\u8017\u65f6\uff1a" + time2));
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        logger.error((Object)("\u751f\u6210\u4e2d\u95f4\u5355\u6570\u636e\u83b7\u53d6\u8017\u65f6(ms)\uff1a" + time1 + " \u6570\u636e\u8f6c\u6362\u8017\u65f6\uff1a" + time2));
        SQLUtils.cleanup((ResultSet)rs);
        return flatData;
    }

    private void initQueryString(String filterString) {
        int i;
        StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        StructuredDataModel.TableModel entry = tableModels[1];
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select distinct ");
        String headPkName = null;
        String entryPkName = null;
        int colNum = 0;
        for (i = 0; i < header.columns.length; ++i) {
            if (colNum > 0) {
                sqlBuf.append(", ");
            }
            if (header.columns[i].isPk) {
                headPkName = header.columns[i].name;
                this.headpkIndex = i + 1;
            }
            sqlBuf.append("v1.").append(header.columns[i].name);
            ++colNum;
        }
        for (i = 0; i < entry.columns.length; ++i) {
            if (colNum > 0) {
                sqlBuf.append(", ");
            }
            if (entry.columns[i].isPk) {
                entryPkName = entry.columns[i].name;
            }
            sqlBuf.append("v1.").append(entry.columns[i].name);
        }
        sqlBuf.append(" from ").append(this.srcViewName).append(" as v1");
        sqlBuf.append(" where v1.").append(headPkName).append(" in (");
        sqlBuf.append(filterString);
        sqlBuf.append(") order by v1.").append(headPkName).append(", v1.").append(entryPkName).append(" asc");
        this.queryString = sqlBuf;
    }

    @Override
    public int dealHeadpks(Map param) throws BOSException {
        ResultSet rs;
        PreparedStatement statement;
        int count;
        block8: {
            count = 0;
            StringBuilder qrySql = new StringBuilder();
            boolean save = (Boolean)param.get("save");
            if (save) {
                qrySql.append("insert into " + param.get("tempTableName"));
            } else {
                qrySql.append("select count(1)  from ( ");
            }
            qrySql.append(this.getHeadpkQrySql(param));
            statement = null;
            rs = null;
            try {
                if (save) {
                    statement = this.connection.prepareStatement(qrySql.toString());
                    count = statement.executeUpdate();
                    break block8;
                }
                statement = this.connection.prepareStatement(qrySql.append(" ) v4").toString());
                rs = statement.executeQuery();
                while (rs.next()) {
                    count = rs.getInt(1);
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, statement);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement);
        return count;
    }

    @Override
    public List<Object> findAllHeadPks(Map param) throws BOSException {
        ArrayList<Object> result = new ArrayList<Object>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.connection.prepareStatement(this.getHeadpkQrySql(param), 1003, 1007);
            rs = statement.executeQuery();
            while (rs.next()) {
                result.add("'" + rs.getString(1) + "'");
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement);
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.realPageSize >= this.pageSize;
    }

    @Override
    public void close() throws DIPException {
        SQLUtils.cleanup((Statement)this.writePkBackStatment);
        SQLUtils.cleanup((Statement)this.readingStatement);
        SQLUtils.cleanup((Connection)this.connection);
    }

    @Override
    public String getProviderID() {
        return this.toString();
    }

    @Override
    public String getDescription() {
        return "HD\u5355\u636e\u6570\u636e\u6e90";
    }

    @Override
    public void feedbackFinishStructured(FlatData succeedFlatData, StructuredTableData structuredTableData) throws DIPException {
        this.realPageSize = structuredTableData == null || structuredTableData.getFirstTableRows() == null ? 0 : structuredTableData.getFirstTableRows().size();
    }

    @Override
    public void feedbackFinish(StructuredTableData structuredTableData, StructuredTableData succeedStructuredTableData) throws DIPException {
        if (succeedStructuredTableData == null || succeedStructuredTableData.getFirstTableRows() == null) {
            return;
        }
        Map<Object, String> billDataHashCodeMap = succeedStructuredTableData.getBillDataHashCodeMap();
        List headDataRows = succeedStructuredTableData.getFirstTableRows();
        if (headDataRows != null && headDataRows.size() > 0) {
            String pkColumn = ((DataRow)headDataRows.get((int)0)).pkColumn;
            int count = 0;
            try {
                if (this.writePkBackStatment == null) {
                    String driverType = this.connection.getMetaData().getDatabaseProductName();
                    if (driverType.equalsIgnoreCase("PostgreSQL")) {
                        this.pkTableName = this.pkTableName.replace("\"", "");
                    }
                    this.writePkBackStatment = this.connection.prepareStatement("insert into " + this.pkTableName + " ( " + "headpk" + "," + "hashCode" + "," + "createTime" + ") values (?,?,?)");
                }
                Date now = new Date();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String str = sdf.format(now);
                for (int i = 0; i < headDataRows.size(); ++i) {
                    Object headpk = ((DataRow)headDataRows.get(i)).getValues().get(pkColumn);
                    this.writePkBackStatment.setObject(1, headpk);
                    this.writePkBackStatment.setString(2, billDataHashCodeMap.get(headpk));
                    this.writePkBackStatment.setTimestamp(3, Timestamp.valueOf(str));
                    this.writePkBackStatment.executeUpdate();
                    ++count;
                }
                MonitorManager.getCurrentSrcToMidBill().addWriteBackCount(count);
            }
            catch (SQLException e) {
                throw new DIPException("\u53cd\u5199\u589e\u91cf\u8868\u65f6\u5931\u8d25:" + e.getMessage(), e);
            }
            finally {
                try {
                    logger.info((Object)("EIP\u6210\u529f\u53cd\u5199" + count + "\u6761\u589e\u91cf\u8868\u6570\u636e"));
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBillCount(StructuredTableData structuredTableData, String filterString) throws BOSException {
        StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select count(*) as total, count(distinct ");
        String headPkName = null;
        for (int i = 0; i < header.columns.length; ++i) {
            if (!header.columns[i].isPk) continue;
            headPkName = header.columns[i].name;
            sqlBuf.append("v1.").append(header.columns[i].name).append(") as bill ");
            break;
        }
        sqlBuf.append(" from ").append(this.srcViewName).append(" as v1");
        sqlBuf.append(" where v1.").append(headPkName).append(" in (");
        sqlBuf.append(" select v3.").append(headPkName).append(" from (");
        sqlBuf.append("select v2.").append(headPkName).append(" from ").append(this.srcViewName).append(" as v2").append(" where 1=1");
        if (!StringUtils.isEmpty((String)this.srcWhere)) {
            if (StringUtils.startsWithIgnoreCase((String)this.srcWhere, (String)"where")) {
                this.srcWhere = this.srcWhere.replaceAll("^(?im)where", "");
            }
            if (this.srcWhere.matches("(?im)^and.*")) {
                sqlBuf.append(" ").append(this.srcWhere);
            } else {
                sqlBuf.append(" and ").append(this.srcWhere);
            }
        }
        if (!StringUtils.isEmpty((String)filterString)) {
            if (!(filterString = filterString.trim()).matches("(?im)^and.*")) {
                sqlBuf.append(" and ");
            }
            sqlBuf.append(filterString);
        }
        if (!"and".equalsIgnoreCase(sqlBuf.substring(sqlBuf.length() - 3, sqlBuf.length()))) {
            sqlBuf.append(" and");
        }
        sqlBuf.append(" not exists(select 1 from ").append(this.pkTableName).append(" as p").append(" where v2.").append(headPkName).append(" = p.headpk").append(")");
        sqlBuf.append(" group by v2.").append(headPkName);
        sqlBuf.append(") as v3)");
        ResultSet rs = null;
        PreparedStatement readingStatement = null;
        logger.info((Object)("(EIP)\u6267\u884cKSQL\uff1a" + sqlBuf.toString()));
        System.out.println("(EIP)\u6267\u884cKSQL\uff1a" + sqlBuf.toString());
        try {
            readingStatement = this.connection.prepareStatement(sqlBuf.toString(), 1003, 1007);
            rs = readingStatement.executeQuery();
            while (rs.next()) {
                structuredTableData.setTotalCount(rs.getInt("total"));
                structuredTableData.setBillCount(rs.getInt("bill"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("(EIP)\u6267\u884cKSQL\u5f02\u5e38\uff0cSQL\uff1a" + sqlBuf.toString() + e));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, readingStatement);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)readingStatement);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)readingStatement);
    }

    @Override
    public int getPageSize(Map param) {
        if (this.pageSize <= 0) {
            try {
                Object pageSize = param.get("pageSize");
                this.pageSize = pageSize == null ? DEFAULT_FETCH_SIZE : Integer.parseInt(pageSize.toString());
                int newPageSize = this.pageSize > 100000 ? 100000 : this.pageSize;
                param.put("newPageSize", newPageSize);
                this.pageSize = this.pageSize > 100000 ? DEFAULT_FETCH_SIZE : this.pageSize;
            }
            catch (Exception e) {
                this.pageSize = DEFAULT_FETCH_SIZE;
            }
        }
        return this.pageSize;
    }

    @Override
    public void doMidFeedBack(Context ctx, List pks) throws Exception {
        FeedBackManager.doMidFeedBack((Context)ctx, (List)pks, (StructuredDataModel)this.dataModel);
    }

    @Override
    public void feedbackFinish(List<String> list) throws DIPException {
        if (list == null || list.size() == 0) {
            return;
        }
        int count = 0;
        try {
            if (this.writePkBackStatment == null) {
                String driverType = this.connection.getMetaData().getDatabaseProductName();
                if (driverType.equalsIgnoreCase("PostgreSQL")) {
                    this.pkTableName = this.pkTableName.replace("\"", "");
                }
                this.writePkBackStatment = this.connection.prepareStatement("insert into " + this.pkTableName + "(" + "headpk" + "," + "hashCode" + "," + "createTime" + ") values (?,?,?)");
            }
            Date now = new Date();
            Timestamp time = new Timestamp(now.getTime());
            for (int i = 0; i < list.size(); ++i) {
                String headpk = list.get(i);
                this.writePkBackStatment.setObject(1, headpk);
                this.writePkBackStatment.setString(2, null);
                this.writePkBackStatment.setObject(3, time);
                this.writePkBackStatment.executeUpdate();
                ++count;
            }
            MonitorManager.getCurrentSrcToMidBill().addWriteBackCount(count);
        }
        catch (SQLException e) {
            throw new DIPException("\u53cd\u5199\u589e\u91cf\u8868\u65f6\u5931\u8d25:" + e.getMessage(), e);
        }
        finally {
            try {
                logger.info((Object)("EIP\u6210\u529f\u53cd\u5199" + count + "\u6761\u589e\u91cf\u8868\u6570\u636e"));
            }
            catch (Exception exception) {}
        }
    }

    private String getHeadpkQrySql(Map param) {
        String filterString = null;
        if (param != null) {
            filterString = (String)param.get("filter");
        }
        StringBuilder sqlBuf = new StringBuilder();
        String headPkName = null;
        StructuredDataModel.TableModel[] tableModels = this.dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        for (int i = 0; i < header.columns.length; ++i) {
            if (!header.columns[i].isPk) continue;
            headPkName = header.columns[i].name;
        }
        int pageSize = this.getPageSize(param);
        if (pageSize == 0) {
            sqlBuf.append(" select top 0 v3.").append(headPkName).append(" from (");
        } else {
            sqlBuf.append(" select  v3.").append(headPkName);
            if (((Boolean)param.get("save")).booleanValue()) {
                sqlBuf.append(",0");
            }
            sqlBuf.append(" from (");
        }
        sqlBuf.append("select v2.").append(headPkName).append(" from ").append(this.srcViewName).append(" as v2").append(" where 1=1");
        if (!StringUtils.isEmpty((String)this.srcWhere)) {
            if (StringUtils.startsWithIgnoreCase((String)this.srcWhere, (String)"where")) {
                this.srcWhere = this.srcWhere.replaceAll("^(?im)where", "");
            }
            if (this.srcWhere.matches("(?im)^and.*")) {
                sqlBuf.append(" ").append(this.srcWhere);
            } else {
                sqlBuf.append(" and (").append(this.srcWhere).append(")");
            }
        }
        if (!StringUtils.isEmpty((String)filterString)) {
            if (!(filterString = filterString.trim()).matches("(?im)^and.*")) {
                sqlBuf.append(" and ");
            }
            sqlBuf.append(" (").append(filterString).append(" ) ");
        }
        if (!"and".equalsIgnoreCase(sqlBuf.substring(sqlBuf.length() - 3, sqlBuf.length()))) {
            sqlBuf.append(" and");
        }
        try {
            if (this.connection.getMetaData().getDatabaseProductName().equalsIgnoreCase("PostgreSQL")) {
                this.pkTableName = this.pkTableName.replace("\"", "");
                String tableId = this.pkTableName.substring(6);
                this.pkTableName = BillMappingHelper.calc2PkTableName(tableId);
                this.pkTableName = this.pkTableName.replace("\"", "").toLowerCase();
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        sqlBuf.append(" not exists(select 1 from ").append(this.pkTableName).append(" as p").append(" where v2.").append(headPkName).append(" = p.headpk").append(")");
        sqlBuf.append(" group by v2.").append(headPkName);
        sqlBuf.append(") as v3");
        param.put("findPKsSql", sqlBuf);
        return sqlBuf.toString();
    }
}

