/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.eipserviceplugin.execute;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.servlet.openapi.util.QueryUtil;
import com.kingdee.eas.csinterface.async.app.task.handler.IApiUserHandler;
import com.kingdee.eas.csinterface.async.app.task.util.CurrentDealBillUtil;
import com.kingdee.eas.csinterface.async.standardImpl.UserImplDispatcherService;
import com.kingdee.eas.csinterface.eipserviceplugin.execute.AysncIERPExecuterImpl;
import com.kingdee.eas.csinterface.eipserviceplugin.execute.IERPHttpClient;
import com.kingdee.eas.csinterface.eipserviceplugin.model.EASBasicAction;
import com.kingdee.eas.csinterface.eipserviceplugin.model.EIPPluginAdaptorModel;
import com.kingdee.eas.csinterface.eipserviceplugin.model.base.IERPModel;
import com.kingdee.eas.csinterface.openapi.OpenDataRelationFactory;
import com.kingdee.eas.csinterface.util.ClassUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.webservice.WSServiceFactory;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.csinterface.webservice.app.handler.user.ierp.model.FieldDefineModel;
import com.kingdee.eas.framework.CoreBase;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IERPExecute {
    private static final Logger logger = Logger.getLogger(IERPExecute.class);

    public static void initialCache(Context ctx, EIPPluginAdaptorModel adaptorModel) throws BOSException {
        ArrayList<IERPModel> list = new ArrayList<IERPModel>();
        String nameField = "fname_" + BOSLocaleUtil.getShortCode((Locale)ContextUtils.getLocaleFromEnv());
        StringBuffer sqlBuffer = new StringBuffer(1000);
        sqlBuffer.append("select t0.fnumber").append(",t0.").append(nameField).append(" as fname").append(",t0.fsolution, t0.faction, t0.fentityname, t0.factionList").append(",t1.fwsservice").append(" from T_EIP_EipServicePluginAdaptor t0").append(" inner join T_EIP_EipServicePluginAdaptor t1").append(" on t0.ftreeid = t1.fid").append(" where t0.ftreeid = 'lVIAAACqcNdvDiIS'");
        Connection conn = null;
        ResultSet rs = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getQueryConnection((Context)ctx);
            statement = conn.createStatement();
            rs = statement.executeQuery(sqlBuffer.toString());
            while (rs.next()) {
                IERPModel model = new IERPModel();
                model.setNumber(rs.getString("fnumber"));
                model.setName(rs.getString("fname"));
                model.setEntityName(rs.getString("fentityname"));
                model.setSolution(rs.getString("fsolution"));
                model.setActions(rs.getString("faction"));
                model.setActionLists(rs.getString("factionList"));
                model.setLoginservice(rs.getString("fwsservice"));
                list.add(model);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        adaptorModel.setIerpList(list);
    }

    public static void doAdaptor(IServiceContext serviceContext, Context ctx, EIPPluginAdaptorModel adaptorModel, String className, String method) throws BOSException {
        Boolean isMethodBefore = serviceContext.getExecutionMode() == 0;
        if (adaptorModel == null) {
            return;
        }
        BOSObjectType bosType = null;
        try {
            Object coreInfo = ClassUtil.getNewInstance(Class.forName(className));
            if (coreInfo instanceof CoreBase) {
                bosType = ((CoreBase)coreInfo).getType();
            } else if (coreInfo instanceof CoreBaseInfo) {
                bosType = ((CoreBaseInfo)coreInfo).getBOSType();
            }
        }
        catch (ClassNotFoundException e) {
            throw new BOSException("\u62e6\u622a\u7684\u5bf9\u8c61\u975e\u5b9e\u4f53\u5bf9\u8c61\uff0c\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684bosType,\u7c7b\u540d\uff1a" + className);
        }
        String bt = "";
        if (bosType != null) {
            bt = bosType.toString();
        }
        List<IERPModel> erpList = adaptorModel.getIerpList();
        for (IERPModel tempModel : erpList) {
            List<String> actionList;
            if (!StringUtils.equals((String)tempModel.getEntityName(), (String)className)) continue;
            String loginService = tempModel.getLoginservice();
            String apiKey = null;
            WSServiceInfo serviceInfo = null;
            try {
                serviceInfo = IERPExecute.getWSServiceInfo(ctx, loginService, tempModel.getNumber());
                apiKey = serviceInfo.getTree().getIdentification().getApiKey();
            }
            catch (Throwable e) {
                logger.error((Object)("\u62e6\u622a\u670d\u52a1\u5bf9\u5e94\u7684\u8fdc\u7a0b\u670d\u52a1\u83b7\u53d6\u5f02\u5e38\uff08" + loginService + ")" + ThrowableHelper.toString(e)));
                continue;
            }
            String pks = null;
            tempModel.setBosType(bt);
            Boolean isCallback = StringUtils.equals((String)"1", (String)tempModel.getCallback());
            pks = IERPExecute.getObjectPK(serviceContext);
            if (pks != null && isCallback.booleanValue()) {
                Boolean isIgnore = CurrentDealBillUtil.isIgnoreSystem((String)apiKey, (String)bt, (String)method);
                if (isIgnore.booleanValue()) continue;
                try {
                    String[] tempIds = pks.split(",");
                    HashSet<String> idSet = new HashSet<String>(tempIds.length);
                    for (String id : tempIds) {
                        idSet.add(id);
                    }
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("dynaBillId", idSet, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("destBillId", idSet, CompareType.INCLUDE));
                    filter.setMaskString("#0 or #1");
                    IObjectPK[] existPKs = OpenDataRelationFactory.getLocalInstance(ctx).getPKList(filter, null);
                    if (existPKs.length == 0) {
                        continue;
                    }
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
            }
            if ((actionList = tempModel.getActions()) != null && actionList.size() > 0) {
                for (String action : actionList) {
                    String easActions = EASBasicAction.getInstance(action).getMethod();
                    String[] matchActions = easActions.split(";");
                    int len = matchActions.length;
                    for (int i = 0; i < len; ++i) {
                        if (!StringUtils.equals((String)matchActions[i], (String)method)) continue;
                        IERPExecute.innerExecute(serviceContext, ctx, isMethodBefore, bosType, tempModel, serviceInfo, pks, action);
                    }
                }
            }
            Map<String, String[]> actionMap = tempModel.getUserActions();
            for (String tempMethod : actionMap.keySet()) {
                if (!StringUtils.equals((String)tempMethod, (String)method)) continue;
                String action = actionMap.get(tempMethod)[0];
                IApiUserHandler userClass = UserImplDispatcherService.getClass(null, tempModel.getUserImpl());
                List idList = null;
                if (userClass != null && (idList = userClass.getPKList(serviceContext, action)) != null && idList.size() > 0) {
                    pks = com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converList2String(idList, ",", "");
                }
                if (StringUtils.isEmpty((String)pks)) continue;
                String bosTypeStr = null;
                bosTypeStr = StringUtils.isEmpty((String)userClass.getBosType()) ? BOSUuid.read((String)((String)idList.get(0))).getType().toString() : userClass.getBosType();
                tempModel.setBosType(bosTypeStr);
                Boolean isIgnore = CurrentDealBillUtil.isIgnoreSystem((String)apiKey, (String)bosTypeStr, (String)method);
                if (isIgnore.booleanValue()) continue;
                IERPExecute.innerExecute(serviceContext, ctx, isMethodBefore, bosType, tempModel, serviceInfo, pks, action);
            }
        }
    }

    private static void innerExecute(IServiceContext serviceContext, Context ctx, Boolean isMethodBefore, BOSObjectType bosType, IERPModel tempModel, WSServiceInfo serviceInfo, String pks, String action) throws BOSException {
        if (isMethodBefore.booleanValue()) {
            if ("delete".equals(action)) {
                String solution = tempModel.getSolution();
                FieldDefineModel fieldModel = IERPHttpClient.getPKFieldCache(ctx, serviceInfo, solution);
                Set fields = fieldModel.getFields();
                String sendData = QueryUtil.getSimpleDataOP(ctx, pks, fields, bosType, tempModel.getUserImpl(), action);
                if (tempModel.isSync()) {
                    IERPExecute.executeDelete(ctx, tempModel, action, serviceContext, sendData);
                } else {
                    AysncIERPExecuterImpl.orderTask(ctx, tempModel, serviceContext, action, sendData);
                }
            }
        } else {
            if (!isMethodBefore.booleanValue() && "delete".equals(action)) {
                return;
            }
            if ("addnew".equals(action) || "update".equals(action) || "submit".equals(action)) {
                if (tempModel.isSync()) {
                    IERPExecute.execute(ctx, tempModel, action, serviceContext, pks);
                } else {
                    AysncIERPExecuterImpl.orderTask(ctx, tempModel, serviceContext, action, pks);
                }
            } else if ("audit".equals(action) || "unaudit".equals(action) || "enable".equals(action) || "disable".equals(action)) {
                if (tempModel.isSync()) {
                    IERPExecute.executeOP(ctx, tempModel, action, serviceContext, pks);
                } else {
                    AysncIERPExecuterImpl.orderTask(ctx, tempModel, serviceContext, action, pks);
                }
            } else if (tempModel.isSync()) {
                IERPExecute.execute(ctx, tempModel, action, serviceContext, pks);
            } else {
                AysncIERPExecuterImpl.orderTask(ctx, tempModel, serviceContext, action, pks);
            }
        }
    }

    protected static String getObjectPK(IServiceContext serviceContext) {
        String objectPK = null;
        Object[] obj = serviceContext.getOperationParameters();
        Object objValue = obj[1];
        if (objValue instanceof IObjectPK) {
            objectPK = ((IObjectPK)objValue).toString();
        } else if (objValue instanceof IObjectValue) {
            objectPK = ((IObjectValue)objValue).getString("id");
        } else if (objValue instanceof IObjectPK[]) {
            IObjectPK[] tempValue = (IObjectPK[])objValue;
            ArrayList<String> idList = new ArrayList<String>(tempValue.length);
            for (int i = 0; i < tempValue.length; ++i) {
                idList.add(tempValue[i].toString());
            }
            objectPK = com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converList2String(idList, ",", "");
        } else if (objValue instanceof IObjectValue[]) {
            IObjectValue[] tempValue = (IObjectValue[])objValue;
            ArrayList<String> idList = new ArrayList<String>(tempValue.length);
            for (int i = 0; i < tempValue.length; ++i) {
                idList.add(tempValue[i].getString("id"));
            }
            objectPK = com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converList2String(idList, ",", "");
        } else if (objValue instanceof IObjectCollection) {
            IObjectCollection tempValue = (IObjectCollection)objValue;
            ArrayList<String> idList = new ArrayList<String>(tempValue.size());
            Iterator ite = tempValue.iterator();
            while (ite.hasNext()) {
                idList.add(((IObjectValue)ite.next()).getString("id"));
            }
            objectPK = com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converList2String(idList, ",", "");
        } else if (objValue instanceof CoreBaseCollection) {
            CoreBaseCollection tempValue = (CoreBaseCollection)objValue;
            ArrayList<String> idList = new ArrayList<String>(tempValue.size());
            Iterator ite = tempValue.iterator();
            while (ite.hasNext()) {
                idList.add(((CoreBaseInfo)ite.next()).getId().toString());
            }
            objectPK = com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converList2String(idList, ",", "");
        }
        return objectPK;
    }

    protected static void execute(Context ctx, IERPModel model, String action, IServiceContext serviceContext, String objectPK) throws BOSException {
        String loginService = model.getLoginservice();
        boolean isSync = model.isSync();
        WSServiceInfo serviceInfo = IERPExecute.getWSServiceInfo(ctx, loginService, model.getNumber());
        String solution = model.getSolution();
        FieldDefineModel fieldModel = IERPHttpClient.getFieldDefineCache(ctx, serviceInfo, solution);
        String sendData = QueryUtil.getSimpleData(ctx, objectPK, fieldModel.getFields(), BOSObjectType.create((String)model.getBosType()), model.getUserImpl(), action, serviceContext);
        Map resultMap = null;
        if ("submit".equals(action)) {
            resultMap = IERPHttpClient.post(ctx, serviceInfo, "save", model.getAfterAction(action), solution, sendData, isSync, model.getPublishId());
            resultMap = IERPHttpClient.post(ctx, serviceInfo, "submit", model.getAfterAction(action), solution, sendData, isSync, model.getPublishId());
        } else {
            String actAction = IERPExecute.getIERPAction(model, action);
            if (StringUtils.isEmpty((String)actAction)) {
                actAction = action;
            }
            resultMap = IERPHttpClient.post(ctx, serviceInfo, actAction, model.getAfterAction(action), solution, sendData, isSync, model.getPublishId());
        }
        String extendClass = model.getExtendClass();
    }

    protected static void executeDelete(Context ctx, IERPModel model, String action, IServiceContext serviceContext, String sendData) throws BOSException {
        String loginService = model.getLoginservice();
        WSServiceInfo serviceInfo = IERPExecute.getWSServiceInfo(ctx, loginService, model.getNumber());
        String solution = model.getSolution();
        Map resultMap = IERPHttpClient.post(ctx, serviceInfo, IERPExecute.getIERPAction(model, action), model.getAfterAction(action), solution, sendData, model.isSync(), model.getPublishId());
        String extendClass = model.getExtendClass();
    }

    protected static void executeOP(Context ctx, IERPModel model, String action, IServiceContext serviceContext, String objectPK) throws BOSException {
        String solution;
        String loginService = model.getLoginservice();
        WSServiceInfo serviceInfo = IERPExecute.getWSServiceInfo(ctx, loginService, model.getNumber());
        FieldDefineModel fieldModel = IERPHttpClient.getPKFieldCache(ctx, serviceInfo, solution = model.getSolution());
        if (fieldModel == null) {
            throw new BOSException("\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a:" + solution + ",\u7684\u96c6\u6210\u65b9\u6848\u3002");
        }
        String sendData = QueryUtil.getSimpleDataOP(ctx, objectPK, fieldModel.getFields(), BOSObjectType.create((String)model.getBosType()), model.getUserImpl(), action);
        Map resultMap = IERPHttpClient.post(ctx, serviceInfo, IERPExecute.getIERPAction(model, action), model.getAfterAction(action), solution, sendData, model.isSync(), model.getPublishId());
        String extendClass = model.getExtendClass();
    }

    private static String getIERPAction(IERPModel model, String easAction) {
        String actualAction = model.getActualAction(easAction);
        if (easAction != null && !"".equals(easAction) && "".equals(actualAction)) {
            actualAction = easAction;
        } else if ("addnew".equals(actualAction) || "update".equals(actualAction) || "updatePartial".equals(actualAction)) {
            actualAction = "save";
        }
        return actualAction;
    }

    public static WSServiceInfo getWSServiceInfo(Context ctx, String serviceId, String adaptorNumber) throws BOSException {
        WSServiceInfo serviceInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("enabled"));
        sic.add(new SelectorItemInfo("tree.serviceURL"));
        sic.add(new SelectorItemInfo("tree.port"));
        sic.add(new SelectorItemInfo("tree.serveralias"));
        sic.add(new SelectorItemInfo("tree.nameSpace"));
        sic.add(new SelectorItemInfo("tree.number"));
        sic.add(new SelectorItemInfo("tree.identification.apiKey"));
        sic.add(new SelectorItemInfo("openId"));
        sic.add(new SelectorItemInfo("serviceUser"));
        sic.add(new SelectorItemInfo("password"));
        sic.add(new SelectorItemInfo("dataCenter"));
        sic.add(new SelectorItemInfo("tenantId"));
        sic.add(new SelectorItemInfo("serviceMethod"));
        sic.add(new SelectorItemInfo("identification"));
        sic.add(new SelectorItemInfo("srcSystem"));
        sic.add(new SelectorItemInfo("appid"));
        sic.add(new SelectorItemInfo("appSecuret"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("enabled", (Object)true, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)serviceId, CompareType.EQUALS));
        view.setFilter(filter);
        try {
            serviceInfo = WSServiceFactory.getLocalInstance(ctx).getWSServiceInfo(view.toString());
            if (serviceInfo == null) {
                throw new BOSException("\u4e0b\u4e00\u4ee3\u62e6\u622a\u670d\u52a1(" + adaptorNumber + ")\u5bf9\u5e94\u7684\u767b\u9646\u670d\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002");
            }
            if (!serviceInfo.isEnabled()) {
                throw new BOSException("\u4e0b\u4e00\u4ee3\u767b\u9646\u670d\u52a1(" + serviceInfo.getNumber() + ")\u672a\u542f\u7528\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002");
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return serviceInfo;
    }
}

